/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bam.analyzer.task;

import java.util.HashMap;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.util.AXIOMUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.bam.analyzer.Utils;
import org.wso2.carbon.bam.analyzer.engine.Analyzer;
import org.wso2.carbon.bam.analyzer.engine.AnalyzerConfigConstants;
import org.wso2.carbon.bam.analyzer.engine.AnalyzerException;
import org.wso2.carbon.bam.analyzer.engine.AnalyzerSequence;
import org.wso2.carbon.bam.analyzer.engine.DataContext;
import org.wso2.carbon.bam.analyzer.task.AbstractAnalyzerTask;

public class BAMDefaultAnalyzerTask
extends AbstractAnalyzerTask {
    private static Log log = LogFactory.getLog(BAMDefaultAnalyzerTask.class);
    private Map<String, String> props;

    @Override
    public void setProperties(Map<String, String> props) {
        this.props = props;
    }

    @Override
    public void init() {
    }

    @Override
    public void execute() {
        String analyserSeqXML = this.getProperties().get("analyzerSequence");
        try {
            DataContext ctxt = this.createDataContext(this.getProperties());
            OMElement analyserSeqEle = AXIOMUtil.stringToOM((String)analyserSeqXML);
            AnalyzerSequence analyserSequence = Utils.getAnalyzerSequence(ctxt.getExecutingTenant(), analyserSeqEle);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Starting analyzer sequence " + analyserSequence.getName() + ".."));
            }
            for (Analyzer analyzer : analyserSequence.getAnalyzers()) {
                analyzer.analyze(ctxt);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Finished executing analyzer sequence " + analyserSequence.getName() + ".."));
            }
        }
        catch (AnalyzerException e) {
            String msg = "Error while processing analyzers";
            log.error((Object)msg, (Throwable)e);
        }
        catch (XMLStreamException e) {
            String msg = "Error while converting analyzer configuration XML string to OM";
            log.error((Object)msg, (Throwable)e);
        }
    }

    public Map<String, String> getProperties() {
        return this.props;
    }

    private DataContext createDataContext(Map<String, String> props) {
        int tenantId = Integer.parseInt(props.get(AnalyzerConfigConstants.TENANT_ID));
        String analyserSeqName = props.get(AnalyzerConfigConstants.ANALYZER_SEQUENCE_NAME);
        HashMap<String, String> credentials = new HashMap<String, String>();
        credentials.put("username", props.get("username"));
        credentials.put("password", props.get("password"));
        DataContext ctxt = new DataContext(tenantId);
        ctxt.setCredentials(credentials);
        ctxt.setSequenceProperties(analyserSeqName, new HashMap());
        return ctxt;
    }
}

