/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bam.analyzer.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.bam.analyzer.service.CursorDTO;
import org.wso2.carbon.bam.analyzer.service.IndexDTO;
import org.wso2.carbon.bam.analyzer.service.TableDTO;
import org.wso2.carbon.bam.core.configurations.DataSourceType;
import org.wso2.carbon.bam.core.configurations.IndexConfiguration;
import org.wso2.carbon.bam.core.configurations.TableConfiguration;
import org.wso2.carbon.bam.core.dataobjects.Cursor;
import org.wso2.carbon.bam.core.persistence.IndexManager;
import org.wso2.carbon.bam.core.persistence.MetaDataManager;
import org.wso2.carbon.bam.core.persistence.PersistenceManager;
import org.wso2.carbon.bam.core.persistence.cassandra.CassandraStoreFactory;
import org.wso2.carbon.bam.core.persistence.exceptions.ConfigurationException;
import org.wso2.carbon.bam.core.persistence.exceptions.IndexingException;
import org.wso2.carbon.bam.core.persistence.exceptions.StoreException;
import org.wso2.carbon.bam.core.utils.Utils;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.core.AbstractAdmin;

public class IndexMgtService
extends AbstractAdmin {
    private static final Log log = LogFactory.getLog(IndexMgtService.class);

    public int getTableCount(boolean includeAutoGenerated) throws ConfigurationException {
        Map<String, String> credentials = this.getConnectionParameters();
        MetaDataManager metaDataManager = MetaDataManager.getInstance();
        List tables = metaDataManager.getAllTableMetaData(credentials);
        if (tables != null) {
            Iterator iterator = tables.iterator();
            while (iterator.hasNext()) {
                TableConfiguration configuration = (TableConfiguration)iterator.next();
                String tableName = configuration.getTableName();
                if (tableName.equals("EVENT") || tableName.equals("META") || tableName.equals("CORRELATION")) {
                    iterator.remove();
                    continue;
                }
                if (includeAutoGenerated || !configuration.getAutoGenerated()) continue;
                iterator.remove();
            }
            return tables.size();
        }
        return 0;
    }

    public TableDTO[] getAllTableMetaData(boolean includeAutoGenerated) throws ConfigurationException {
        Map<String, String> credentials = this.getConnectionParameters();
        MetaDataManager metaDataManager = MetaDataManager.getInstance();
        List tables = metaDataManager.getAllTableMetaData(credentials);
        if (tables != null) {
            Iterator iterator = tables.iterator();
            while (iterator.hasNext()) {
                TableConfiguration configuration = (TableConfiguration)iterator.next();
                String tableName = configuration.getTableName();
                if (tableName.equals("EVENT") || tableName.equals("META") || tableName.equals("CORRELATION")) {
                    iterator.remove();
                    continue;
                }
                if (includeAutoGenerated || !configuration.getAutoGenerated()) continue;
                iterator.remove();
            }
        }
        ArrayList<TableDTO> tableDTOs = new ArrayList<TableDTO>();
        for (TableConfiguration table : tables) {
            TableDTO tableDTO = new TableDTO();
            tableDTO.setTableName(table.getTableName());
            if (table.getColumns() != null) {
                tableDTO.setColumns(table.getColumns().toArray(new String[0]));
            }
            tableDTO.setDataSourceType(table.getDataSourceType().getName());
            tableDTOs.add(tableDTO);
        }
        return tableDTOs.toArray(new TableDTO[0]);
    }

    public TableDTO[] getTableMetaData(int pageNumber, int tablesPerPage, boolean includeAutoGenerated) throws ConfigurationException {
        Map<String, String> credentials = this.getConnectionParameters();
        MetaDataManager metaDataManager = MetaDataManager.getInstance();
        List tables = metaDataManager.getAllTableMetaData(credentials);
        Iterator iterator = tables.iterator();
        while (iterator.hasNext()) {
            TableConfiguration configuration = (TableConfiguration)iterator.next();
            String tableName = configuration.getTableName();
            if (tableName.equals("EVENT") || tableName.equals("META") || tableName.equals("CORRELATION")) {
                iterator.remove();
                continue;
            }
            if (includeAutoGenerated || !configuration.getAutoGenerated()) continue;
            iterator.remove();
        }
        ArrayList pageOfTables = new ArrayList();
        if (tables != null) {
            if (tables.size() >= tablesPerPage * pageNumber + tablesPerPage) {
                for (int i = 0; i < tablesPerPage; ++i) {
                    pageOfTables.add(tables.get(tablesPerPage * pageNumber + i));
                }
            } else if (tables.size() <= tablesPerPage * pageNumber) {
                int size = tables.size();
                int resultCount = size < tablesPerPage ? size : tablesPerPage;
                for (int i = 1; i < resultCount; ++i) {
                    pageOfTables.add(tables.get(size - i));
                }
            } else {
                for (int i = tablesPerPage * pageNumber; i < tables.size(); ++i) {
                    pageOfTables.add(tables.get(i));
                }
            }
        }
        ArrayList<TableDTO> tableDTOs = new ArrayList<TableDTO>();
        for (TableConfiguration table : pageOfTables) {
            TableDTO tableDTO = new TableDTO();
            tableDTO.setTableName(table.getTableName());
            if (table.getColumns() != null) {
                tableDTO.setColumns(table.getColumns().toArray(new String[0]));
            }
            tableDTO.setDataSourceType(table.getDataSourceType().getName());
            tableDTOs.add(tableDTO);
        }
        return tableDTOs.toArray(new TableDTO[0]);
    }

    public TableDTO getSingleTableMetaData(String tableName) throws ConfigurationException {
        int tenantId = CarbonContext.getCurrentContext().getTenantId();
        this.getConnectionParameters();
        MetaDataManager metaDataManager = MetaDataManager.getInstance();
        TableConfiguration configuration = metaDataManager.getTableMetaData(tenantId, tableName);
        TableDTO tableDTO = new TableDTO();
        tableDTO.setTableName(configuration.getTableName());
        if (configuration.getColumns() != null) {
            tableDTO.setColumns(configuration.getColumns().toArray(new String[0]));
        }
        tableDTO.setDataSourceType(configuration.getDataSourceType().getName());
        return tableDTO;
    }

    public void createTable(TableDTO table) throws ConfigurationException, StoreException {
        Map<String, String> credentials = this.getConnectionParameters();
        ArrayList<String> tableColumns = new ArrayList<String>();
        if (table.getColumns() != null) {
            for (String tableColumn : tableColumns) {
                tableColumns.add(tableColumn);
            }
        }
        MetaDataManager metaDataManager = MetaDataManager.getInstance();
        TableConfiguration tableConfiguration = metaDataManager.createTableMetaData(table.getTableName(), tableColumns, DataSourceType.valueOf((String)table.getDataSourceType()), false);
        PersistenceManager persistenceManager = new PersistenceManager();
        persistenceManager.createTable(credentials, tableConfiguration);
    }

    public void deleteTable(String tableName) throws ConfigurationException, StoreException {
        Map<String, String> credentials = this.getConnectionParameters();
        PersistenceManager persistenceManager = new PersistenceManager();
        persistenceManager.deleteTable(credentials, tableName);
    }

    public CursorDTO[] getAllCursors() throws ConfigurationException {
        Map<String, String> credentials = this.getConnectionParameters();
        MetaDataManager metaDataManager = MetaDataManager.getInstance();
        List cursors = metaDataManager.getAllCursorMetaData(credentials);
        ArrayList<CursorDTO> cursorDTOs = new ArrayList<CursorDTO>();
        for (Cursor cursor : cursors) {
            CursorDTO cursorDTO = new CursorDTO();
            cursorDTO.setCursorName(cursor.getCursorName());
            cursorDTO.setResumePoint(cursor.getResumePoint());
            cursorDTOs.add(cursorDTO);
        }
        return cursorDTOs.toArray(new CursorDTO[0]);
    }

    public void createIndex(IndexDTO index) throws ConfigurationException, IndexingException {
        DataSourceType dataSourceType = DataSourceType.valueOf((String)index.getDataSourceType());
        MetaDataManager metaDataManager = MetaDataManager.getInstance();
        HashMap<String, String> configurations = new HashMap<String, String>();
        configurations.put("cron", index.getCron());
        configurations.put("granularity", index.getGranularity());
        IndexConfiguration configuration = metaDataManager.createIndexMetaData(index.getIndexName(), index.getIndexedTable(), index.getIndexedColumns(), dataSourceType, configurations);
        Map<String, String> credentials = this.getConnectionParameters();
        IndexManager indexManager = IndexManager.getInstance();
        indexManager.createIndex(configuration, credentials);
    }

    public void editIndex(IndexDTO index) throws ConfigurationException, IndexingException {
        DataSourceType dataSourceType = DataSourceType.valueOf((String)index.getDataSourceType());
        MetaDataManager metaDataManager = MetaDataManager.getInstance();
        HashMap<String, String> configurations = new HashMap<String, String>();
        configurations.put("cron", index.getCron());
        IndexConfiguration configuration = metaDataManager.createIndexMetaData(index.getIndexName(), index.getIndexedTable(), index.getIndexedColumns(), dataSourceType, configurations);
        Map<String, String> credentials = this.getConnectionParameters();
        IndexManager indexManager = IndexManager.getInstance();
        indexManager.editIndex(configuration, credentials);
    }

    public void deleteIndex(String indexName) throws ConfigurationException, IndexingException {
        Map<String, String> credentials = this.getConnectionParameters();
        IndexManager indexManager = IndexManager.getInstance();
        indexManager.deleteIndex(indexName, credentials);
    }

    public int getIndexCount() throws ConfigurationException {
        Map<String, String> credentials = this.getConnectionParameters();
        MetaDataManager metaDataManager = MetaDataManager.getInstance();
        List indexes = metaDataManager.getAllIndexMetaData(credentials);
        if (indexes != null) {
            return indexes.size();
        }
        return 0;
    }

    public IndexDTO[] getIndexMetaData(int pageNumber, int indexesPerPage) throws ConfigurationException {
        Map<String, String> credentials = this.getConnectionParameters();
        MetaDataManager metaDataManager = MetaDataManager.getInstance();
        List indexes = metaDataManager.getAllIndexMetaData(credentials);
        ArrayList pageOfIndexes = new ArrayList();
        if (indexes != null) {
            int i;
            if (indexes.size() >= indexesPerPage * pageNumber + indexesPerPage) {
                for (i = 0; i < indexesPerPage; ++i) {
                    pageOfIndexes.add(indexes.get(indexesPerPage * pageNumber + i));
                }
            } else if (indexes.size() <= indexesPerPage * pageNumber) {
                int size = indexes.size();
                int resultCount = size < indexesPerPage ? size : indexesPerPage;
                for (int i2 = 1; i2 < resultCount; ++i2) {
                    pageOfIndexes.add(indexes.get(size - resultCount));
                }
            } else {
                for (i = indexesPerPage * pageNumber; i < indexes.size(); ++i) {
                    pageOfIndexes.add(indexes.get(i));
                }
            }
        }
        ArrayList<IndexDTO> indexDTOs = new ArrayList<IndexDTO>();
        for (IndexConfiguration configuration : pageOfIndexes) {
            IndexDTO indexDTO = new IndexDTO();
            indexDTO.setIndexName(configuration.getIndexName());
            indexDTO.setIndexedTable(configuration.getIndexedTable());
            indexDTO.setIndexedColumns(configuration.getIndexedColumns());
            indexDTO.setDataSourceType(configuration.getDataSourceType().name());
            indexDTO.setAutoGenerated(configuration.isAutoGenerated());
            indexDTO.setManuallyIndexed(configuration.isManuallyIndexed());
            indexDTOs.add(indexDTO);
        }
        return indexDTOs.toArray(new IndexDTO[0]);
    }

    public IndexDTO getIndex(String indexName) throws ConfigurationException {
        Map<String, String> credentials = this.getConnectionParameters();
        MetaDataManager metaDataManager = MetaDataManager.getInstance();
        IndexConfiguration configuration = metaDataManager.getIndexMetaData(credentials, indexName);
        if (configuration == null) {
            String msg = "Check whether You have created and index with name: " + indexName + " Or you have provided valid credentials";
            log.error((Object)msg);
            throw new ConfigurationException(msg);
        }
        DataSourceType type = configuration.getDataSourceType();
        IndexDTO index = new IndexDTO();
        index.setIndexName(configuration.getIndexName());
        index.setIndexedTable(configuration.getIndexedTable());
        index.setDataSourceType(type.getName() + ":" + type.isManuallyIndexed());
        index.setAutoGenerated(configuration.isAutoGenerated());
        index.setManuallyIndexed(configuration.isManuallyIndexed());
        index.setIndexedColumns(configuration.getIndexedColumns());
        return index;
    }

    public String[] getIndexValues(String indexName, String indexedColumn) throws ConfigurationException, IndexingException {
        Map<String, String> credentials = this.getConnectionParameters();
        IndexManager indexManager = IndexManager.getInstance();
        List indexValues = indexManager.getIndexValues(indexName, indexedColumn, credentials);
        if (indexValues != null) {
            return indexValues.toArray(new String[0]);
        }
        return null;
    }

    public String[] getSubIndexValues(String indexName, String subIndex, String subIndexValue) throws ConfigurationException, IndexingException {
        Map<String, String> credentials = this.getConnectionParameters();
        IndexManager indexManager = IndexManager.getInstance();
        String[] indexValues = indexManager.getSubIndexValues(indexName, subIndex, subIndexValue, credentials);
        if (indexValues != null) {
            return indexValues;
        }
        return null;
    }

    public String getDataSourceTypeOfTable(String tableName) throws ConfigurationException {
        int tenantId = CarbonContext.getCurrentContext().getTenantId();
        MetaDataManager metaDataManager = MetaDataManager.getInstance();
        TableConfiguration configuration = metaDataManager.getTableMetaData(tenantId, tableName);
        DataSourceType type = configuration.getDataSourceType();
        return type.getName() + ":" + type.isManuallyIndexed();
    }

    public String[] getDataSourceTypes() {
        PersistenceManager persistenceManager = new PersistenceManager();
        DataSourceType[] dataSourceTypes = persistenceManager.getDataSourceTypes();
        ArrayList<String> dataSourceInfo = new ArrayList<String>();
        for (DataSourceType dataSourceType : dataSourceTypes) {
            dataSourceInfo.add(dataSourceType.getName() + ":" + dataSourceType.isManuallyIndexed());
        }
        Object[] dataSourceTypeArray = dataSourceInfo.toArray(new String[0]);
        Arrays.sort(dataSourceTypeArray);
        return dataSourceTypeArray;
    }

    private Map<String, String> getConnectionParameters() throws ConfigurationException {
        int tenantId = CarbonContext.getCurrentContext().getTenantId();
        Map credentials = Utils.getConnectionParameters((int)tenantId);
        if (!this.credentialsValid(credentials)) {
            throw new ConfigurationException("Credentials invalid or not supplied yet..");
        }
        try {
            CassandraStoreFactory.getInstance().getDataStore(credentials);
        }
        catch (StoreException e) {
            throw new ConfigurationException("Unable to initialize meta data store..");
        }
        return credentials;
    }

    private boolean credentialsValid(Map<String, String> credentials) {
        if (credentials == null) {
            return false;
        }
        if (credentials.size() < 2) {
            return false;
        }
        for (Map.Entry<String, String> entry : credentials.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (key == null || value == null) {
                return false;
            }
            if (key.equals("username") || key.equals("password")) continue;
            return false;
        }
        return true;
    }
}

