/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bam.analyzer.service;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.util.AXIOMUtil;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.bam.analyzer.Utils;
import org.wso2.carbon.bam.analyzer.analyzers.IndexingAnalyzer;
import org.wso2.carbon.bam.analyzer.engine.Analyzer;
import org.wso2.carbon.bam.analyzer.engine.AnalyzerException;
import org.wso2.carbon.bam.analyzer.engine.AnalyzerSequence;
import org.wso2.carbon.bam.analyzer.task.BAMTaskInfo;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.core.AbstractAdmin;
import org.wso2.carbon.core.multitenancy.SuperTenantCarbonContext;
import org.wso2.carbon.ntask.common.TaskException;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.session.UserRegistry;

public class AnalyzerMgtService
extends AbstractAdmin {
    private static final Log log = LogFactory.getLog(AnalyzerMgtService.class);

    public boolean addTask(String analyzerXML) throws AnalyzerException {
        int tenantId = CarbonContext.getCurrentContext().getTenantId();
        try {
            UserRegistry configSystemRegistry = Utils.getRegistryService().getConfigSystemRegistry(tenantId);
            OMElement analyzerEl = AXIOMUtil.stringToOM((String)analyzerXML);
            AnalyzerSequence analyzerSequence = Utils.getAnalyzerSequence(tenantId, analyzerEl);
            Resource analyzerSeqResource = configSystemRegistry.newResource();
            analyzerSeqResource.setContent((Object)analyzerXML);
            analyzerSeqResource.setMediaType("text/xml");
            configSystemRegistry.put("/components/org.wso2.carbon.bam.analyzer/analyzers/" + analyzerSequence.getName(), analyzerSeqResource);
            this.updateTenantTracker("analyzerTracker");
            Map credentials = org.wso2.carbon.bam.core.utils.Utils.getConnectionParameters();
            BAMTaskInfo taskInfo = new BAMTaskInfo();
            taskInfo.setAnlyzerSequence(analyzerSequence);
            taskInfo.setCredentials(credentials);
            taskInfo.setAnalyzerSeqXML(analyzerEl);
            Utils.getEngine().startAnalyzerSequence(taskInfo);
            log.info((Object)("Added analyzer sequence : " + analyzerSequence.getName() + " by tenant : " + tenantId));
        }
        catch (RegistryException e) {
            String message = "Error adding analyzer config to registry for tenant : " + tenantId;
            log.error((Object)message, (Throwable)e);
            throw new AnalyzerException(message);
        }
        catch (XMLStreamException e) {
            String message = "Error parsing analyzer configuration for tenant : " + tenantId;
            log.error((Object)message, (Throwable)e);
            throw new AnalyzerException(message);
        }
        catch (Exception e) {
            String message = "Error while scheduling analyzer task for tenant : " + tenantId;
            log.error((Object)message, (Throwable)e);
            throw new AnalyzerException(message);
        }
        return true;
    }

    public boolean editTask(String analyzerXML) throws AnalyzerException {
        this.deleteTask(analyzerXML);
        this.addTask(analyzerXML);
        return true;
    }

    public boolean deleteTask(String analyzerXML) throws AnalyzerException {
        int tenantId = CarbonContext.getCurrentContext().getTenantId();
        try {
            UserRegistry configSystemRegistry = Utils.getRegistryService().getConfigSystemRegistry(tenantId);
            OMElement omElement = AXIOMUtil.stringToOM((String)analyzerXML);
            AnalyzerSequence analyzerSequence = Utils.getAnalyzerSequence(tenantId, omElement);
            Resource analyzerSeqResource = configSystemRegistry.newResource();
            analyzerSeqResource.setContent((Object)analyzerXML);
            if (!configSystemRegistry.resourceExists("/components/org.wso2.carbon.bam.analyzer/analyzers/" + analyzerSequence.getName())) {
                String message = "Analyzer sequence does not exist.";
                log.error((Object)message);
                throw new AnalyzerException(message);
            }
            configSystemRegistry.delete("/components/org.wso2.carbon.bam.analyzer/analyzers/" + analyzerSequence.getName());
            Utils.getEngine().deleteAnalyzerSequence(analyzerSequence, tenantId);
            for (Analyzer analyzer : analyzerSequence.getAnalyzers()) {
                if (!(analyzer instanceof IndexingAnalyzer)) continue;
            }
        }
        catch (RegistryException e) {
            String message = "Error adding analyzer config to registry for tenant : " + tenantId;
            log.error((Object)message, (Throwable)e);
            throw new AnalyzerException(message);
        }
        catch (XMLStreamException e) {
            String message = "Error parsing analyzer configuration for tenant : " + tenantId;
            log.error((Object)message, (Throwable)e);
            throw new AnalyzerException(message);
        }
        catch (TaskException e) {
            String message = "Unable to delete analyser sequence";
            log.error((Object)message, (Throwable)e);
            throw new AnalyzerException(message);
        }
        return true;
    }

    public String[] getAnalyzerXMLs() throws AnalyzerException {
        int tenantId = CarbonContext.getCurrentContext().getTenantId();
        List<String> analyzerSeqXML = Utils.getEngine().getAnalyzerSeqXMLs(tenantId);
        return analyzerSeqXML.toArray(new String[analyzerSeqXML.size()]);
    }

    public String getAnalyzerXML(String analyzerSeqName) throws AnalyzerException {
        int tenantId = CarbonContext.getCurrentContext().getTenantId();
        return Utils.getEngine().getAnalyzerSeqXML(tenantId, analyzerSeqName);
    }

    public boolean pauseTask(String analyzerXML) {
        return true;
    }

    private void updateTenantTracker(String trackerType) throws RegistryException {
        int tenantId = CarbonContext.getCurrentContext().getTenantId();
        ConfigurationContext superTenantContext = Utils.getConfigurationContextService().getServerConfigContext();
        UserRegistry superTenantRegistry = Utils.getRegistryService().getConfigSystemRegistry(SuperTenantCarbonContext.getCurrentContext((ConfigurationContext)superTenantContext).getTenantId());
        Resource tenantTrackerResource = null;
        String trackerPath = "/components/org.wso2.carbon.bam.analyzer/tenantTracker/" + trackerType;
        if (superTenantRegistry.resourceExists(trackerPath)) {
            tenantTrackerResource = superTenantRegistry.get(trackerPath);
            ArrayList<String> propertyValues = tenantTrackerResource.getPropertyValues("Tenants");
            if (propertyValues == null) {
                propertyValues = new ArrayList<String>();
            }
            propertyValues.add(String.valueOf(tenantId));
            HashSet<String> uniqueProperties = new HashSet<String>();
            uniqueProperties.addAll(propertyValues);
            propertyValues.clear();
            for (String id : uniqueProperties) {
                propertyValues.add(id);
            }
            tenantTrackerResource.setProperty("Tenants", propertyValues);
        } else {
            tenantTrackerResource = superTenantRegistry.newResource();
            ArrayList<String> propertyValues = new ArrayList<String>();
            propertyValues.add(String.valueOf(tenantId));
            HashSet<String> uniqueProperties = new HashSet<String>();
            uniqueProperties.addAll(propertyValues);
            propertyValues.clear();
            for (String id : uniqueProperties) {
                propertyValues.add(id);
            }
            tenantTrackerResource.setProperty("Tenants", propertyValues);
        }
        superTenantRegistry.put(trackerPath, tenantTrackerResource);
    }
}

