/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bam.analyzer.internal;

import java.io.File;
import java.io.FileInputStream;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.bam.analyzer.Utils;
import org.wso2.carbon.bam.analyzer.engine.AnalyzerEngine;
import org.wso2.carbon.core.multitenancy.SuperTenantCarbonContext;
import org.wso2.carbon.ntask.core.TaskManager;
import org.wso2.carbon.utils.AbstractAxis2ConfigurationContextObserver;

public class TenantAnalyzerInitializer
extends AbstractAxis2ConfigurationContextObserver {
    private static final Log log = LogFactory.getLog(TenantAnalyzerInitializer.class);
    private static final String MONITOR_CONFIG_LOCATION = "monitor.config.location";
    private static final String MONITOR_CONFIG = "monitor-config";

    public void createdConfigurationContext(ConfigurationContext configurationContext) {
        String tenantDomain = SuperTenantCarbonContext.getCurrentContext((ConfigurationContext)configurationContext).getTenantDomain();
        log.info((Object)("Intializing the analyzer Configuration for the tenant domain : " + tenantDomain));
        try {
            File tenantAxis2Repo = new File(configurationContext.getAxisConfiguration().getRepository().getFile());
            File analyzerConfigDir = new File(tenantAxis2Repo, MONITOR_CONFIG);
            if (!analyzerConfigDir.exists() && !analyzerConfigDir.mkdir()) {
                log.fatal((Object)("Couldn't create the monitor-config root on the file system for the tenant domain : " + tenantDomain));
                return;
            }
            String analyzerConfigsDirLocation = analyzerConfigDir.getAbsolutePath();
            AxisConfiguration axisConfig = configurationContext.getAxisConfiguration();
            axisConfig.addParameter(MONITOR_CONFIG_LOCATION, (Object)analyzerConfigsDirLocation);
            String analyzerFilePath = analyzerConfigsDirLocation + File.separator + "analyzer.xml";
            FileInputStream analyzerStream = new FileInputStream(analyzerFilePath);
            TaskManager taskManager = Utils.getTaskService().getTaskManager("BAM_ANALYSER_TASK");
            Utils.setEngine(new AnalyzerEngine(taskManager));
            if (log.isDebugEnabled()) {
                log.debug((Object)"BAM analyzer bundle is activated");
            }
        }
        catch (Exception e) {
            log.error((Object)("Couldn't initialize monitoring configuration for tenant: " + tenantDomain), (Throwable)e);
        }
    }
}

