/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bam.analyzer.internal;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.service.component.ComponentContext;
import org.wso2.carbon.bam.analyzer.Utils;
import org.wso2.carbon.bam.analyzer.engine.AnalyzerEngine;
import org.wso2.carbon.bam.core.persistence.IndexManager;
import org.wso2.carbon.bam.core.persistence.IndexingTaskProvider;
import org.wso2.carbon.cassandra.dataaccess.DataAccessService;
import org.wso2.carbon.core.multitenancy.SuperTenantCarbonContext;
import org.wso2.carbon.ntask.core.TaskManager;
import org.wso2.carbon.ntask.core.service.TaskService;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.registry.core.service.TenantRegistryLoader;
import org.wso2.carbon.utils.ConfigurationContextService;

public class BAMAnalyzerServiceComponent {
    private static Log log = LogFactory.getLog(BAMAnalyzerServiceComponent.class);
    public static final String BAM_ANALYSER_TASK = "BAM_ANALYSER_TASK";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void activate(ComponentContext ctx) {
        try {
            SuperTenantCarbonContext.startTenantFlow();
            SuperTenantCarbonContext.getCurrentContext().setTenantId(-1234);
            TaskService taskService = Utils.getTaskService();
            if (taskService != null) {
                taskService.registerTaskType(BAM_ANALYSER_TASK);
                TaskManager taskManager = taskService.getTaskManager(BAM_ANALYSER_TASK);
                AnalyzerEngine analyzerEngine = new AnalyzerEngine(taskManager);
                Utils.setEngine(analyzerEngine);
                IndexManager.getInstance().registerIndexingTaskProvider((IndexingTaskProvider)analyzerEngine);
            } else {
                log.error((Object)"Task service is null");
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)"BAM analyzer bundle is activated");
            }
        }
        catch (Throwable e) {
            log.error((Object)"BAM analyzer bundle cannot be started", e);
        }
        finally {
            SuperTenantCarbonContext.endTenantFlow();
        }
    }

    protected void deactivate(ComponentContext ctx) {
        Utils.setEngine(null);
        if (log.isDebugEnabled()) {
            log.debug((Object)"BAM analyzer bundle is deactivated");
        }
    }

    protected void setDataAccessService(DataAccessService dataAccessService) {
        Utils.setDataAccessService(dataAccessService);
    }

    protected void unsetDataAccessService(DataAccessService dataAccessService) {
        Utils.setDataAccessService(null);
    }

    protected void setRegistryService(RegistryService registryService) throws RegistryException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"RegistryService set in BAM bundle");
        }
        Utils.setRegistryService(registryService);
    }

    protected void unsetRegistryService(RegistryService registryService) {
        Utils.setRegistryService(null);
        if (log.isDebugEnabled()) {
            log.debug((Object)"RegistryService unset in BAM bundle");
        }
    }

    protected void setTenantRegistryLoader(TenantRegistryLoader tenantRegistryLoader) {
        Utils.setTenantRegistryLoader(tenantRegistryLoader);
        if (log.isDebugEnabled()) {
            log.debug((Object)"TenantRegistryLoader set in BAM bundle");
        }
    }

    protected void unsetTenantRegistryLoader(TenantRegistryLoader tenantRegistryLoader) {
        Utils.setTenantRegistryLoader(null);
        if (log.isDebugEnabled()) {
            log.debug((Object)"TenantRegistryLoader unset in BAM bundle");
        }
    }

    protected void setTaskService(TaskService taskService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Setting the Task Service");
        }
        Utils.setTaskService(taskService);
    }

    protected void unsetTaskService(TaskService taskService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Unsetting the Task Service");
        }
        Utils.setTaskService(null);
    }

    protected void setConfigurationContextService(ConfigurationContextService configCtxService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"ConfigurationContextService is set in BAM bundle");
        }
        Utils.setConfigurationContextService(configCtxService);
    }

    protected void unsetConfigurationContextService(ConfigurationContextService configCtxService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"ConfigurationContextService is un-set in BAM bundle");
        }
        Utils.setConfigurationContextService(null);
    }
}

