/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bam.analyzer.engine;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.bam.analyzer.analyzers.GetAnalyzer;
import org.wso2.carbon.bam.analyzer.analyzers.configs.GetConfig;
import org.wso2.carbon.bam.analyzer.engine.Analyzer;
import org.wso2.carbon.bam.core.dataobjects.Cursor;
import org.wso2.carbon.bam.core.persistence.MetaDataManager;
import org.wso2.carbon.bam.core.persistence.exceptions.ConfigurationException;

public class AnalyzerSequence {
    private static final Log log = LogFactory.getLog(AnalyzerSequence.class);
    private List<Analyzer> analyzers = new ArrayList<Analyzer>();
    private String name;
    private String cron;
    private int interval;
    private int count;
    private Cursor cursor;
    private Map<String, String> credentials = new HashMap<String, String>();
    private int tenantId;

    public String getCron() {
        return this.cron;
    }

    public void setCron(String cron) {
        this.cron = cron;
    }

    public int getInterval() {
        return this.interval;
    }

    public void setInterval(int interval) {
        this.interval = interval;
    }

    public int getCount() {
        return this.count;
    }

    public void setCount(int count) {
        this.count = count;
    }

    public List<Analyzer> getAnalyzers() {
        return this.analyzers;
    }

    public void setAnalyzers(List<Analyzer> analyzers) {
        this.analyzers = analyzers;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(int tenantId) {
        this.tenantId = tenantId;
    }

    public Cursor getCursor() {
        return this.cursor;
    }

    public void setCursor(Cursor cursor) {
        this.cursor = cursor;
    }

    public void setCredentials(Map<String, String> credentials) {
        this.credentials = credentials;
    }

    public void cleanup() {
        if (this.analyzers != null) {
            MetaDataManager metaDataManager = MetaDataManager.getInstance();
            for (int i = 0; i < this.analyzers.size(); ++i) {
                GetAnalyzer getAnalyzer;
                GetConfig config;
                Analyzer analyzer = this.analyzers.get(i);
                if (!(analyzer instanceof GetAnalyzer) || !this.isBatchSizeDefined(config = (GetConfig)(getAnalyzer = (GetAnalyzer)analyzer).getAnalyzerConfig())) continue;
                Cursor cursor = new Cursor(config.getTable(), this.name, i);
                cursor.setResumePoint("");
                try {
                    metaDataManager.storeCursorMetaData(this.credentials, cursor);
                    continue;
                }
                catch (ConfigurationException e) {
                    log.error((Object)"Error while clearing cursor meta data..");
                }
            }
        }
    }

    private boolean isBatchSizeDefined(GetConfig config) {
        return config.getBatchSize() < Integer.MAX_VALUE;
    }
}

