/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bam.analyzer.engine;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.util.AXIOMUtil;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.bam.analyzer.Utils;
import org.wso2.carbon.bam.analyzer.analyzers.IndexingAnalyzer;
import org.wso2.carbon.bam.analyzer.analyzers.configs.IndexingConfig;
import org.wso2.carbon.bam.analyzer.engine.Analyzer;
import org.wso2.carbon.bam.analyzer.engine.AnalyzerException;
import org.wso2.carbon.bam.analyzer.engine.AnalyzerSequence;
import org.wso2.carbon.bam.analyzer.task.BAMTaskInfo;
import org.wso2.carbon.bam.core.configurations.IndexConfiguration;
import org.wso2.carbon.bam.core.configurations.IndexingTaskConfiguration;
import org.wso2.carbon.bam.core.persistence.IndexManager;
import org.wso2.carbon.bam.core.persistence.IndexingTaskProvider;
import org.wso2.carbon.bam.core.persistence.MetaDataManager;
import org.wso2.carbon.bam.core.persistence.exceptions.ConfigurationException;
import org.wso2.carbon.bam.core.persistence.exceptions.IndexingException;
import org.wso2.carbon.core.multitenancy.SuperTenantCarbonContext;
import org.wso2.carbon.ntask.common.TaskException;
import org.wso2.carbon.ntask.core.TaskInfo;
import org.wso2.carbon.ntask.core.TaskManager;
import org.wso2.carbon.registry.core.Collection;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.session.UserRegistry;

public class AnalyzerEngine
implements IndexingTaskProvider {
    private static final Log log = LogFactory.getLog(AnalyzerEngine.class);
    private TaskManager taskManager;
    private ExecutorService loaderThreadPool = Executors.newSingleThreadExecutor();
    public static String CREDENTIALS = "credentials";
    public static String ANALYSER_SEQUENCE_NAME = "name";
    public static String TENANT_ID = "tenantId";
    public static String ANALYSER_SEQUENCE = "analyserSequence";

    public AnalyzerEngine(TaskManager taskManager) throws AnalyzerException {
        this.taskManager = taskManager;
        ConfigurationLoader loader = new ConfigurationLoader();
        this.loaderThreadPool.submit(loader);
    }

    private boolean loadAnaylzers() throws AnalyzerException {
        Map<Integer, List<OMElement>> tenantsWithActiveTasks = this.getTenantsWithActiveTasks();
        for (Map.Entry<Integer, List<OMElement>> tenantWithActiveTask : tenantsWithActiveTasks.entrySet()) {
            Integer tenantId = tenantWithActiveTask.getKey();
            Map<String, String> credentials = this.getConnectionParametersForTenant(tenantId);
            for (OMElement analyzerSeqXML : tenantWithActiveTask.getValue()) {
                try {
                    AnalyzerSequence sequence = Utils.getAnalyzerSequence(tenantId, analyzerSeqXML);
                    BAMTaskInfo taskInfo = new BAMTaskInfo();
                    taskInfo.setAnlyzerSequence(sequence);
                    taskInfo.setCredentials(credentials);
                    taskInfo.setAnalyzerSeqXML(analyzerSeqXML);
                    this.startAnalyzerSequence(taskInfo);
                }
                catch (Exception ignored) {}
            }
        }
        log.info((Object)"Done initializing analyzer tasks..");
        return true;
    }

    private void loadIndexingTasks() {
        MetaDataManager metaDataManager = MetaDataManager.getInstance();
        int[] tenantIds = null;
        try {
            tenantIds = metaDataManager.getAllTenantsWithDefinedIndexes();
        }
        catch (ConfigurationException ignored) {
            // empty catch block
        }
        if (tenantIds != null) {
            for (int tenantId : tenantIds) {
                try {
                    Map<String, String> credentials = null;
                    try {
                        credentials = this.getConnectionParametersForTenant(tenantId);
                    }
                    catch (AnalyzerException e) {
                        log.error((Object)("Unable to fetch connection parameters for tenant " + tenantId + " . Not initializing indexing tasks for this " + "tenant.."));
                        continue;
                    }
                    List configurations = MetaDataManager.getInstance().getAllIndexMetaData(credentials);
                    for (IndexConfiguration configuration : configurations) {
                        if (configuration.isAutoGenerated() || !configuration.isManuallyIndexed()) continue;
                        IndexingTaskConfiguration taskConfiguration = new IndexingTaskConfiguration();
                        taskConfiguration.setCredentials(credentials);
                        taskConfiguration.setTenantId(tenantId);
                        taskConfiguration.setTaskName(configuration.getIndexName() + "_Index_" + configuration.getIndexedTable());
                        taskConfiguration.setInterval(30000);
                        try {
                            IndexManager.getInstance().scheduleIndexingTask(configuration, taskConfiguration);
                        }
                        catch (IndexingException e) {
                            log.error((Object)("Error while schedule indexing task for index " + configuration.getIndexName() + " for tenant " + tenantId + ".."));
                        }
                    }
                }
                catch (ConfigurationException e) {
                    log.error((Object)("Error while fetching index meta data for tenant " + tenantId + ". Not" + " loading indexing tasks for this tenant.."));
                }
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Loaded indexing tasks for all tenants..");
        }
    }

    public Map<String, String> getConnectionParametersForTenant(int tenantId) throws AnalyzerException {
        Map credentials;
        try {
            credentials = org.wso2.carbon.bam.core.utils.Utils.getConnectionParameters((int)tenantId);
        }
        catch (ConfigurationException e) {
            String message = "Failed to fetch connection parameters for tenant : " + tenantId;
            log.error((Object)message, (Throwable)e);
            throw new AnalyzerException(message, e);
        }
        return credentials;
    }

    private Map<Integer, List<OMElement>> getTenantsWithActiveTasks() throws AnalyzerException {
        try {
            UserRegistry superTenantRegistry = Utils.getRegistryService().getConfigSystemRegistry(SuperTenantCarbonContext.getCurrentContext((ConfigurationContext)Utils.getConfigurationContextService().getServerConfigContext()).getTenantId());
            HashMap<Integer, List<OMElement>> tenantAnalyzersMap = new HashMap<Integer, List<OMElement>>();
            String analyzerTrackerPath = "/components/org.wso2.carbon.bam.analyzer/tenantTracker/analyzerTracker";
            if (superTenantRegistry.resourceExists(analyzerTrackerPath)) {
                Resource tenantTrackerResource = superTenantRegistry.get(analyzerTrackerPath);
                List propertyValues = tenantTrackerResource.getPropertyValues("Tenants");
                if (propertyValues == null) {
                    return tenantAnalyzersMap;
                }
                for (String propertyValue : propertyValues) {
                    Integer tenantId = Integer.parseInt(propertyValue);
                    List<OMElement> analyzerSequenceList = this.getAnalyzerSeqs(tenantId);
                    tenantAnalyzersMap.put(tenantId, analyzerSequenceList);
                }
            }
            return tenantAnalyzersMap;
        }
        catch (RegistryException e) {
            String message = "Cannot retrive task configurations for tenants";
            log.error((Object)message, (Throwable)e);
            throw new AnalyzerException(message, e);
        }
    }

    public List<OMElement> getAnalyzerSeqs(Integer tenantId) throws AnalyzerException {
        try {
            Utils.getTenantRegistryLoader().loadTenantRegistry(tenantId.intValue());
            UserRegistry tenantConfigSystemRegistry = Utils.getRegistryService().getConfigSystemRegistry(tenantId.intValue());
            ArrayList<OMElement> analyzerSequenceList = new ArrayList<OMElement>();
            if (tenantConfigSystemRegistry.resourceExists("/components/org.wso2.carbon.bam.analyzer/analyzers/")) {
                String[] analyzerSeqRegistryPaths;
                Collection collection = (Collection)tenantConfigSystemRegistry.get("/components/org.wso2.carbon.bam.analyzer/analyzers/");
                for (String analyzerSeqRegistryPath : analyzerSeqRegistryPaths = collection.getChildren()) {
                    Resource analyzerSeqResource = tenantConfigSystemRegistry.get(analyzerSeqRegistryPath);
                    String analyzerXMLString = new String((byte[])analyzerSeqResource.getContent());
                    analyzerSequenceList.add(AXIOMUtil.stringToOM((String)analyzerXMLString));
                }
            }
            return analyzerSequenceList;
        }
        catch (RegistryException e) {
            String message = "Cannot retrieve task configurations for tenant" + tenantId;
            log.error((Object)message, (Throwable)e);
            throw new AnalyzerException(message, e);
        }
        catch (XMLStreamException e) {
            String message = "Cannot retrieve task configurations for tenant" + tenantId;
            log.error((Object)message, (Throwable)e);
            throw new AnalyzerException(message, e);
        }
    }

    public List<String> getAnalyzerSeqXMLs(Integer tenantId) throws AnalyzerException {
        try {
            Utils.getTenantRegistryLoader().loadTenantRegistry(tenantId.intValue());
            UserRegistry tenantConfigSystemRegistry = Utils.getRegistryService().getConfigSystemRegistry(tenantId.intValue());
            ArrayList<String> analyzerSequenceXMLList = new ArrayList<String>();
            if (tenantConfigSystemRegistry.resourceExists("/components/org.wso2.carbon.bam.analyzer/analyzers/")) {
                String[] analyzerSeqRegistryPaths;
                Collection collection = (Collection)tenantConfigSystemRegistry.get("/components/org.wso2.carbon.bam.analyzer/analyzers/");
                for (String analyzerSeqRegistryPath : analyzerSeqRegistryPaths = collection.getChildren()) {
                    Resource analyzerSeqResource = tenantConfigSystemRegistry.get(analyzerSeqRegistryPath);
                    String analyzerXMLString = new String((byte[])analyzerSeqResource.getContent());
                    analyzerSequenceXMLList.add(analyzerXMLString);
                }
            }
            return analyzerSequenceXMLList;
        }
        catch (RegistryException e) {
            String message = "Cannot retrieve task configurations for tenant" + tenantId;
            log.error((Object)message, (Throwable)e);
            throw new AnalyzerException(message, e);
        }
    }

    public String getAnalyzerSeqXML(Integer tenantId, String analyzerSeqName) throws AnalyzerException {
        try {
            String analyzerSeqRegistryPath;
            if (analyzerSeqName == null) {
                throw new AnalyzerException("Analyzer sequence name cannot be null");
            }
            UserRegistry tenantConfigSystemRegistry = Utils.getRegistryService().getConfigSystemRegistry(tenantId.intValue());
            if (tenantConfigSystemRegistry.resourceExists(analyzerSeqRegistryPath = "/components/org.wso2.carbon.bam.analyzer/analyzers/" + analyzerSeqName)) {
                Resource analyzerSeqResource = tenantConfigSystemRegistry.get(analyzerSeqRegistryPath);
                return new String((byte[])analyzerSeqResource.getContent());
            }
            String message = "Analyzer sequence " + analyzerSeqName + "does not exist for tenant : " + tenantId;
            AnalyzerException analyzerException = new AnalyzerException(message);
            log.error((Object)message, (Throwable)analyzerException);
            throw analyzerException;
        }
        catch (RegistryException e) {
            String message = "Cannot retrieve Analyzer sequence : " + analyzerSeqName + " for tenant : " + tenantId;
            log.error((Object)message, (Throwable)e);
            throw new AnalyzerException(message, e);
        }
    }

    public void scheduleIndexingTask(IndexConfiguration configuration, IndexingTaskConfiguration taskConfiguration) throws IndexingException {
        IndexingAnalyzer idxAnalyzer = new IndexingAnalyzer(new IndexingConfig(configuration));
        idxAnalyzer.setAnalyzerSeqeunceName(taskConfiguration.getTaskName());
        ArrayList<Analyzer> analyzers = new ArrayList<Analyzer>();
        analyzers.add(idxAnalyzer);
        AnalyzerSequence sequence = new AnalyzerSequence();
        sequence.setAnalyzers(analyzers);
        sequence.setCount(taskConfiguration.getCount());
        sequence.setCron(taskConfiguration.getCron());
        sequence.setInterval(taskConfiguration.getInterval());
        sequence.setName(taskConfiguration.getTaskName());
        sequence.setTenantId(taskConfiguration.getTenantId());
        try {
            BAMTaskInfo taskInfo = new BAMTaskInfo();
            taskInfo.setAnalyzerSeqXML(Utils.serializeIndexAnalyser(configuration));
            taskInfo.setCredentials(taskConfiguration.getCredentials());
            taskInfo.setAnlyzerSequence(sequence);
            this.startAnalyzerSequence(taskInfo);
        }
        catch (Exception e) {
            throw new IndexingException("Unable to schedule task..", (Throwable)e);
        }
    }

    public void unscheduleIndexingTask(IndexingTaskConfiguration taskConfiguration) {
        AnalyzerSequence sequence = new AnalyzerSequence();
        sequence.setName(taskConfiguration.getTaskName());
        sequence.setTenantId(taskConfiguration.getTenantId());
        try {
            this.deleteAnalyzerSequence(sequence, taskConfiguration.getTenantId());
        }
        catch (TaskException e) {
            log.error((Object)"Error in deleting analyser sequence", (Throwable)e);
        }
    }

    public void startAnalyzerSequence(BAMTaskInfo bamTaskInfo) throws Exception {
        TaskInfo taskInfo = Utils.getTaskInfo(bamTaskInfo);
        this.getTaskManager().registerTask(taskInfo);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Registered task : " + bamTaskInfo.getAnalyzerSequence().getName() + " for tenant : " + bamTaskInfo.getAnalyzerSequence().getTenantId()));
        }
    }

    public void deleteAnalyzerSequence(AnalyzerSequence sequence, int tenantId) throws TaskException {
        this.getTaskManager().deleteTask(sequence.getName());
        sequence.cleanup();
    }

    public void stopAnalyzerSequence(AnalyzerSequence sequence) throws TaskException {
        this.getTaskManager().deleteTask(sequence.getName());
    }

    public TaskManager getTaskManager() {
        return this.taskManager;
    }

    private class ConfigurationLoader
    implements Callable<Boolean> {
        private ConfigurationLoader() {
        }

        @Override
        public Boolean call() throws Exception {
            try {
                AnalyzerEngine.this.loadAnaylzers();
                AnalyzerEngine.this.loadIndexingTasks();
            }
            catch (Exception e) {
                log.error((Object)"Cannot load analyzer sequences", (Throwable)e);
            }
            return true;
        }
    }
}

