/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bam.analyzer.analyzers.builders;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.wso2.carbon.bam.analyzer.analyzers.AnalyzerBuilder;
import org.wso2.carbon.bam.analyzer.analyzers.AnalyzerConfig;
import org.wso2.carbon.bam.analyzer.analyzers.PutAnalyzer;
import org.wso2.carbon.bam.analyzer.analyzers.configs.AggregationMeasure;
import org.wso2.carbon.bam.analyzer.analyzers.configs.PutConfig;
import org.wso2.carbon.bam.analyzer.engine.Analyzer;
import org.wso2.carbon.bam.analyzer.engine.AnalyzerConfigConstants;
import org.wso2.carbon.bam.analyzer.engine.AnalyzerException;

public class PutAnalyzerBuilder
extends AnalyzerBuilder {
    @Override
    protected AnalyzerConfig buildConfig(OMElement analyzerXML) throws AnalyzerException {
        OMElement onExist;
        OMAttribute cfName = analyzerXML.getAttribute(AnalyzerConfigConstants.name);
        OMAttribute dataSourceType = analyzerXML.getAttribute(AnalyzerConfigConstants.dataSourceType);
        if (cfName == null) {
            throw new AnalyzerException("Error at Put : name must be present..");
        }
        PutConfig putConfig = new PutConfig();
        putConfig.setColumnFamily(cfName.getAttributeValue());
        if (dataSourceType != null) {
            putConfig.setDataSource(dataSourceType.getAttributeValue());
        }
        if ((onExist = analyzerXML.getFirstChildWithName(AnalyzerConfigConstants.onExist)) != null) {
            OMElement replace = onExist.getFirstChildWithName(AnalyzerConfigConstants.replace);
            OMElement aggregate = onExist.getFirstChildWithName(AnalyzerConfigConstants.aggregate);
            if (replace != null && aggregate != null) {
                throw new AnalyzerException("Error at Put : Only replace or aggregate should be present..");
            }
            if (replace != null) {
                putConfig.setDoReplace(true);
            }
            if (aggregate != null) {
                Iterator measureIterator = aggregate.getChildrenWithName(AnalyzerConfigConstants.measure);
                if (!measureIterator.hasNext()) {
                    throw new AnalyzerException("Error at Put : At least one aggregation measure should be defined..");
                }
                putConfig.setDoAggregate(true);
                ArrayList<AggregationMeasure> aggregationMeasures = new ArrayList<AggregationMeasure>();
                while (measureIterator.hasNext()) {
                    OMElement measure = (OMElement)measureIterator.next();
                    OMAttribute name = measure.getAttribute(AnalyzerConfigConstants.name);
                    OMAttribute aggregationType = measure.getAttribute(AnalyzerConfigConstants.aggregationType);
                    OMAttribute fieldType = measure.getAttribute(AnalyzerConfigConstants.fieldType);
                    if (this.isEmptryAttribute(name) || this.isEmptryAttribute(aggregationType)) {
                        throw new AnalyzerException("Error at Put : Both name and aggregationTypeattributes should be present..");
                    }
                    String nameStr = name.getAttributeValue();
                    String aggregationTypeStr = aggregationType.getAttributeValue();
                    String fieldTypeStr = fieldType != null ? fieldType.getAttributeValue() : "DOUBLE";
                    AggregationMeasure aggregationMeasure = new AggregationMeasure(nameStr, aggregationTypeStr, fieldTypeStr);
                    aggregationMeasures.add(aggregationMeasure);
                }
                putConfig.setMeasures(aggregationMeasures);
            } else {
                putConfig.setDoReplace(true);
            }
        }
        return putConfig;
    }

    @Override
    public Analyzer buildAnalyzer(OMElement analyzerXML) throws AnalyzerException {
        return new PutAnalyzer(this.buildConfig(analyzerXML));
    }

    private boolean isEmptryAttribute(OMAttribute attr) {
        return attr == null || attr.getAttributeValue() == null || attr.getAttributeValue().trim().equals("");
    }
}

