/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bam.analyzer.analyzers.builders;

import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.wso2.carbon.bam.analyzer.analyzers.AnalyzerBuilder;
import org.wso2.carbon.bam.analyzer.analyzers.AnalyzerConfig;
import org.wso2.carbon.bam.analyzer.analyzers.LookupAnalyzer;
import org.wso2.carbon.bam.analyzer.analyzers.configs.LookupConfig;
import org.wso2.carbon.bam.analyzer.engine.Analyzer;
import org.wso2.carbon.bam.analyzer.engine.AnalyzerConfigConstants;
import org.wso2.carbon.bam.analyzer.engine.AnalyzerException;

public class LookupAnalyzerBuilder
extends AnalyzerBuilder {
    @Override
    protected AnalyzerConfig buildConfig(OMElement analyzerXML) throws AnalyzerException {
        OMAttribute cfName = analyzerXML.getAttribute(AnalyzerConfigConstants.name);
        OMAttribute defaultCf = analyzerXML.getAttribute(AnalyzerConfigConstants.defaultCf);
        this.validateAttributes(cfName, defaultCf);
        LookupConfig lookupConfig = null;
        if (cfName != null) {
            lookupConfig = new LookupConfig(cfName.getAttributeValue(), null);
        } else if (defaultCf != null) {
            lookupConfig = new LookupConfig(null, defaultCf.getAttributeValue());
        }
        return lookupConfig;
    }

    @Override
    public Analyzer buildAnalyzer(OMElement analyzerXML) throws AnalyzerException {
        return new LookupAnalyzer(this.buildConfig(analyzerXML));
    }

    private void validateAttributes(OMAttribute cfName, OMAttribute defaultCf) throws AnalyzerException {
        boolean cfNameEmpty = this.isEmptryAttribute(cfName);
        boolean defaultCfEmpty = this.isEmptryAttribute(defaultCf);
        if (!cfNameEmpty && !defaultCfEmpty) {
            throw new AnalyzerException("Error at lookup : Either name or default attribute should be present..");
        }
        if (cfNameEmpty && defaultCfEmpty) {
            throw new AnalyzerException("Error at lookup : Either name or default attribute should be present..");
        }
        if (!defaultCfEmpty) {
            String[] tokens;
            String defaultCfString = defaultCf.getAttributeValue();
            for (String token : tokens = defaultCfString.split(",")) {
                if (token.equalsIgnoreCase("Event") || token.equalsIgnoreCase("Meta") || token.equalsIgnoreCase("Correlation")) continue;
                throw new AnalyzerException("Error at lookup : Default keys should only contain Event, Meta or Correlation..");
            }
        }
    }

    private boolean isEmptryAttribute(OMAttribute attr) {
        return attr == null || attr.getAttributeValue() == null || attr.getAttributeValue().trim().equals("");
    }
}

