/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bam.analyzer.analyzers.builders;

import java.util.Iterator;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.wso2.carbon.bam.analyzer.analyzers.AnalyzerBuilder;
import org.wso2.carbon.bam.analyzer.analyzers.AnalyzerConfig;
import org.wso2.carbon.bam.analyzer.analyzers.JMXAnalyzer;
import org.wso2.carbon.bam.analyzer.analyzers.configs.Attribute;
import org.wso2.carbon.bam.analyzer.analyzers.configs.JMXConfig;
import org.wso2.carbon.bam.analyzer.analyzers.configs.Operation;
import org.wso2.carbon.bam.analyzer.analyzers.configs.Parameter;
import org.wso2.carbon.bam.analyzer.engine.Analyzer;
import org.wso2.carbon.bam.analyzer.engine.AnalyzerConfigConstants;
import org.wso2.carbon.bam.analyzer.engine.AnalyzerException;

public class JMXAnalyzerBuilder
extends AnalyzerBuilder {
    private static final String DEFAULT_JMX_URL = "service:jmx:rmi:///jndi/rmi://:9999/jmxrmi";

    @Override
    protected AnalyzerConfig buildConfig(OMElement analyzerEl) throws AnalyzerException {
        OMElement operations;
        OMAttribute url = analyzerEl.getAttribute(AnalyzerConfigConstants.url);
        String jmxUrl = url != null ? url.getAttributeValue() : DEFAULT_JMX_URL;
        JMXConfig config = new JMXConfig(jmxUrl);
        OMElement attributes = analyzerEl.getFirstChildWithName(AnalyzerConfigConstants.attributes);
        if (attributes != null) {
            Iterator attributeIterator = attributes.getChildrenWithLocalName("attribute");
            while (attributeIterator.hasNext()) {
                OMElement attributeEl = (OMElement)attributeIterator.next();
                OMAttribute mbeanAttr = attributeEl.getAttribute(AnalyzerConfigConstants.mbean);
                if (this.isAttributeEmpty(mbeanAttr)) {
                    throw new AnalyzerException("Attribute mbean should not be empty..");
                }
                OMAttribute nameAttr = attributeEl.getAttribute(AnalyzerConfigConstants.name);
                if (this.isAttributeEmpty(nameAttr)) {
                    throw new AnalyzerException("Attribute name should not be empty..");
                }
                Attribute attribute = new Attribute(mbeanAttr.getAttributeValue(), nameAttr.getAttributeValue());
                config.addAttribute(attribute);
            }
        }
        if ((operations = analyzerEl.getFirstChildWithName(AnalyzerConfigConstants.operations)) != null) {
            Iterator operationIterator = operations.getChildrenWithLocalName("operation");
            while (operationIterator.hasNext()) {
                OMElement operationEl = (OMElement)operationIterator.next();
                OMAttribute mbeanAttr = operationEl.getAttribute(AnalyzerConfigConstants.mbean);
                if (this.isAttributeEmpty(mbeanAttr)) {
                    throw new AnalyzerException("Operation mbean should not be empty..");
                }
                OMAttribute nameAttr = operationEl.getAttribute(AnalyzerConfigConstants.name);
                if (this.isAttributeEmpty(nameAttr)) {
                    throw new AnalyzerException("Operation name should not be empty..");
                }
                Operation operation = new Operation(mbeanAttr.getAttributeValue(), nameAttr.getAttributeValue());
                Iterator parameterIterator = operationEl.getChildrenWithLocalName("parameter");
                while (parameterIterator.hasNext()) {
                    OMElement parameterEl = (OMElement)parameterIterator.next();
                    OMAttribute typeAttr = parameterEl.getAttribute(AnalyzerConfigConstants.type);
                    if (this.isAttributeEmpty(typeAttr)) {
                        throw new AnalyzerException("Parameter type should not be empty..");
                    }
                    OMAttribute valueAttr = parameterEl.getAttribute(AnalyzerConfigConstants.value);
                    Parameter parameter = new Parameter(valueAttr.getAttributeValue(), typeAttr.getAttributeValue());
                    operation.addParameter(parameter);
                }
                config.addOperation(operation);
            }
        }
        return config;
    }

    @Override
    public Analyzer buildAnalyzer(OMElement analyzerXML) throws AnalyzerException {
        return new JMXAnalyzer(this.buildConfig(analyzerXML));
    }

    private boolean isAttributeEmpty(OMAttribute attribute) {
        return attribute == null || attribute.getAttributeValue() == null || attribute.getAttributeValue().trim().equals("");
    }
}

