/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bam.analyzer.analyzers.builders;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.bam.analyzer.analyzers.AnalyzerBuilder;
import org.wso2.carbon.bam.analyzer.analyzers.AnalyzerConfig;
import org.wso2.carbon.bam.analyzer.analyzers.GroupByAnalyzer;
import org.wso2.carbon.bam.analyzer.analyzers.configs.GroupByConfig;
import org.wso2.carbon.bam.analyzer.engine.Analyzer;
import org.wso2.carbon.bam.analyzer.engine.AnalyzerConfigConstants;
import org.wso2.carbon.bam.analyzer.engine.AnalyzerException;

public class GroupByAnalyzerBuilder
extends AnalyzerBuilder {
    private static final Log log = LogFactory.getLog(GroupByAnalyzerBuilder.class);

    @Override
    protected AnalyzerConfig buildConfig(OMElement analyzerXML) throws AnalyzerException {
        GroupByConfig config = new GroupByConfig();
        Iterator fieldIterator = analyzerXML.getChildrenWithName(AnalyzerConfigConstants.field);
        OMElement timeField = analyzerXML.getFirstChildWithName(AnalyzerConfigConstants.time);
        if (!fieldIterator.hasNext() && timeField == null) {
            this.handleException("Error at groupBy : At least one field or time field should be specified..");
        }
        Iterator iterator = analyzerXML.getChildElements();
        ArrayList<String> fields = new ArrayList<String>();
        while (iterator.hasNext()) {
            OMAttribute name;
            OMElement field = (OMElement)iterator.next();
            if (field.getLocalName().equals(AnalyzerConfigConstants.field.getLocalPart())) {
                name = field.getAttribute(AnalyzerConfigConstants.name);
                this.validateAttribute(name, AnalyzerConfigConstants.name.getLocalPart());
                fields.add(name.getAttributeValue());
                continue;
            }
            if (field.getLocalName().equals(AnalyzerConfigConstants.time.getLocalPart())) {
                name = timeField.getAttribute(AnalyzerConfigConstants.name);
                this.validateAttribute(name, AnalyzerConfigConstants.name.getLocalPart());
                fields.add(name.getAttributeValue());
                config.setTimeField(name.getAttributeValue());
                OMAttribute granularity = timeField.getAttribute(AnalyzerConfigConstants.granularity);
                this.validateAttribute(granularity, AnalyzerConfigConstants.granularity.getLocalPart());
                config.setGranularity(granularity.getAttributeValue());
                continue;
            }
            this.handleException("Error at groupBy : Unrecognized element in groupBy. Either 'field' or 'time' expected..");
        }
        config.setFields(fields);
        return config;
    }

    @Override
    public Analyzer buildAnalyzer(OMElement analyzerXML) throws AnalyzerException {
        return new GroupByAnalyzer(this.buildConfig(analyzerXML));
    }

    private void handleException(String message) throws AnalyzerException {
        log.error((Object)message);
        throw new AnalyzerException(message);
    }

    private void validateAttribute(OMAttribute attribute, String attributeName) throws AnalyzerException {
        if (attribute == null || attribute.getAttributeValue() == null || attribute.getAttributeValue().trim().equals("")) {
            this.handleException("Error at groupBy : Missing or empty required attribute " + attributeName);
        }
    }

    private boolean isEmptyAttribute(OMAttribute attribute) {
        return attribute == null || attribute.getAttributeValue() == null || attribute.getAttributeValue().trim().equals("");
    }
}

