/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bam.analyzer.analyzers.builders;

import java.util.Iterator;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.wso2.carbon.bam.analyzer.analyzers.AnalyzerBuilder;
import org.wso2.carbon.bam.analyzer.analyzers.AnalyzerConfig;
import org.wso2.carbon.bam.analyzer.analyzers.GetAnalyzer;
import org.wso2.carbon.bam.analyzer.analyzers.configs.GetConfig;
import org.wso2.carbon.bam.analyzer.engine.Analyzer;
import org.wso2.carbon.bam.analyzer.engine.AnalyzerConfigConstants;
import org.wso2.carbon.bam.analyzer.engine.AnalyzerException;
import org.wso2.carbon.bam.core.persistence.QueryIndex;

public class GetAnalyzerBuilder
extends AnalyzerBuilder {
    @Override
    protected AnalyzerConfig buildConfig(OMElement analyzerEl) throws AnalyzerException {
        OMAttribute name = analyzerEl.getAttribute(AnalyzerConfigConstants.name);
        if (name == null) {
            throw new AnalyzerException("Table name must be present..");
        }
        OMAttribute batchSizeAtt = analyzerEl.getAttribute(AnalyzerConfigConstants.batchSize);
        OMAttribute fetchDirty = analyzerEl.getAttribute(AnalyzerConfigConstants.fetchDirty);
        boolean isFetchDirty = false;
        int batchSize = Integer.MAX_VALUE;
        if (fetchDirty != null) {
            try {
                isFetchDirty = Boolean.parseBoolean(fetchDirty.getAttributeValue());
            }
            catch (Exception e) {
                throw new AnalyzerException("fetchDirty should be either 'true' or 'false'..");
            }
        }
        if (batchSizeAtt != null) {
            try {
                batchSize = Integer.parseInt(batchSizeAtt.getAttributeValue());
                if (batchSize <= 0) {
                    throw new AnalyzerException("batchSize must be a positive integer..");
                }
            }
            catch (Exception e) {
                throw new AnalyzerException("batchSize must be a positive integer..");
            }
        }
        String cfName = name.getAttributeValue();
        Iterator indexIterator = analyzerEl.getChildrenWithLocalName("where");
        QueryIndex index = null;
        if (indexIterator.hasNext()) {
            Object indexElementObject = indexIterator.next();
            if (!(indexElementObject instanceof OMElement)) {
                return null;
            }
            OMElement indexEl = (OMElement)indexElementObject;
            OMAttribute indexName = indexEl.getAttribute(AnalyzerConfigConstants.index);
            Iterator rangeElements = indexEl.getChildrenWithLocalName("range");
            if (rangeElements != null) {
                index = new QueryIndex(indexName.getAttributeValue());
                while (rangeElements.hasNext()) {
                    OMElement rangeElement = (OMElement)rangeElements.next();
                    String column = rangeElement.getAttributeValue(AnalyzerConfigConstants.column);
                    String rangeFirst = rangeElement.getAttributeValue(AnalyzerConfigConstants.start);
                    String rangeLast = rangeElement.getAttributeValue(AnalyzerConfigConstants.end);
                    if (rangeFirst == null) {
                        rangeFirst = "";
                    }
                    if (rangeLast == null) {
                        rangeLast = "";
                    }
                    if (column == null) {
                        throw new AnalyzerException("Index column cannot be empty..");
                    }
                    index.addCompositeRange(column, rangeFirst, rangeLast);
                }
            }
        }
        GetConfig cfg = new GetConfig();
        cfg.setTable(cfName);
        cfg.setIndex(index);
        cfg.setBatchSize(batchSize);
        cfg.setFetchDirty(isFetchDirty);
        return cfg;
    }

    @Override
    public Analyzer buildAnalyzer(OMElement analyzerXML) throws AnalyzerException {
        return new GetAnalyzer(this.buildConfig(analyzerXML));
    }
}

