/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bam.analyzer.analyzers.builders;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.wso2.carbon.bam.analyzer.analyzers.AnalyzerBuilder;
import org.wso2.carbon.bam.analyzer.analyzers.AnalyzerConfig;
import org.wso2.carbon.bam.analyzer.analyzers.ExtractAnalyzer;
import org.wso2.carbon.bam.analyzer.analyzers.configs.ExtractConfig;
import org.wso2.carbon.bam.analyzer.analyzers.configs.ExtractField;
import org.wso2.carbon.bam.analyzer.engine.Analyzer;
import org.wso2.carbon.bam.analyzer.engine.AnalyzerConfigConstants;
import org.wso2.carbon.bam.analyzer.engine.AnalyzerException;

public class ExtractAnalyzerBuilder
extends AnalyzerBuilder {
    @Override
    protected AnalyzerConfig buildConfig(OMElement analyzerXML) throws AnalyzerException {
        Iterator fieldIterator = analyzerXML.getChildrenWithName(AnalyzerConfigConstants.field);
        ArrayList<ExtractField> extractFields = new ArrayList<ExtractField>();
        while (fieldIterator.hasNext()) {
            OMElement field = (OMElement)fieldIterator.next();
            OMAttribute from = field.getAttribute(AnalyzerConfigConstants.from);
            OMAttribute name = field.getAttribute(AnalyzerConfigConstants.name);
            OMAttribute xpath = field.getAttribute(AnalyzerConfigConstants.xpath);
            this.validateAttribute(from, AnalyzerConfigConstants.from.getLocalPart());
            this.validateAttribute(name, AnalyzerConfigConstants.name.getLocalPart());
            this.validateAttribute(xpath, AnalyzerConfigConstants.xpath.getLocalPart());
            Iterator nsIterator = field.getChildrenWithName(AnalyzerConfigConstants.namespace);
            HashMap<String, String> namespaces = new HashMap<String, String>();
            while (nsIterator.hasNext()) {
                OMElement namespace = (OMElement)nsIterator.next();
                OMAttribute prefix = namespace.getAttribute(AnalyzerConfigConstants.prefix);
                OMAttribute uri = namespace.getAttribute(AnalyzerConfigConstants.uri);
                this.validateAttribute(prefix, AnalyzerConfigConstants.prefix.getLocalPart());
                this.validateAttribute(uri, AnalyzerConfigConstants.uri.getLocalPart());
                namespaces.put(prefix.getAttributeValue(), uri.getAttributeValue());
            }
            String fromStr = from.getAttributeValue();
            String nameStr = name.getAttributeValue();
            String xpathStr = xpath.getAttributeValue();
            ExtractField extractField = new ExtractField();
            extractField.setFrom(fromStr);
            extractField.setName(nameStr);
            extractField.setXpath(xpathStr);
            extractField.setNamespaces(namespaces);
            extractFields.add(extractField);
        }
        ExtractConfig config = new ExtractConfig();
        config.setFields(extractFields);
        return config;
    }

    @Override
    public Analyzer buildAnalyzer(OMElement analyzerXML) throws AnalyzerException {
        return new ExtractAnalyzer(this.buildConfig(analyzerXML));
    }

    private void validateAttribute(OMAttribute attr, String attrName) throws AnalyzerException {
        if (attr == null || attr.getAttributeValue() == null || attr.getAttributeValue().trim().equals("")) {
            throw new AnalyzerException("Error at extract : " + attrName + " attribute must be present..");
        }
    }
}

