/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bam.analyzer.analyzers.builders;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.bam.analyzer.analyzers.AnalyzerBuilder;
import org.wso2.carbon.bam.analyzer.analyzers.AnalyzerConfig;
import org.wso2.carbon.bam.analyzer.analyzers.DropAnalyzer;
import org.wso2.carbon.bam.analyzer.analyzers.configs.DropConfig;
import org.wso2.carbon.bam.analyzer.analyzers.configs.FilterField;
import org.wso2.carbon.bam.analyzer.engine.Analyzer;
import org.wso2.carbon.bam.analyzer.engine.AnalyzerConfigConstants;
import org.wso2.carbon.bam.analyzer.engine.AnalyzerException;

public class DropAnalyzerBuilder
extends AnalyzerBuilder {
    private static final Log log = LogFactory.getLog(DropAnalyzerBuilder.class);

    @Override
    protected AnalyzerConfig buildConfig(OMElement analyzerXML) throws AnalyzerException {
        DropConfig dropConfig = new DropConfig();
        OMAttribute type = analyzerXML.getAttribute(AnalyzerConfigConstants.type);
        if (this.isEmptyAttribute(type)) {
            this.handleException("Error at Drop : Type should not be empty..");
        }
        String typeStr = type.getAttributeValue();
        dropConfig.setType(typeStr);
        if (!(typeStr.equalsIgnoreCase("row") || typeStr.equalsIgnoreCase("column") || typeStr.equalsIgnoreCase("group"))) {
            this.handleException("Error at Drop : Type should be one of 'row','column' or 'group'..");
        }
        OMElement fieldSet = analyzerXML.getFirstChildWithName(AnalyzerConfigConstants.fieldSet);
        OMElement groupSet = analyzerXML.getFirstChildWithName(AnalyzerConfigConstants.groupSet);
        if (fieldSet != null && groupSet != null) {
            this.handleException("Error at Drop: Only one of fieldSet or groupSet specifications should be present..");
        } else if (fieldSet == null && groupSet == null) {
            this.handleException("Error at Drop : At least one of fieldSet or groupSet specifications should be present..");
        }
        boolean isRowType = false;
        boolean isColumnType = false;
        boolean isGroupType = false;
        if (typeStr.equalsIgnoreCase("row")) {
            isRowType = true;
        } else if (typeStr.equalsIgnoreCase("column")) {
            isColumnType = true;
        } else if (typeStr.equalsIgnoreCase("group")) {
            isGroupType = true;
        }
        if ((isRowType || isColumnType) && fieldSet == null) {
            this.handleException("Error at Drop : Missing fieldSet specification for 'row' or 'column' type..");
        }
        if (isGroupType && groupSet == null) {
            this.handleException("Error at Drop : Missing groupSet specification for  'group' type..");
        }
        if (fieldSet != null) {
            String matchUsingStr;
            OMAttribute matchUsing = fieldSet.getAttribute(AnalyzerConfigConstants.matchUsing);
            if (isColumnType && !this.isEmptyAttribute(matchUsing)) {
                log.warn((Object)"Unnecessary matchUsing attribute in fieldSet specification for type 'column'. Ignoring..");
            }
            if (matchUsing != null) {
                matchUsingStr = matchUsing.getAttributeValue();
                if (!matchUsingStr.equalsIgnoreCase("and") || !matchUsingStr.equalsIgnoreCase("or")) {
                    this.handleException("Error at Drop : matchUsing should only contain values 'and' or 'or'");
                }
            } else {
                matchUsingStr = "and";
            }
            dropConfig.setMatchUsing(matchUsingStr);
            Iterator fieldIterator = fieldSet.getChildrenWithName(AnalyzerConfigConstants.field);
            if (!fieldIterator.hasNext()) {
                this.handleException("Error at Drop : fieldSpecification should contain at least one field..");
            }
            ArrayList<FilterField> fieldFilters = new ArrayList<FilterField>();
            while (fieldIterator.hasNext()) {
                OMElement field = (OMElement)fieldIterator.next();
                OMAttribute name = field.getAttribute(AnalyzerConfigConstants.name);
                if (this.isEmptyAttribute(name)) {
                    this.handleException("Error at Drop : field name should not be empty..");
                }
                String nameStr = name.getAttributeValue();
                OMAttribute regex = field.getAttribute(AnalyzerConfigConstants.regex);
                String regexStr = null;
                if (!this.isEmptyAttribute(regex)) {
                    regexStr = regex.getAttributeValue();
                }
                FilterField filterField = new FilterField(nameStr, regexStr);
                fieldFilters.add(filterField);
            }
            dropConfig.setFieldFilters(fieldFilters);
        }
        if (groupSet != null) {
            Iterator groupIterator = groupSet.getChildrenWithName(AnalyzerConfigConstants.group);
            if (!groupIterator.hasNext()) {
                this.handleException("Error at Drop : groupSpecification should contain at least one group..");
            }
            ArrayList<String> groupFilters = new ArrayList<String>();
            while (groupIterator.hasNext()) {
                OMElement group = (OMElement)groupIterator.next();
                OMAttribute regex = group.getAttribute(AnalyzerConfigConstants.regex);
                if (this.isEmptyAttribute(regex)) {
                    this.handleException("Error at Drop : group regex should not be empty..");
                }
                groupFilters.add(regex.getAttributeValue());
            }
            dropConfig.setGroupFilters(groupFilters);
        }
        return dropConfig;
    }

    @Override
    public Analyzer buildAnalyzer(OMElement analyzerXML) throws AnalyzerException {
        return new DropAnalyzer(this.buildConfig(analyzerXML));
    }

    private boolean isEmptyAttribute(OMAttribute attribute) {
        return attribute == null || attribute.getAttributeValue() == null || attribute.getAttributeValue().equals("");
    }

    private void handleException(String message) throws AnalyzerException {
        log.error((Object)message);
        throw new AnalyzerException(message);
    }
}

