/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bam.analyzer.analyzers.builders;

import java.util.Arrays;
import java.util.List;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.wso2.carbon.bam.analyzer.analyzers.AnalyzerBuilder;
import org.wso2.carbon.bam.analyzer.analyzers.AnalyzerConfig;
import org.wso2.carbon.bam.analyzer.analyzers.DetectFaultAnalyzer;
import org.wso2.carbon.bam.analyzer.analyzers.configs.DetectFaultConfig;
import org.wso2.carbon.bam.analyzer.engine.Analyzer;
import org.wso2.carbon.bam.analyzer.engine.AnalyzerConfigConstants;
import org.wso2.carbon.bam.analyzer.engine.AnalyzerException;

public class DetectFaultAnalyzerBuilder
extends AnalyzerBuilder {
    @Override
    protected AnalyzerConfig buildConfig(OMElement analyzerXML) throws AnalyzerException {
        OMAttribute errorFields = analyzerXML.getAttribute(AnalyzerConfigConstants.errorFields);
        OMAttribute currentSequenceIdentifier = analyzerXML.getAttribute(AnalyzerConfigConstants.currentSequenceIdentifier);
        DetectFaultConfig detectFaultsConfig = new DetectFaultConfig();
        if (errorFields != null) {
            List<String> errorFieldsValues = Arrays.asList(errorFields.getAttributeValue().split(","));
            detectFaultsConfig.setErrorFields(errorFieldsValues);
        }
        if (currentSequenceIdentifier != null) {
            detectFaultsConfig.setCurrentSequenceIdentifier(currentSequenceIdentifier.getAttributeValue().trim());
        }
        return detectFaultsConfig;
    }

    @Override
    public Analyzer buildAnalyzer(OMElement analyzerXML) throws AnalyzerException {
        return new DetectFaultAnalyzer(this.buildConfig(analyzerXML));
    }
}

