/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bam.analyzer.analyzers.builders;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.bam.analyzer.analyzers.AnalyzerBuilder;
import org.wso2.carbon.bam.analyzer.analyzers.AnalyzerConfig;
import org.wso2.carbon.bam.analyzer.analyzers.configs.ClassConfig;
import org.wso2.carbon.bam.analyzer.engine.Analyzer;
import org.wso2.carbon.bam.analyzer.engine.AnalyzerConfigConstants;
import org.wso2.carbon.bam.analyzer.engine.AnalyzerException;

public class ClassAnalyzerBuilder
extends AnalyzerBuilder {
    private static final Log log = LogFactory.getLog(ClassAnalyzerBuilder.class);

    @Override
    protected AnalyzerConfig buildConfig(OMElement analyzerXML) throws AnalyzerException {
        String analyzerClassName = analyzerXML.getAttribute(AnalyzerConfigConstants.className).getAttributeValue();
        ClassConfig config = new ClassConfig();
        config.setClassName(analyzerClassName);
        if (analyzerClassName == null || "".equals(analyzerClassName)) {
            throw new AnalyzerException("class attribute should not be empty..");
        }
        Iterator propertyIterator = analyzerXML.getChildrenWithLocalName("property");
        HashMap<String, String> properties = new HashMap<String, String>();
        while (propertyIterator.hasNext()) {
            Object propertyElementObject = propertyIterator.next();
            if (!(propertyElementObject instanceof OMElement)) {
                return null;
            }
            OMElement propertyEl = (OMElement)propertyElementObject;
            OMAttribute name = propertyEl.getAttribute(AnalyzerConfigConstants.name);
            OMAttribute value = propertyEl.getAttribute(AnalyzerConfigConstants.value);
            properties.put(name.getAttributeValue(), value.getAttributeValue());
        }
        config.setProperties(properties);
        return config;
    }

    @Override
    public Analyzer buildAnalyzer(OMElement analyzerXML) throws AnalyzerException {
        Object analyzerObject;
        ClassConfig config = (ClassConfig)this.buildConfig(analyzerXML);
        try {
            Class<?> analyzerClass = Class.forName(config.getClassName());
            analyzerObject = analyzerClass.newInstance();
            Field[] field = analyzerClass.getDeclaredFields();
            Method[] methods = analyzerClass.getMethods();
            HashMap<String, Method> setterMap = new HashMap<String, Method>();
            if (methods != null && field != null) {
                block6: for (int i = 0; i < methods.length; ++i) {
                    String methodName = methods[i].getName();
                    if (!methodName.startsWith("set")) continue;
                    for (int j = 0; j < field.length; ++j) {
                        String fieldName = methodName.substring(3).toLowerCase();
                        if (!field[j].getName().contains(fieldName)) continue;
                        setterMap.put(fieldName, methods[i]);
                        continue block6;
                    }
                }
            }
            Map<String, String> properties = config.getProperties();
            block8: for (Map.Entry<String, String> propertyEntry : properties.entrySet()) {
                for (Map.Entry methodEntry : setterMap.entrySet()) {
                    if (!((String)methodEntry.getKey()).equals(propertyEntry.getKey())) continue;
                    try {
                        ((Method)methodEntry.getValue()).invoke(analyzerObject, propertyEntry.getValue());
                    }
                    catch (InvocationTargetException e) {
                        log.error((Object)("Error setting field " + (String)methodEntry.getKey() + " for " + "class analyzer.."));
                    }
                    continue block8;
                }
            }
        }
        catch (ClassNotFoundException e) {
            String msg = config.getClassName() + "Class not available in the class path";
            throw new AnalyzerException(msg, e);
        }
        catch (InstantiationException e) {
            String msg = config.getClassName() + "Class cannot be instantiated or has no nullary" + " constructor";
            throw new AnalyzerException(msg, e);
        }
        catch (IllegalAccessException e) {
            String msg = config.getClassName() + "Class has a private constructor";
            throw new AnalyzerException(msg, e);
        }
        if (!(analyzerObject instanceof Analyzer)) {
            throw new AnalyzerException(config.getClassName() + " does not implement the Analyzer" + " interface");
        }
        return (Analyzer)analyzerObject;
    }
}

