/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bam.analyzer.analyzers.builders;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.wso2.carbon.bam.analyzer.analyzers.AggregateAnalyzer;
import org.wso2.carbon.bam.analyzer.analyzers.AnalyzerBuilder;
import org.wso2.carbon.bam.analyzer.analyzers.AnalyzerConfig;
import org.wso2.carbon.bam.analyzer.analyzers.configs.AggregateConfig;
import org.wso2.carbon.bam.analyzer.analyzers.configs.AggregationMeasure;
import org.wso2.carbon.bam.analyzer.engine.Analyzer;
import org.wso2.carbon.bam.analyzer.engine.AnalyzerConfigConstants;
import org.wso2.carbon.bam.analyzer.engine.AnalyzerException;

public class AggregateAnalyzerBuilder
extends AnalyzerBuilder {
    @Override
    protected AnalyzerConfig buildConfig(OMElement analyzerXML) throws AnalyzerException {
        Iterator measureIterator = analyzerXML.getChildrenWithLocalName("measure");
        ArrayList<AggregationMeasure> measures = new ArrayList<AggregationMeasure>();
        while (measureIterator.hasNext()) {
            Object measureElementObject = measureIterator.next();
            if (!(measureElementObject instanceof OMElement)) {
                return null;
            }
            OMElement measureEl = (OMElement)measureElementObject;
            OMAttribute measureName = measureEl.getAttribute(AnalyzerConfigConstants.name);
            OMAttribute aggregationType = measureEl.getAttribute(AnalyzerConfigConstants.aggregationType);
            OMAttribute fieldType = measureEl.getAttribute(AnalyzerConfigConstants.fieldType);
            if (measureName == null || aggregationType == null) {
                throw new AnalyzerException("measureName and aggregationType are required..");
            }
            String fieldTypeStr = fieldType != null ? fieldType.getAttributeValue() : "DOUBLE";
            AggregationMeasure measure = new AggregationMeasure(measureName.getAttributeValue(), aggregationType.getAttributeValue(), fieldTypeStr);
            measures.add(measure);
        }
        AggregateConfig aggregateConfig = new AggregateConfig();
        aggregateConfig.setMeasures(measures);
        return aggregateConfig;
    }

    @Override
    public Analyzer buildAnalyzer(OMElement analyzerXML) throws AnalyzerException {
        return new AggregateAnalyzer(this.buildConfig(analyzerXML));
    }
}

