/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bam.analyzer.analyzers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.bam.analyzer.analyzers.AbstractAnalyzer;
import org.wso2.carbon.bam.analyzer.analyzers.AnalyzerConfig;
import org.wso2.carbon.bam.analyzer.analyzers.AnalyzerUtils;
import org.wso2.carbon.bam.analyzer.analyzers.configs.PutConfig;
import org.wso2.carbon.bam.analyzer.engine.DataContext;
import org.wso2.carbon.bam.core.configurations.DataSourceType;
import org.wso2.carbon.bam.core.configurations.TableConfiguration;
import org.wso2.carbon.bam.core.dataobjects.Cursor;
import org.wso2.carbon.bam.core.dataobjects.Record;
import org.wso2.carbon.bam.core.persistence.MetaDataManager;
import org.wso2.carbon.bam.core.persistence.PersistenceManager;
import org.wso2.carbon.bam.core.persistence.QueryManager;
import org.wso2.carbon.bam.core.persistence.exceptions.ConfigurationException;
import org.wso2.carbon.bam.core.persistence.exceptions.StoreException;

public class PutAnalyzer
extends AbstractAnalyzer {
    private static final Log log = LogFactory.getLog(PutAnalyzer.class);

    public PutAnalyzer(AnalyzerConfig analyzerConfig) {
        super(analyzerConfig);
    }

    @Override
    public void analyze(DataContext dataContext) {
        Object result = this.getData(dataContext);
        if (result != null) {
            Map existingRecordMap;
            PutConfig config = (PutConfig)this.getAnalyzerConfig();
            String table = config.getColumnFamily();
            String dataSource = config.getDataSource();
            DataSourceType dataSourceType = DataSourceType.valueOf((String)dataSource);
            boolean isDoAggregate = config.isDoAggregate();
            PersistenceManager persistenceManager = new PersistenceManager();
            MetaDataManager metaDataManager = MetaDataManager.getInstance();
            if (result instanceof List) {
                List records = (List)result;
                if (records.size() > 0) {
                    try {
                        if (!persistenceManager.isTableExists(dataContext.getCredentials(), table)) {
                            Record firstRecord = (Record)records.get(0);
                            TableConfiguration configuration = metaDataManager.createTableMetaData(table, firstRecord, dataSourceType, false);
                            persistenceManager.createTable(dataContext.getCredentials(), configuration);
                        }
                        this.putRecords(table, records, isDoAggregate, dataContext);
                    }
                    catch (StoreException e) {
                        log.error((Object)("Error storing records to the table " + table + ".."), (Throwable)e);
                    }
                    catch (ConfigurationException e) {
                        log.error((Object)("Error creating meta data for table " + table + ".."), (Throwable)e);
                    }
                    this.setData(dataContext, null);
                }
            } else if (result instanceof Map && (existingRecordMap = (Map)result).size() > 0) {
                String secondaryTable = table + "_Secondary_" + "secondaryColumnFamilies";
                try {
                    if (!persistenceManager.isTableExists(dataContext.getCredentials(), table)) {
                        TableConfiguration configuration = metaDataManager.createTableMetaData(table, new ArrayList(), dataSourceType, false);
                        configuration.setPrimaryTable(Boolean.TRUE.booleanValue());
                        ArrayList<String> secondaryTables = new ArrayList<String>();
                        secondaryTables.add(secondaryTable);
                        configuration.setSecondaryTables(secondaryTables);
                        persistenceManager.createTable(dataContext.getCredentials(), configuration);
                    }
                }
                catch (StoreException e) {
                    log.error((Object)("Error creating primary table " + table + ".."), (Throwable)e);
                    return;
                }
                catch (ConfigurationException e) {
                    log.error((Object)("Error creating meta data for primary table " + table + ".."), (Throwable)e);
                    return;
                }
                try {
                    if (!persistenceManager.isTableExists(dataContext.getCredentials(), secondaryTable)) {
                        List recordGroup = (List)existingRecordMap.values().iterator().next();
                        Record sampleRecord = null;
                        if (recordGroup != null && recordGroup.size() > 0) {
                            sampleRecord = (Record)recordGroup.get(0);
                        }
                        TableConfiguration configuration = metaDataManager.createTableMetaData(secondaryTable, sampleRecord, dataSourceType, true);
                        persistenceManager.createTable(dataContext.getCredentials(), configuration);
                    }
                }
                catch (StoreException e) {
                    log.error((Object)("Error creating secondary table " + secondaryTable + ".."), (Throwable)e);
                    return;
                }
                catch (ConfigurationException e) {
                    log.error((Object)("Error creating meta data for secondary table " + secondaryTable + ".."), (Throwable)e);
                    return;
                }
                try {
                    ArrayList<Record> primaryTableRecords = new ArrayList<Record>();
                    ArrayList<Record> secondaryTableRecords = new ArrayList<Record>();
                    for (Map.Entry entry : existingRecordMap.entrySet()) {
                        String groupKey = (String)entry.getKey();
                        List groupRecords = (List)entry.getValue();
                        HashMap<String, String> columns = new HashMap<String, String>();
                        for (Record record : groupRecords) {
                            String key = record.getKey();
                            columns.put(key, "");
                        }
                        Record record = new Record(groupKey, columns);
                        primaryTableRecords.add(record);
                        secondaryTableRecords.addAll(groupRecords);
                    }
                    try {
                        this.putRecords(table, primaryTableRecords, false, dataContext);
                    }
                    catch (StoreException e) {
                        log.error((Object)("Error storing records to the primary table " + table + ".."), (Throwable)e);
                    }
                    this.putRecords(secondaryTable, secondaryTableRecords, isDoAggregate, dataContext);
                }
                catch (StoreException e) {
                    log.error((Object)("Error storing records to the secondary table " + secondaryTable + ".."), (Throwable)e);
                    return;
                }
                this.setData(dataContext, null);
            }
            Cursor cursor = this.getAnalyzerSequence().getCursor();
            if (cursor != null) {
                try {
                    metaDataManager.storeCursorMetaData(dataContext.getCredentials(), cursor);
                }
                catch (ConfigurationException e) {
                    log.error((Object)"Error while persisting cursor meta data. This may cause inconsistencies in summarized data..");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Record> putRecords(String table, List<Record> records, boolean isDoAggregate, DataContext context) throws StoreException {
        if (records == null || records.size() == 0) {
            return null;
        }
        PutConfig config = (PutConfig)this.getAnalyzerConfig();
        QueryManager queryManager = new QueryManager();
        ArrayList<Record> result = new ArrayList<Record>();
        PutAnalyzer putAnalyzer = this;
        synchronized (putAnalyzer) {
            if (records != null) {
                for (Record record : records) {
                    List existingRecords;
                    if (isDoAggregate && (existingRecords = queryManager.getRecords(context.getCredentials(), table, record.getKey(), null)) != null && existingRecords.size() > 0) {
                        ArrayList<Record> recordsToAggregate = new ArrayList<Record>();
                        recordsToAggregate.add(record);
                        recordsToAggregate.addAll(existingRecords);
                        record = AnalyzerUtils.aggregateRecords(recordsToAggregate, config.getMeasures(), record.getKey());
                    }
                    result.add(record);
                }
            }
            PersistenceManager persistenceManager = new PersistenceManager();
            persistenceManager.storeRecords(context.getCredentials(), table, result);
        }
        return result;
    }
}

