/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bam.analyzer.analyzers;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.bam.analyzer.analyzers.AbstractAnalyzer;
import org.wso2.carbon.bam.analyzer.analyzers.AnalyzerConfig;
import org.wso2.carbon.bam.analyzer.analyzers.configs.OrderByConfig;
import org.wso2.carbon.bam.analyzer.engine.DataContext;
import org.wso2.carbon.bam.core.dataobjects.Record;

public class OrderByAnalyzer
extends AbstractAnalyzer {
    private static final Log log = LogFactory.getLog(OrderByAnalyzer.class);

    public OrderByAnalyzer(AnalyzerConfig analyzerConfig) {
        super(analyzerConfig);
    }

    @Override
    public void analyze(DataContext dataContext) {
        Object result = this.getData(dataContext);
        if (result != null) {
            if (result instanceof List) {
                List list = (List)result;
                this.orderRecords(list);
            } else if (result instanceof Map) {
                Map existingGroupedRows = (Map)result;
                for (List list : existingGroupedRows.values()) {
                    this.orderRecords(list);
                }
            } else {
                log.error((Object)"Unknown data format in received data for orderBy analyzer..");
            }
        } else {
            log.warn((Object)("Data flow empty at orderBy analyzer in sequence : " + this.getAnalyzerSequenceName()));
        }
        this.setData(dataContext, result);
    }

    private void orderRecords(List<Record> list) {
        OrderByConfig config = (OrderByConfig)this.getAnalyzerConfig();
        RecordComparator rowComparator = new RecordComparator(config.getField());
        Collections.sort(list, rowComparator);
    }

    private class RecordComparator
    implements Comparator<Record> {
        private String field;

        public RecordComparator(String field) {
            this.field = field;
        }

        @Override
        public int compare(Record record, Record nextRecord) {
            String fieldValue = this.findFieldValue(record);
            String nextFieldValue = this.findFieldValue(nextRecord);
            if (fieldValue != null) {
                return fieldValue.compareTo(nextFieldValue);
            }
            return -1;
        }

        private String findFieldValue(Record record) {
            Map columns = record.getColumns();
            return (String)columns.get(this.field);
        }
    }
}

