/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bam.analyzer.analyzers;

import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.bam.analyzer.analyzers.AbstractAnalyzer;
import org.wso2.carbon.bam.analyzer.analyzers.AnalyzerConfig;
import org.wso2.carbon.bam.analyzer.analyzers.IndexingAnalyzer;
import org.wso2.carbon.bam.analyzer.engine.DataContext;
import org.wso2.carbon.bam.core.dataobjects.Record;

public class LogAnalyzer
extends AbstractAnalyzer {
    private static final Log log = LogFactory.getLog(IndexingAnalyzer.class);

    public LogAnalyzer(AnalyzerConfig analyzerConfig) {
        super(analyzerConfig);
    }

    @Override
    public void analyze(DataContext dataContext) {
        block5: {
            Object result;
            block6: {
                result = this.getData(dataContext);
                if (result == null) break block5;
                if (!(result instanceof List)) break block6;
                List records = (List)result;
                for (Record record : records) {
                    Map columns = record.getColumns();
                    String key = record.getKey();
                    log.info((Object)("Record key : " + key + "\n"));
                    for (Map.Entry entry : columns.entrySet()) {
                        String columnKey = (String)entry.getKey();
                        String columnValue = (String)entry.getValue();
                        log.info((Object)("\t Column : { Key : " + columnKey + " Value : " + columnValue + "} \n"));
                    }
                }
                break block5;
            }
            if (!(result instanceof Map)) break block5;
            Map recordMap = (Map)result;
            for (Map.Entry group : recordMap.entrySet()) {
                String groupKey = (String)group.getKey();
                log.info((Object)("Group key : " + groupKey + "\n"));
                List records = (List)group.getValue();
                for (Record record : records) {
                    String key = record.getKey();
                    log.info((Object)("\t Record key : " + key + "\n"));
                    Map columns = record.getColumns();
                    for (Map.Entry entry : columns.entrySet()) {
                        String columnKey = (String)entry.getKey();
                        String columnValue = (String)entry.getValue();
                        log.info((Object)("\t\t Column : { Key : " + columnKey + " Value : " + columnValue + "} \n"));
                    }
                }
            }
        }
    }
}

