/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bam.analyzer.analyzers;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.bam.analyzer.analyzers.AbstractAnalyzer;
import org.wso2.carbon.bam.analyzer.analyzers.AnalyzerConfig;
import org.wso2.carbon.bam.analyzer.analyzers.configs.Attribute;
import org.wso2.carbon.bam.analyzer.analyzers.configs.JMXConfig;
import org.wso2.carbon.bam.analyzer.analyzers.configs.Operation;
import org.wso2.carbon.bam.analyzer.analyzers.configs.Parameter;
import org.wso2.carbon.bam.analyzer.engine.DataContext;
import org.wso2.carbon.bam.core.dataobjects.Record;

public class JMXAnalyzer
extends AbstractAnalyzer {
    private static final Log log = LogFactory.getLog(JMXAnalyzer.class);
    private static SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private List<String> primitiveTypes = new ArrayList<String>();

    public JMXAnalyzer(AnalyzerConfig analyzerConfig) {
        super(analyzerConfig);
        this.primitiveTypes.add("java.lang.Short");
        this.primitiveTypes.add("java.lang.Integer");
        this.primitiveTypes.add("java.lang.Long");
        this.primitiveTypes.add("java.lang.Float");
        this.primitiveTypes.add("java.lang.Double");
        this.primitiveTypes.add("java.lang.String");
    }

    @Override
    public void analyze(DataContext dataContext) {
        JMXConfig config = (JMXConfig)this.getAnalyzerConfig();
        try {
            List<Operation> operations;
            HashMap<String, String[]> env = new HashMap<String, String[]>();
            String[] creds = new String[]{"admin", "admin"};
            env.put("jmx.remote.credentials", creds);
            JMXServiceURL url = new JMXServiceURL(config.getUrl());
            JMXConnector jmxc = JMXConnectorFactory.connect(url, env);
            MBeanServerConnection mbsc = jmxc.getMBeanServerConnection();
            List<Attribute> attributes = config.getAttributes();
            HashMap<String, String> values = new HashMap<String, String>();
            if (attributes != null) {
                for (Attribute attribute : attributes) {
                    Object value;
                    try {
                        value = mbsc.getAttribute(new ObjectName(attribute.getMbean()), attribute.getName());
                    }
                    catch (Exception e) {
                        log.error((Object)("Unable to fetch value of attribute " + attribute.getName() + ".."), (Throwable)e);
                        continue;
                    }
                    if (value == null) continue;
                    this.insertToValueMap(attribute.getName(), value, values);
                }
            }
            if ((operations = config.getOperations()) != null) {
                for (Operation operation : operations) {
                    Object value;
                    List<Parameter> parameters = operation.getParameters();
                    ArrayList<Object> parameterValues = null;
                    ArrayList<String> parameterTypes = null;
                    if (parameters != null) {
                        parameterValues = new ArrayList<Object>();
                        parameterTypes = new ArrayList<String>();
                        for (Parameter parameter : parameters) {
                            String parameterType = parameter.getType();
                            Object parameterValue = this.getPrimitiveObject(parameterType, parameter.getValue());
                            parameterValues.add(parameterValue);
                            parameterTypes.add(parameterType);
                        }
                    }
                    Object[] parameterValuesArray = null;
                    if (parameterValues != null) {
                        parameterValuesArray = parameterValues.toArray();
                    }
                    String[] parameterTypesArray = null;
                    if (parameterTypes != null) {
                        parameterTypesArray = parameterTypes.toArray(new String[0]);
                    }
                    try {
                        value = mbsc.invoke(new ObjectName(operation.getMbean()), operation.getName(), parameterValuesArray, parameterTypesArray);
                    }
                    catch (Exception e) {
                        log.error((Object)("Unable to fetch result of invocation of the operation " + operation.getName() + ".."), (Throwable)e);
                        continue;
                    }
                    if (value == null) continue;
                    this.insertToValueMap(operation.getName(), value, values);
                }
            }
            String recordKey = formatter.format(new Date()) + "---" + UUID.randomUUID().toString();
            Record record = new Record(recordKey, values);
            ArrayList<Record> result = new ArrayList<Record>();
            result.add(record);
            this.setData(dataContext, result);
        }
        catch (MalformedURLException e) {
            log.error((Object)"JMX URL is invalid..", (Throwable)e);
        }
        catch (IOException e) {
            log.error((Object)"Unable to connect to JMX server..", (Throwable)e);
        }
    }

    private void insertToValueMap(String attribute, Object value, Map<String, String> values) {
        String className = value.getClass().getName();
        if (this.primitiveTypes.contains(className)) {
            values.put(attribute, value.toString());
        } else {
            this.insertComplexValueToMap(attribute, value, values);
        }
    }

    private void insertComplexValueToMap(String attribute, Object value, Map<String, String> values) {
        Class<?> clazz = value.getClass();
        Method[] methods = clazz.getMethods();
        if (methods != null) {
            for (Method method : methods) {
                if (!method.getName().startsWith("get")) continue;
                try {
                    Object object = method.invoke(value, new Object[0]);
                    String fieldName = method.getName().substring(3);
                    if (this.primitiveTypes.contains(object.getClass().getName())) {
                        values.put(attribute + "_" + fieldName, object.toString());
                        continue;
                    }
                    log.error((Object)"Attribute value should be a primitive or a bean with primitive getters..");
                }
                catch (IllegalAccessException e) {
                    log.error((Object)("Unable to fetch value for attribute " + attribute + ".."));
                }
                catch (InvocationTargetException e) {
                    log.error((Object)("Unable to fetch value for attribute " + attribute + ".."));
                }
            }
        }
    }

    private Object getPrimitiveObject(String type, String value) {
        if (type.equals("java.lang.String")) {
            return value;
        }
        if (type.equals("java.lang.Short")) {
            return Short.parseShort(value);
        }
        if (type.equals("java.lang.Integer")) {
            return Integer.parseInt(value);
        }
        if (type.equals("java.lang.Long")) {
            return Long.parseLong(value);
        }
        if (type.equals("java.lang.Float")) {
            return Float.valueOf(Float.parseFloat(value));
        }
        if (type.equals("java.lang.Double")) {
            return Double.parseDouble(value);
        }
        return value;
    }

    public static void main(String[] args) {
        JMXConfig config = new JMXConfig("service:jmx:rmi:///jndi/rmi://:9999/jmxrmi");
        Attribute attribute0 = new Attribute("org.apache.synapse:Type=Endpoint,Name=endpoint_3d13d60079b7d734b3a29fa3f18c5a8cee6133787a781409", "MetricsWindow");
        config.addAttribute(attribute0);
        Attribute attribute1 = new Attribute("org.apache.synapse:Type=Threading,Name=HttpClientWorker", "LastResetTime");
        config.addAttribute(attribute1);
        Attribute attribute2 = new Attribute("Tomcat:type=Connector,port=9443", "redirectPort");
        config.addAttribute(attribute2);
        Operation operation0 = new Operation("org.wso2.carbon:type=StatisticsAdmin", "getServiceRequestCount");
        Parameter parameter = new Parameter("echo", "java.lang.String");
        operation0.addParameter(parameter);
        config.addOperation(operation0);
        JMXAnalyzer analyzer = new JMXAnalyzer(config);
        analyzer.analyze(null);
    }
}

