/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bam.analyzer.analyzers;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections.map.UnmodifiableMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.bam.analyzer.analyzers.AbstractAnalyzer;
import org.wso2.carbon.bam.analyzer.analyzers.AnalyzerConfig;
import org.wso2.carbon.bam.analyzer.analyzers.configs.IndexingConfig;
import org.wso2.carbon.bam.analyzer.engine.DataContext;
import org.wso2.carbon.bam.core.persistence.IndexManager;
import org.wso2.carbon.bam.core.persistence.exceptions.IndexingException;

public class IndexingAnalyzer
extends AbstractAnalyzer {
    private static final Log log = LogFactory.getLog(IndexingAnalyzer.class);

    public IndexingAnalyzer(AnalyzerConfig analyzerConfig) {
        super(analyzerConfig);
    }

    @Override
    public void analyze(DataContext dataContext) {
        String cursorName = this.getAnalyzerSequenceName() + this.getPositionInSequence();
        IndexingConfig config = (IndexingConfig)this.getAnalyzerConfig();
        try {
            IndexManager.getInstance().indexData(config.getIndexConfiguration(), dataContext.getCredentials(), cursorName);
        }
        catch (IndexingException e) {
            log.error((Object)("Error while indexing table " + config.getIndexConfiguration().getIndexedTable() + ".."), (Throwable)e);
        }
    }

    private Map<String, String> createNonDefaultDataMap(String rowKeyToIndex) {
        HashMap<String, String> nonDefaultMap = new HashMap<String, String>();
        nonDefaultMap.put(rowKeyToIndex, "");
        return UnmodifiableMap.decorate(nonDefaultMap);
    }
}

