/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bam.analyzer.analyzers;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.bam.analyzer.analyzers.AbstractAnalyzer;
import org.wso2.carbon.bam.analyzer.analyzers.AnalyzerConfig;
import org.wso2.carbon.bam.analyzer.analyzers.configs.GroupByConfig;
import org.wso2.carbon.bam.analyzer.engine.DataContext;
import org.wso2.carbon.bam.core.configurations.Granularity;
import org.wso2.carbon.bam.core.dataobjects.Record;
import org.wso2.carbon.bam.core.utils.TimeStampFactory;

public class GroupByAnalyzer
extends AbstractAnalyzer {
    private static final Log log = LogFactory.getLog(GroupByAnalyzer.class);

    public GroupByAnalyzer(AnalyzerConfig analyzerConfig) {
        super(analyzerConfig);
    }

    @Override
    public void analyze(DataContext dataContext) {
        Object result = this.getData(dataContext);
        HashMap<String, List<Record>> recordMap = new HashMap<String, List<Record>>();
        if (result != null) {
            if (result instanceof List) {
                List list = (List)result;
                this.groupRecords(list, recordMap);
            } else if (result instanceof Map) {
                Map existingGroupedRows = (Map)result;
                for (List list : existingGroupedRows.values()) {
                    this.groupRecords(list, recordMap);
                }
            } else {
                log.error((Object)"Unknown data format in received data for groupBy analyzer..");
            }
        } else {
            log.warn((Object)("Data flow empty at groupBy analyzer in sequence : " + this.getAnalyzerSequenceName()));
        }
        this.setData(dataContext, recordMap);
    }

    private void groupRecords(List<Record> records, Map<String, List<Record>> recordMap) {
        GroupByConfig config = (GroupByConfig)this.getAnalyzerConfig();
        List<String> fields = config.getFields();
        block2: for (Record record : records) {
            List<Record> groupMembers;
            Map columns = record.getColumns();
            StringBuffer sb = new StringBuffer();
            for (String field : fields) {
                boolean fieldFound = false;
                String timeStamp = null;
                for (Map.Entry entry : columns.entrySet()) {
                    if (!((String)entry.getKey()).equals(field)) continue;
                    if (((String)entry.getKey()).equals(config.getTimeField())) {
                        try {
                            timeStamp = TimeStampFactory.getFactory().getTimeStamp((String)entry.getValue(), Granularity.valueOf((String)config.getGranularity()));
                            sb.append(timeStamp);
                            sb.append("---");
                        }
                        catch (ParseException e) {
                            log.error((Object)"Invalid timeStamp. TimeStamp will not be included in the group key..");
                        }
                        fieldFound = true;
                        break;
                    }
                    sb.append((String)entry.getValue());
                    sb.append("---");
                    fieldFound = true;
                    break;
                }
                if (!fieldFound) continue block2;
                if (timeStamp == null) continue;
                columns.put(config.getTimeField(), timeStamp);
            }
            boolean isMultipleGroupBy = sb.lastIndexOf("---") == -1 ? Boolean.FALSE : Boolean.TRUE;
            String groupKey = sb.toString();
            if (isMultipleGroupBy) {
                groupKey = groupKey.substring(0, sb.lastIndexOf("---"));
            }
            if ((groupMembers = recordMap.get(groupKey)) == null) {
                groupMembers = new ArrayList<Record>();
            }
            groupMembers.add(record);
            recordMap.put(groupKey, groupMembers);
        }
    }
}

