/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bam.analyzer.analyzers;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.bam.analyzer.analyzers.AbstractAnalyzer;
import org.wso2.carbon.bam.analyzer.analyzers.AnalyzerConfig;
import org.wso2.carbon.bam.analyzer.analyzers.configs.GetConfig;
import org.wso2.carbon.bam.analyzer.engine.DataContext;
import org.wso2.carbon.bam.core.configurations.IndexConfiguration;
import org.wso2.carbon.bam.core.configurations.TableConfiguration;
import org.wso2.carbon.bam.core.dataobjects.Cursor;
import org.wso2.carbon.bam.core.persistence.MetaDataManager;
import org.wso2.carbon.bam.core.persistence.QueryIndex;
import org.wso2.carbon.bam.core.persistence.QueryManager;
import org.wso2.carbon.bam.core.persistence.exceptions.ConfigurationException;
import org.wso2.carbon.bam.core.persistence.exceptions.StoreException;

public class GetAnalyzer
extends AbstractAnalyzer {
    private static final Log log = LogFactory.getLog(GetAnalyzer.class);

    public GetAnalyzer(AnalyzerConfig analyzerConfig) {
        super(analyzerConfig);
    }

    @Override
    public void analyze(DataContext dataContext) {
        GetConfig getConfig = (GetConfig)this.getAnalyzerConfig();
        MetaDataManager metaDataManager = MetaDataManager.getInstance();
        try {
            TableConfiguration tableConfiguration = metaDataManager.getTableMetaData(this.getExecutingTenantId(), getConfig.getTable());
            QueryIndex index = getConfig.getIndex();
            String indexName = null;
            if (index != null) {
                indexName = getConfig.getIndex().getIndexName();
            }
            IndexConfiguration indexConfiguration = null;
            if (indexName != null) {
                indexConfiguration = metaDataManager.getIndexMetaData(dataContext.getCredentials(), indexName);
            }
            if (tableConfiguration == null || indexName != null && indexConfiguration == null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Returning from get analyzer since required table or index is not present yet..");
                }
                return;
            }
        }
        catch (ConfigurationException e) {
            log.error((Object)"Error while fetching table and index meta data. Returning from get analyzer..", (Throwable)e);
            return;
        }
        List records = null;
        QueryManager manager = new QueryManager();
        if (this.isBatchSizeDefined(getConfig)) {
            try {
                Cursor cursor = new Cursor(getConfig.getTable(), this.getAnalyzerSequenceName(), this.getPositionInSequence());
                records = manager.getRecords(dataContext.getCredentials(), getConfig.getTable(), getConfig.getIndex(), null, getConfig.getBatchSize(), cursor);
                if (cursor.getResumePoint() != null) {
                    this.getAnalyzerSequence().setCursor(cursor);
                }
            }
            catch (StoreException e) {
                this.handleException(getConfig, (Exception)((Object)e));
            }
        } else {
            try {
                records = manager.getRecords(dataContext.getCredentials(), getConfig.getTable(), getConfig.getIndex(), null);
            }
            catch (StoreException e) {
                this.handleException(getConfig, (Exception)((Object)e));
            }
        }
        this.setData(dataContext, records);
    }

    private void handleException(GetConfig getConfig, Exception e) {
        log.error((Object)("Error while fetching data from table " + getConfig.getTable() + ".."), (Throwable)e);
        throw new RuntimeException(e);
    }

    private boolean isBatchSizeDefined(GetConfig config) {
        return config.getBatchSize() < Integer.MAX_VALUE;
    }
}

