/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bam.analyzer.analyzers;

import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMDocument;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.util.AXIOMUtil;
import org.apache.axiom.om.xpath.AXIOMXPath;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jaxen.JaxenException;
import org.wso2.carbon.bam.analyzer.analyzers.AbstractAnalyzer;
import org.wso2.carbon.bam.analyzer.analyzers.AnalyzerConfig;
import org.wso2.carbon.bam.analyzer.analyzers.configs.ExtractConfig;
import org.wso2.carbon.bam.analyzer.analyzers.configs.ExtractField;
import org.wso2.carbon.bam.analyzer.engine.DataContext;
import org.wso2.carbon.bam.core.dataobjects.Record;

public class ExtractAnalyzer
extends AbstractAnalyzer {
    private static final Log log = LogFactory.getLog(ExtractAnalyzer.class);

    public ExtractAnalyzer(AnalyzerConfig analyzerConfig) {
        super(analyzerConfig);
    }

    @Override
    public void analyze(DataContext dataContext) {
        Object result = this.getData(dataContext);
        this.analyze(result);
    }

    public void analyze(Object result) {
        if (result != null) {
            if (result instanceof List) {
                List list = (List)result;
                this.processRecords(list);
            } else if (result instanceof Map) {
                Map existingRecordMap = (Map)result;
                for (List list : existingRecordMap.values()) {
                    this.processRecords(list);
                }
            } else {
                log.error((Object)"Unknown data format in received data for extract analyzer..");
            }
        } else {
            log.warn((Object)("Data flow empty at extract analyzer in sequence : " + this.getAnalyzerSequenceName()));
        }
    }

    private void processRecords(List<Record> records) {
        ExtractConfig config = (ExtractConfig)this.getAnalyzerConfig();
        List<ExtractField> fields = config.getFields();
        for (Record record : records) {
            Map columns = record.getColumns();
            block4: for (ExtractField field : fields) {
                for (Map.Entry column : columns.entrySet()) {
                    if (!field.getFrom().equals(column.getKey())) continue;
                    try {
                        AXIOMXPath xpath = new AXIOMXPath(field.getXpath());
                        Map<String, String> namespaces = field.getNamespaces();
                        for (Map.Entry<String, String> entry : namespaces.entrySet()) {
                            xpath.addNamespace(entry.getKey(), entry.getValue());
                        }
                        String xmlContent = (String)column.getValue();
                        OMElement element = AXIOMUtil.stringToOM((String)xmlContent);
                        List results = xpath.selectNodes((Object)element);
                        String value = null;
                        if (results != null && results.size() > 0) {
                            OMContainer container = (OMContainer)results.get(0);
                            OMElement resultElement = container instanceof OMDocument ? ((OMDocument)container).getOMDocumentElement() : (OMElement)container;
                            value = resultElement.getText();
                        }
                        if (value == null) continue block4;
                        record.addColumn(field.getName(), value);
                    }
                    catch (JaxenException e) {
                        log.error((Object)"Error while initializing xpath..", (Throwable)e);
                    }
                    catch (XMLStreamException e) {
                        log.error((Object)"Error while initializing xml content..", (Throwable)e);
                    }
                    continue block4;
                }
            }
        }
    }
}

