/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bam.analyzer.analyzers;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.bam.analyzer.analyzers.AbstractAnalyzer;
import org.wso2.carbon.bam.analyzer.analyzers.AnalyzerConfig;
import org.wso2.carbon.bam.analyzer.analyzers.configs.DropConfig;
import org.wso2.carbon.bam.analyzer.analyzers.configs.FilterField;
import org.wso2.carbon.bam.analyzer.engine.DataContext;
import org.wso2.carbon.bam.core.dataobjects.Record;

public class DropAnalyzer
extends AbstractAnalyzer {
    private static final Log log = LogFactory.getLog(DropAnalyzer.class);

    public DropAnalyzer(AnalyzerConfig analyzerConfig) {
        super(analyzerConfig);
    }

    @Override
    public void analyze(DataContext dataContext) {
        String type = ((DropConfig)this.getAnalyzerConfig()).getType();
        if (type.equalsIgnoreCase("row")) {
            this.filterRows(dataContext);
        } else if (type.equalsIgnoreCase("column")) {
            this.filterColumns(dataContext);
        } else if (type.equalsIgnoreCase("group")) {
            this.filterGroups(dataContext);
        }
    }

    private void filterRows(DataContext dataContext) {
        Object result = this.getData(dataContext);
        if (result != null) {
            if (result instanceof List) {
                List list = (List)result;
                this.filterRecordsFromList(list);
            } else if (result instanceof Map) {
                Map existingGroupedRows = (Map)result;
                for (List list : existingGroupedRows.values()) {
                    this.filterRecordsFromList(list);
                }
            } else {
                log.error((Object)"Unknown data format in received data for extract analyzer..");
            }
        } else {
            log.warn((Object)("Data flow empty at extract analyzer in sequence : " + this.getAnalyzerSequenceName()));
        }
    }

    private void filterRecordsFromList(List<Record> list) {
        block9: {
            List<FilterField> filters;
            String matchUsing;
            block8: {
                matchUsing = ((DropConfig)this.getAnalyzerConfig()).getMatchUsing();
                filters = ((DropConfig)this.getAnalyzerConfig()).getFieldFilters();
                if (!matchUsing.equalsIgnoreCase("and")) break block8;
                Iterator<Record> listIterator = list.iterator();
                while (listIterator.hasNext()) {
                    Record record = listIterator.next();
                    boolean shouldDrop = true;
                    for (FilterField filter : filters) {
                        String filterField = filter.getName();
                        String regex = filter.getRegex();
                        boolean fieldFound = false;
                        Map columns = record.getColumns();
                        for (Map.Entry entry : columns.entrySet()) {
                            Pattern pattern;
                            Matcher matcher;
                            if (!filterField.equals(entry.getKey())) continue;
                            if (regex != null && regex != null && !(matcher = (pattern = Pattern.compile(regex)).matcher((CharSequence)entry.getValue())).matches()) {
                                shouldDrop = false;
                            }
                            fieldFound = true;
                            break;
                        }
                        if (fieldFound) continue;
                        shouldDrop = false;
                        break;
                    }
                    if (!shouldDrop) continue;
                    listIterator.remove();
                }
                break block9;
            }
            if (!matchUsing.equalsIgnoreCase("or")) break block9;
            Iterator<Record> listIterator = list.iterator();
            block3: while (listIterator.hasNext()) {
                Record record = listIterator.next();
                for (FilterField filter : filters) {
                    String filterField = filter.getName();
                    String regex = filter.getRegex();
                    Map colums = record.getColumns();
                    for (Map.Entry entry : colums.entrySet()) {
                        if (!filterField.equals(entry.getKey())) continue;
                        if (regex != null) {
                            Pattern pattern;
                            Matcher matcher;
                            if (regex == null || (matcher = (pattern = Pattern.compile(regex)).matcher((CharSequence)entry.getValue())).matches()) continue;
                            listIterator.remove();
                            continue block3;
                        }
                        listIterator.remove();
                        continue block3;
                    }
                }
            }
        }
    }

    private void filterColumns(DataContext dataContext) {
        Object result = this.getData(dataContext);
        if (result != null) {
            if (result instanceof List) {
                List list = (List)result;
                this.filterColumnsFromList(list);
            } else if (result instanceof Map) {
                Map existingGroupedRows = (Map)result;
                for (List list : existingGroupedRows.values()) {
                    this.filterColumnsFromList(list);
                }
            } else {
                log.error((Object)"Unknown data format in received data for extract analyzer..");
            }
        } else {
            log.warn((Object)("Data flow empty at extract analyzer in sequence : " + this.getAnalyzerSequenceName()));
        }
    }

    private void filterColumnsFromList(List<Record> list) {
        List<FilterField> filters = ((DropConfig)this.getAnalyzerConfig()).getFieldFilters();
        for (Record record : list) {
            Map columns = record.getColumns();
            block1: for (FilterField field : filters) {
                Iterator columnIterator = columns.entrySet().iterator();
                while (columnIterator.hasNext()) {
                    Map.Entry column = columnIterator.next();
                    String filterField = field.getName();
                    String regex = field.getRegex();
                    if (!filterField.equals(column.getKey())) continue;
                    if (regex != null) {
                        Pattern pattern;
                        Matcher matcher;
                        if (regex == null || (matcher = (pattern = Pattern.compile(regex)).matcher((CharSequence)column.getValue())).matches()) continue block1;
                        columnIterator.remove();
                        continue block1;
                    }
                    columnIterator.remove();
                    continue block1;
                }
            }
        }
    }

    private void filterGroups(DataContext dataContext) {
        Object result = this.getData(dataContext);
        if (result != null) {
            if (result instanceof List) {
                log.warn((Object)"Mismatch in drop analyzer input. Expected : grouped rows Received : row list. Data flow will not be modified..");
            } else if (result instanceof Map) {
                Map existingRecordMap = (Map)result;
                List<String> groupFilters = ((DropConfig)this.getAnalyzerConfig()).getGroupFilters();
                for (String groupFilter : groupFilters) {
                    Iterator entryIterator = existingRecordMap.entrySet().iterator();
                    while (entryIterator.hasNext()) {
                        String groupKey = (String)entryIterator.next().getKey();
                        Pattern pattern = Pattern.compile(groupFilter);
                        Matcher matcher = pattern.matcher(groupKey);
                        if (!matcher.matches()) continue;
                        existingRecordMap.remove(groupKey);
                    }
                }
            } else {
                log.error((Object)"Unknown data format in received data for extract analyzer..");
            }
        } else {
            log.warn((Object)("Data flow empty at extract analyzer in sequence : " + this.getAnalyzerSequenceName()));
        }
    }
}

