/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bam.analyzer.analyzers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMDocument;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.util.AXIOMUtil;
import org.apache.axiom.om.xpath.AXIOMXPath;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jaxen.JaxenException;
import org.wso2.carbon.bam.analyzer.analyzers.AbstractAnalyzer;
import org.wso2.carbon.bam.analyzer.analyzers.AnalyzerConfig;
import org.wso2.carbon.bam.analyzer.analyzers.configs.DetectFaultConfig;
import org.wso2.carbon.bam.analyzer.analyzers.configs.ExtractConfig;
import org.wso2.carbon.bam.analyzer.analyzers.configs.ExtractField;
import org.wso2.carbon.bam.analyzer.engine.DataContext;
import org.wso2.carbon.bam.core.dataobjects.Record;

public class DetectFaultAnalyzer
extends AbstractAnalyzer {
    private static final Log log = LogFactory.getLog(DetectFaultAnalyzer.class);
    public static final String SOAP_ENV_NAMESPACE_PREFIX = "soapenv";
    public static final String FAULT_CODE = "faultCode";
    public static final String FAULT_REASON = "faultReason";
    public static final String TIMESTAMP = "timestamp";
    public static final String SOAP_ENVELOP_NAMESPACE_URI = "soap_envelop_namespace";
    public static final String MSG_BODY = "message_body";
    private DetectFaultConfig detectFaultAnalyzerConfig;

    public DetectFaultAnalyzer(AnalyzerConfig analyzerConfig) {
        super(analyzerConfig);
    }

    @Override
    public void analyze(DataContext dataContext) {
        this.detectFaultAnalyzerConfig = (DetectFaultConfig)this.getAnalyzerConfig();
        List<String> errorFields = this.detectFaultAnalyzerConfig.getErrorFields();
        String currentSequenceIdentifier = this.detectFaultAnalyzerConfig.getCurrentSequenceIdentifier();
        ArrayList<Record> detectFaultRecords = new ArrayList<Record>();
        Object result = this.getData(dataContext);
        if (result != null) {
            if (result instanceof Map) {
                Map recordMap = (Map)result;
                for (Map.Entry group : recordMap.entrySet()) {
                    String groupKey = (String)group.getKey();
                    List records = (List)group.getValue();
                    String path = "";
                    for (Record record : records) {
                        Map columns = record.getColumns();
                        boolean fault = false;
                        String timestamp = null;
                        ExtractConfig extractConfig = null;
                        String soapBody = null;
                        block5: for (Map.Entry entry : columns.entrySet()) {
                            String columnKey = (String)entry.getKey();
                            String columnValue = (String)entry.getValue();
                            if (columnKey.equals(currentSequenceIdentifier)) {
                                if (path.equals("")) {
                                    path = path + columnValue;
                                    continue;
                                }
                                path = path + "-->" + columnValue;
                                continue;
                            }
                            if (columnKey.equals(TIMESTAMP)) {
                                timestamp = columnValue;
                                continue;
                            }
                            if (columnKey.equals(SOAP_ENVELOP_NAMESPACE_URI)) {
                                if (columnValue.equals("http://schemas.xmlsoap.org/soap/envelope/")) {
                                    extractConfig = this.createAndGetExtractConfigForSoap11();
                                    continue;
                                }
                                if (columnValue.equals("http://www.w3.org/2003/05/soap-envelope")) {
                                    extractConfig = this.createAndGetExtractConfigForSoap12();
                                    continue;
                                }
                                log.error((Object)"Not a standard soap message");
                                continue;
                            }
                            if (columnKey.equals(MSG_BODY)) {
                                soapBody = columnValue;
                                continue;
                            }
                            if (errorFields == null) continue;
                            for (String errorField : errorFields) {
                                if (!columnKey.equals(errorField.trim())) continue;
                                fault = true;
                                continue block5;
                            }
                        }
                        if (soapBody != null) {
                            List<ExtractField> fields = extractConfig.getFields();
                            for (ExtractField field : fields) {
                                try {
                                    AXIOMXPath xpath = new AXIOMXPath(field.getXpath());
                                    Map<String, String> namespaces = field.getNamespaces();
                                    for (Map.Entry<String, String> entry : namespaces.entrySet()) {
                                        xpath.addNamespace(entry.getKey(), entry.getValue());
                                    }
                                    String xmlContent = soapBody;
                                    OMElement element = AXIOMUtil.stringToOM((String)xmlContent);
                                    List results = xpath.selectNodes((Object)element);
                                    String value = null;
                                    if (results != null && results.size() > 0) {
                                        fault = true;
                                        OMContainer container = (OMContainer)results.get(0);
                                        OMElement resultElement = container instanceof OMDocument ? ((OMDocument)container).getOMDocumentElement() : (OMElement)container;
                                        value = resultElement.getText();
                                    }
                                    if (value == null) continue;
                                    columns.put(field.getName(), value);
                                }
                                catch (JaxenException e) {
                                    log.error((Object)"Error while initializing xpath..", (Throwable)e);
                                }
                                catch (XMLStreamException e) {
                                    log.error((Object)"Error while initializing xml content..", (Throwable)e);
                                }
                            }
                        }
                        if (!fault) continue;
                        String newKey = timestamp + groupKey + UUID.randomUUID().toString();
                        HashMap<String, String> resultColumns = new HashMap<String, String>();
                        resultColumns.putAll(columns);
                        resultColumns.put("bam_message_path", path);
                        Record resultRecord = new Record(newKey, columns);
                        detectFaultRecords.add(resultRecord);
                    }
                }
            } else if (result instanceof List) {
                // empty if block
            }
            this.setData(dataContext, detectFaultRecords);
        }
    }

    private ExtractConfig createAndGetExtractConfigForSoap12() {
        ArrayList<ExtractField> extractFields = new ArrayList<ExtractField>();
        HashMap<String, String> namespace = new HashMap<String, String>();
        namespace.put(SOAP_ENV_NAMESPACE_PREFIX, "http://www.w3.org/2003/05/soap-envelope");
        this.createExtractFieldObj(extractFields, namespace, FAULT_CODE, "//soapenv:Code//soapenv:Value");
        this.createExtractFieldObj(extractFields, namespace, FAULT_REASON, "//soapenv:Reason//soapenv:Text");
        ExtractConfig extractConfig = new ExtractConfig();
        extractConfig.setFields(extractFields);
        return extractConfig;
    }

    private ExtractConfig createAndGetExtractConfigForSoap11() {
        ArrayList<ExtractField> extractFields = new ArrayList<ExtractField>();
        HashMap<String, String> namespace = new HashMap<String, String>();
        namespace.put(SOAP_ENV_NAMESPACE_PREFIX, "http://schemas.xmlsoap.org/soap/envelope/");
        this.createExtractFieldObj(extractFields, namespace, FAULT_CODE, "//faultcode");
        this.createExtractFieldObj(extractFields, namespace, FAULT_REASON, "//faultstring");
        ExtractConfig extractConfig = new ExtractConfig();
        extractConfig.setFields(extractFields);
        return extractConfig;
    }

    private void createExtractFieldObj(List<ExtractField> extractFields, Map<String, String> namespace, String name, String xpath) {
        ExtractField extractFaultCodeField = new ExtractField();
        extractFaultCodeField.setFrom(MSG_BODY);
        extractFaultCodeField.setName(name);
        extractFaultCodeField.setXpath(xpath);
        extractFaultCodeField.setNamespaces(namespace);
        extractFields.add(extractFaultCodeField);
    }
}

