/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bam.analyzer.analyzers;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.wso2.carbon.bam.analyzer.analyzers.configs.AggregationMeasure;
import org.wso2.carbon.bam.analyzer.analyzers.configs.AggregationType;
import org.wso2.carbon.bam.core.dataobjects.Record;

public class AnalyzerUtils {
    public static Record aggregateRecords(List<Record> records, List<AggregationMeasure> measures, String key) {
        HashMap<String, String> counts = new HashMap<String, String>();
        HashMap otherColumns = new HashMap();
        long rowCount = 0L;
        for (Record record2 : records) {
            Map columns = record2.getColumns();
            ++rowCount;
            block1: for (AggregationMeasure aggregationMeasure : measures) {
                Iterator iterator = columns.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    if (!aggregationMeasure.getName().equals(entry.getKey())) continue;
                    String runningCountStr = (String)counts.get(aggregationMeasure.getName());
                    Double runningCount = runningCountStr != null ? Double.valueOf(Double.parseDouble(runningCountStr)) : Double.valueOf(0.0);
                    Double current = Double.parseDouble((String)entry.getValue());
                    Double newRunningCount = AnalyzerUtils.getNewRunningCount(runningCount, current, rowCount, aggregationMeasure.getAggregationType());
                    counts.put(aggregationMeasure.getName(), newRunningCount.toString());
                    iterator.remove();
                    continue block1;
                }
            }
            for (Map.Entry entry : columns.entrySet()) {
                if (otherColumns.containsKey(entry.getKey())) {
                    String columnValue = (String)otherColumns.get(entry.getKey());
                    if (columnValue == null || columnValue.equals(entry.getValue())) continue;
                    otherColumns.put(entry.getKey(), null);
                    continue;
                }
                otherColumns.put(entry.getKey(), entry.getValue());
            }
        }
        Iterator iterator = otherColumns.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            if (entry.getValue() != null) continue;
            iterator.remove();
        }
        counts.putAll(otherColumns);
        Record record = new Record(key, counts);
        return record;
    }

    public boolean isResultEmpty(Object result) {
        if (result != null) {
            if (result instanceof List) {
                List list = (List)result;
                return list.size() == 0;
            }
            if (result instanceof Map) {
                Map map = (Map)result;
                return map.size() == 0;
            }
            return true;
        }
        return true;
    }

    private static double getNewRunningCount(double runningCount, double current, double entries, AggregationType aggregationType) {
        double newRunningCount = runningCount;
        if (aggregationType.equals((Object)AggregationType.MIN)) {
            if (runningCount > current) {
                newRunningCount = current;
            }
        } else if (aggregationType.equals((Object)AggregationType.MAX)) {
            if (runningCount < current) {
                newRunningCount = current;
            }
        } else if (aggregationType.equals((Object)AggregationType.CUMULATIVE)) {
            newRunningCount = current;
        } else if (aggregationType.equals((Object)AggregationType.SUM)) {
            newRunningCount = runningCount + current;
        } else if (aggregationType.equals((Object)AggregationType.AVG)) {
            double total = runningCount * (entries - 1.0) + current;
            newRunningCount = total / entries;
        }
        return newRunningCount;
    }
}

