/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bam.analyzer.analyzers;

import java.util.List;
import java.util.Map;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.bam.analyzer.analyzers.AbstractAnalyzer;
import org.wso2.carbon.bam.analyzer.analyzers.AnalyzerConfig;
import org.wso2.carbon.bam.analyzer.analyzers.configs.AlertConfig;
import org.wso2.carbon.bam.analyzer.engine.DataContext;
import org.wso2.carbon.bam.analyzer.util.EmailGateway;
import org.wso2.carbon.bam.core.dataobjects.Record;

public class AlertTrigger
extends AbstractAnalyzer {
    private static final Log log = LogFactory.getLog(AlertTrigger.class);
    public static final String FAULT_MESSAGE_SEPARATOR = "";
    private AlertConfig alertConfig;
    private StringBuffer buffer;

    public AlertTrigger(AnalyzerConfig analyzerConfig) {
        super(analyzerConfig);
    }

    @Override
    public void analyze(DataContext dataContext) {
        this.alertConfig = (AlertConfig)this.getAnalyzerConfig();
        String[] fields = this.alertConfig.getFields();
        this.buffer = new StringBuffer();
        Object result = this.getData(dataContext);
        if (result != null && result instanceof List) {
            List records = (List)result;
            for (Record record : records) {
                Map columns = record.getColumns();
                this.buffer.append(FAULT_MESSAGE_SEPARATOR);
                this.buffer.append("\n \n <table border=\"1\">");
                for (Map.Entry entry : columns.entrySet()) {
                    String columnKey = (String)entry.getKey();
                    for (String field : fields) {
                        if (!columnKey.equals(field.trim())) continue;
                        this.buffer.append("<tr>");
                        this.buffer.append("<td>").append(columnKey).append("</td>");
                        this.buffer.append("<td>").append((String)entry.getValue()).append("</td>");
                        this.buffer.append("</tr>");
                    }
                }
                this.buffer.append("</table> \n \n ");
            }
        }
        if (this.buffer.length() > 0) {
            this.sendEmailMessage(this.buffer.toString(), this.alertConfig);
        }
    }

    private void sendEmailMessage(String messageBody, AlertConfig alertConfig) {
        InternetAddress addressFrom = null;
        Transport trns = null;
        Session mailSession = null;
        MimeMessage msg = null;
        EmailGateway emailGateway = EmailGateway.getInstance();
        try {
            String fromAddress = alertConfig.getFromAddress();
            String mailHost = alertConfig.getMailHost();
            String userName = alertConfig.getUserName();
            String password = alertConfig.getPassword();
            String mailTransport = alertConfig.getTransport();
            addressFrom = new InternetAddress(fromAddress);
            InternetAddress[] toEmailAddrs = new InternetAddress[1];
            String toAddress = alertConfig.getToEmailAddr();
            toEmailAddrs[0] = new InternetAddress(toAddress);
            String subject = alertConfig.getSubject();
            mailSession = emailGateway.getMailSession();
            msg = new MimeMessage(mailSession);
            trns = mailSession.getTransport(mailTransport);
            trns.connect(mailHost, userName, password);
            msg.setFrom((Address)addressFrom);
            msg.setSubject(subject);
            msg.setContent((Object)messageBody, "text/html");
            trns.sendMessage((Message)msg, (Address[])toEmailAddrs);
        }
        catch (AddressException e) {
            log.error((Object)"Invalid email Address", (Throwable)e);
        }
        catch (MessagingException e) {
            log.error((Object)"Messaging exception", (Throwable)e);
        }
    }
}

