/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bam.analyzer.analyzers;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.bam.analyzer.analyzers.AbstractAnalyzer;
import org.wso2.carbon.bam.analyzer.analyzers.AnalyzerConfig;
import org.wso2.carbon.bam.analyzer.analyzers.AnalyzerUtils;
import org.wso2.carbon.bam.analyzer.analyzers.configs.AggregateConfig;
import org.wso2.carbon.bam.analyzer.engine.DataContext;
import org.wso2.carbon.bam.core.dataobjects.Record;

public class AggregateAnalyzer
extends AbstractAnalyzer {
    private static final Log log = LogFactory.getLog(AggregateAnalyzer.class);

    public AggregateAnalyzer(AnalyzerConfig analyzerConfig) {
        super(analyzerConfig);
    }

    @Override
    public void analyze(DataContext dataContext) {
        Object result = this.getData(dataContext);
        ArrayList<Record> results = new ArrayList<Record>();
        if (result != null) {
            if (result instanceof List) {
                List records = (List)result;
                String uuid = UUID.randomUUID().toString();
                Record record = AnalyzerUtils.aggregateRecords(records, ((AggregateConfig)this.getAnalyzerConfig()).getMeasures(), uuid);
                results.add(record);
            } else if (result instanceof Map) {
                Map recordMap = (Map)result;
                for (Map.Entry group : recordMap.entrySet()) {
                    List rows = (List)group.getValue();
                    Record record = AnalyzerUtils.aggregateRecords(rows, ((AggregateConfig)this.getAnalyzerConfig()).getMeasures(), (String)group.getKey());
                    results.add(record);
                }
            } else {
                log.error((Object)"Unknown data format in received data for extract analyzer..");
            }
        } else {
            log.warn((Object)("Data flow empty at extract analyzer in sequence : " + this.getAnalyzerSequenceName()));
        }
        this.setData(dataContext, results);
    }
}

