/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bam.analyzer;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.bam.analyzer.analyzers.AnalyzerBuilder;
import org.wso2.carbon.bam.analyzer.analyzers.builders.AggregateAnalyzerBuilder;
import org.wso2.carbon.bam.analyzer.analyzers.builders.AlertBuilder;
import org.wso2.carbon.bam.analyzer.analyzers.builders.ClassAnalyzerBuilder;
import org.wso2.carbon.bam.analyzer.analyzers.builders.CorrelateAnalyzerBuilder;
import org.wso2.carbon.bam.analyzer.analyzers.builders.DetectFaultAnalyzerBuilder;
import org.wso2.carbon.bam.analyzer.analyzers.builders.DropAnalyzerBuilder;
import org.wso2.carbon.bam.analyzer.analyzers.builders.ExtractAnalyzerBuilder;
import org.wso2.carbon.bam.analyzer.analyzers.builders.GetAnalyzerBuilder;
import org.wso2.carbon.bam.analyzer.analyzers.builders.GroupByAnalyzerBuilder;
import org.wso2.carbon.bam.analyzer.analyzers.builders.IndexingAnalyzerBuilder;
import org.wso2.carbon.bam.analyzer.analyzers.builders.JMXAnalyzerBuilder;
import org.wso2.carbon.bam.analyzer.analyzers.builders.LogAnalyzerBuilder;
import org.wso2.carbon.bam.analyzer.analyzers.builders.LookupAnalyzerBuilder;
import org.wso2.carbon.bam.analyzer.analyzers.builders.OrderByAnalyzerBuilder;
import org.wso2.carbon.bam.analyzer.analyzers.builders.PutAnalyzerBuilder;
import org.wso2.carbon.bam.analyzer.engine.Analyzer;
import org.wso2.carbon.bam.analyzer.engine.AnalyzerConfigConstants;
import org.wso2.carbon.bam.analyzer.engine.AnalyzerEngine;
import org.wso2.carbon.bam.analyzer.engine.AnalyzerException;
import org.wso2.carbon.bam.analyzer.engine.AnalyzerSequence;
import org.wso2.carbon.bam.analyzer.task.BAMTaskInfo;
import org.wso2.carbon.bam.core.configurations.DataSourceType;
import org.wso2.carbon.bam.core.configurations.Granularity;
import org.wso2.carbon.bam.core.configurations.IndexConfiguration;
import org.wso2.carbon.bam.core.configurations.IndexType;
import org.wso2.carbon.bam.core.persistence.cassandra.CassandraIndexConfiguration;
import org.wso2.carbon.cassandra.dataaccess.DataAccessService;
import org.wso2.carbon.ntask.core.TaskInfo;
import org.wso2.carbon.ntask.core.service.TaskService;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.registry.core.service.TenantRegistryLoader;
import org.wso2.carbon.utils.ConfigurationContextService;

public class Utils {
    private static final Log log = LogFactory.getLog(Utils.class);
    private static DataAccessService dataAccessService;
    private static RegistryService registryService;
    private static AnalyzerEngine engine;
    private static TenantRegistryLoader tenantRegistryLoader;
    private static TaskService taskService;
    private static OMFactory factory;
    private static String NULL_NAMESPACE;
    private static OMNamespace NULL_OMNS;
    private static Map<String, AnalyzerBuilder> builderMap;
    private static ConfigurationContextService configurationContextService;

    public static AnalyzerEngine getEngine() {
        return engine;
    }

    public static void setEngine(AnalyzerEngine engine) {
        Utils.engine = engine;
    }

    public static DataAccessService getDataAccessService() {
        return dataAccessService;
    }

    public static TaskService getTaskService() {
        return taskService;
    }

    public static void setDataAccessService(DataAccessService dataAccessService) {
        Utils.dataAccessService = dataAccessService;
    }

    public static RegistryService getRegistryService() {
        return registryService;
    }

    public static void setRegistryService(RegistryService registryService) {
        Utils.registryService = registryService;
    }

    public static AnalyzerSequence getAnalyzerSequence(int tenantId, OMElement analyzerSeqEl) throws AnalyzerException {
        OMAttribute cronEl;
        OMAttribute intervalEl;
        OMAttribute seqName = analyzerSeqEl.getAttribute(AnalyzerConfigConstants.name);
        if (seqName == null) {
            String message = "Analyzer Sequence name cannot be null";
            AnalyzerException analyzerException = new AnalyzerException(message);
            log.error((Object)message, (Throwable)analyzerException);
            throw analyzerException;
        }
        OMElement triggerEl = analyzerSeqEl.getFirstChildWithName(AnalyzerConfigConstants.TRIGGER_ELEMENT);
        AnalyzerSequence sequence = new AnalyzerSequence();
        sequence.setTenantId(tenantId);
        OMAttribute countEl = triggerEl.getAttribute(AnalyzerConfigConstants.COUNT_ATTRIBUTE);
        if (countEl != null) {
            sequence.setCount(Integer.parseInt(countEl.getAttributeValue()));
        }
        if ((intervalEl = triggerEl.getAttribute(AnalyzerConfigConstants.INTERVAL_ATTRIBUTE)) != null) {
            sequence.setInterval(Integer.parseInt(intervalEl.getAttributeValue()));
        }
        if ((cronEl = triggerEl.getAttribute(AnalyzerConfigConstants.CRON_ATTRIBUTE)) != null) {
            sequence.setCron(cronEl.getAttributeValue());
        }
        sequence.setName(seqName.getAttributeValue());
        OMElement analyzersEl = analyzerSeqEl.getFirstChildWithName(AnalyzerConfigConstants.ANALYZERS_ELEMENT);
        Iterator analyzersIterator = analyzersEl.getChildElements();
        while (analyzersIterator.hasNext()) {
            Object analyzerElementObject = analyzersIterator.next();
            if (!(analyzerElementObject instanceof OMElement)) continue;
            OMElement analyzerEl = (OMElement)analyzerElementObject;
            Analyzer analyzerObject = Utils.getAnalyzerObject(analyzerEl);
            analyzerObject.setAnalyzerSeqeunceName(sequence.getName());
            analyzerObject.setAnalyzerSequence(sequence);
            sequence.getAnalyzers().add(analyzerObject);
        }
        return sequence;
    }

    public static Map<String, AnalyzerBuilder> getAnalyzerBuilderMap() {
        if (builderMap == null) {
            HashMap<String, AnalyzerBuilder> builderMap = new HashMap<String, AnalyzerBuilder>();
            builderMap.put("get", new GetAnalyzerBuilder());
            builderMap.put("aggregate", new AggregateAnalyzerBuilder());
            builderMap.put("lookup", new LookupAnalyzerBuilder());
            builderMap.put("put", new PutAnalyzerBuilder());
            builderMap.put("log", new LogAnalyzerBuilder());
            builderMap.put("drop", new DropAnalyzerBuilder());
            builderMap.put("correlate", new CorrelateAnalyzerBuilder());
            builderMap.put("index", new IndexingAnalyzerBuilder());
            builderMap.put("groupBy", new GroupByAnalyzerBuilder());
            builderMap.put("orderBy", new OrderByAnalyzerBuilder());
            builderMap.put("extract", new ExtractAnalyzerBuilder());
            builderMap.put("detectFault", new DetectFaultAnalyzerBuilder());
            builderMap.put("jmx", new JMXAnalyzerBuilder());
            builderMap.put("alert", new AlertBuilder());
            builderMap.put("class", new ClassAnalyzerBuilder());
            Utils.builderMap = builderMap;
        }
        return builderMap;
    }

    public static Analyzer getAnalyzerObject(OMElement analyzerEl) throws AnalyzerException {
        String name = analyzerEl.getLocalName();
        if (!Utils.getAnalyzerBuilderMap().containsKey(name)) {
            throw new AnalyzerException("Analyzer with name " + name + " not present..");
        }
        Analyzer analyzer = Utils.getAnalyzerBuilderMap().get(name).buildAnalyzer(analyzerEl);
        return analyzer;
    }

    public static ConfigurationContextService getConfigurationContextService() {
        return configurationContextService;
    }

    public static void setConfigurationContextService(ConfigurationContextService configurationContextService) {
        Utils.configurationContextService = configurationContextService;
    }

    public static void setTaskService(TaskService taskService) {
        Utils.taskService = taskService;
    }

    public static TenantRegistryLoader getTenantRegistryLoader() {
        return tenantRegistryLoader;
    }

    public static void setTenantRegistryLoader(TenantRegistryLoader tenantRegistryLoader) {
        Utils.tenantRegistryLoader = tenantRegistryLoader;
    }

    public static OMElement serializeIndexAnalyser(IndexConfiguration indexConfig) {
        OMElement rootEl = factory.createOMElement(new QName("index"));
        rootEl.addAttribute("name", indexConfig.getIndexName(), NULL_OMNS);
        rootEl.addAttribute("isAutoGenerated", Boolean.toString(indexConfig.isAutoGenerated()), NULL_OMNS);
        rootEl.addAttribute("isManuallyIndexed", Boolean.toString(indexConfig.isManuallyIndexed()), NULL_OMNS);
        if (indexConfig.getDataSourceType() != null) {
            OMElement dsTypeEl = factory.createOMElement(new QName("dataSourceType"));
            DataSourceType dsType = indexConfig.getDataSourceType();
            if (dsType.getName() != null) {
                dsTypeEl.addAttribute("name", dsType.getName(), NULL_OMNS);
                dsTypeEl.addAttribute("manuallyIndexed", Boolean.toString(dsType.isManuallyIndexed()), NULL_OMNS);
            }
            rootEl.addChild((OMNode)dsTypeEl);
        }
        if (indexConfig.getIndexedTable() != null) {
            OMElement idxTableEl = factory.createOMElement(new QName("indexTable"));
            idxTableEl.setText(indexConfig.getIndexedTable());
            rootEl.addChild((OMNode)idxTableEl);
        }
        if (indexConfig.getIndexedColumns() != null) {
            OMElement idxColumnsEl = factory.createOMElement(new QName("indexColumns"));
            for (String idxColumn : indexConfig.getIndexedColumns()) {
                if (idxColumn == null) continue;
                OMElement idxColumnEl = factory.createOMElement(new QName("indexColumn"));
                idxColumnEl.setText(idxColumn);
                idxColumnsEl.addChild((OMNode)idxColumnEl);
            }
            rootEl.addChild((OMNode)idxColumnsEl);
        }
        if (indexConfig.getIndexType() != null) {
            IndexType idxType = indexConfig.getIndexType();
            OMElement idxTypeEl = factory.createOMElement(new QName("indexType"));
            if (idxType.getName() != null) {
                idxTypeEl.addAttribute("name", idxType.getName(), NULL_OMNS);
            }
            rootEl.addChild((OMNode)idxTypeEl);
        }
        if (indexConfig.getGranularity() != null) {
            Granularity granularity = indexConfig.getGranularity();
            OMElement granularityEl = factory.createOMElement(new QName("granularity"));
            if (granularity.getName() != null) {
                granularityEl.addAttribute("name", granularity.getName(), NULL_OMNS);
            }
            rootEl.addChild((OMNode)granularityEl);
        }
        if (indexConfig instanceof CassandraIndexConfiguration) {
            CassandraIndexConfiguration cassandraIdxConfig = (CassandraIndexConfiguration)indexConfig;
            OMElement indexingCfEl = factory.createOMElement(new QName("indexingColumnFamily"));
            if (cassandraIdxConfig.getIndexingColumnFamily() != null) {
                indexingCfEl.setText(cassandraIdxConfig.getIndexingColumnFamily());
            }
            rootEl.addChild((OMNode)indexingCfEl);
            OMElement cronEl = factory.createOMElement(new QName("cron"));
            if (cassandraIdxConfig.getCron() != null) {
                cronEl.setText(cassandraIdxConfig.getCron());
            }
            rootEl.addChild((OMNode)cronEl);
        }
        return rootEl;
    }

    public static TaskInfo getTaskInfo(BAMTaskInfo taskInfo) throws IOException, AnalyzerException {
        AnalyzerSequence sequence = taskInfo.getAnalyzerSequence();
        TaskInfo.TriggerInfo triggerInfo = new TaskInfo.TriggerInfo();
        triggerInfo.setRepeatCount(sequence.getCount());
        triggerInfo.setIntervalMillis(sequence.getInterval());
        triggerInfo.setCronExpression(sequence.getCron());
        TaskInfo info = new TaskInfo();
        info.setName(sequence.getName());
        info.setTriggerInfo(triggerInfo);
        info.setTaskClass(AnalyzerConfigConstants.BAM_DEFAULT_TASK_CLASS);
        info.setProperties(Utils.getProperties(taskInfo));
        return info;
    }

    public static Map<String, String> getProperties(BAMTaskInfo taskInfo) throws IOException, AnalyzerException {
        AnalyzerSequence sequence = taskInfo.getAnalyzerSequence();
        OMElement analyzerSeqXML = taskInfo.getAnalyzerSeqXML();
        Map<String, String> credentials = taskInfo.getCredentials();
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put(AnalyzerConfigConstants.ANALYZER_SEQUENCE_NAME, sequence.getName());
        properties.put("analyzerSequence", analyzerSeqXML.toString());
        properties.put("username", credentials.get("username"));
        properties.put("password", credentials.get("password"));
        properties.put(AnalyzerConfigConstants.TENANT_ID, String.valueOf(sequence.getTenantId()));
        return properties;
    }

    static {
        factory = OMAbstractFactory.getOMFactory();
        NULL_NAMESPACE = "";
        NULL_OMNS = factory.createOMNamespace(NULL_NAMESPACE, "");
        builderMap = null;
    }
}

