/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bam.receiver.internal;

import java.util.concurrent.BlockingQueue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.bam.core.dataobjects.EventData;
import org.wso2.carbon.bam.core.persistence.PersistenceManager;

public class QueueWorker
implements Runnable {
    private static final Log log = LogFactory.getLog(QueueWorker.class);
    private BlockingQueue<EventData> eventQueue;

    public QueueWorker(BlockingQueue<EventData> queue) {
        this.eventQueue = queue;
    }

    @Override
    public void run() {
        try {
            EventData event;
            if (log.isDebugEnabled()) {
                log.debug((Object)(this.eventQueue.size() + " messages in queue before " + Thread.currentThread().getName() + " worker has polled queue"));
            }
            if ((event = (EventData)this.eventQueue.poll()) == null) {
                log.warn((Object)"Message deque failed: Event is null");
                return;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Message dequeued : " + event.toString()));
            }
            PersistenceManager manager = new PersistenceManager();
            manager.storeEvent(event.getCredentials(), event);
            if (log.isDebugEnabled()) {
                log.info((Object)(this.eventQueue.size() + " messages in queue after " + Thread.currentThread().getName() + " worker has finished work"));
            }
        }
        catch (Throwable e) {
            log.error((Object)"Error in processing message and storing", e);
        }
    }
}

