/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bam.receiver.internal;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.bam.core.dataobjects.EventData;
import org.wso2.carbon.bam.receiver.event.RawEvent;
import org.wso2.carbon.bam.receiver.internal.QueueWorker;

public class EventQueue {
    private static final Log log = LogFactory.getLog(EventQueue.class);
    private BlockingQueue<RawEvent> queue;
    private BlockingQueue<EventData> eventQueue;
    private ExecutorService executorService = Executors.newFixedThreadPool(100);

    public EventQueue() {
        this.queue = new ArrayBlockingQueue<RawEvent>(10000);
        this.eventQueue = new ArrayBlockingQueue<EventData>(10000);
    }

    public void queue(EventData event) {
        boolean success = this.eventQueue.offer(event);
        if (success) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Message enqueued : " + event.toString()));
            }
            this.executorService.submit(new QueueWorker(this.eventQueue));
        } else {
            String logMessage = "Failure to insert event into queue";
            if (log.isDebugEnabled()) {
                logMessage = logMessage + "\n Event Content : " + event.toString();
            }
            log.warn((Object)logMessage);
        }
    }

    protected void finalize() throws Throwable {
        this.executorService.shutdown();
        super.finalize();
    }
}

