/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bam.receiver.event;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.soap.SOAPBody;
import org.apache.commons.collections.map.UnmodifiableMap;
import org.wso2.carbon.bam.receiver.event.RawEvent;

public class EventProcessor {
    private RawEvent rawEvent;

    public EventProcessor(RawEvent rawEvent) {
        this.rawEvent = rawEvent;
    }

    public Map<String, String> processEvent() {
        HashMap<String, String> processedMap = new HashMap<String, String>();
        SOAPBody soapBody = this.rawEvent.getSOAPBody();
        Iterator eventChildren = soapBody.getFirstElement().getChildren();
        while (eventChildren.hasNext()) {
            Object object = eventChildren.next();
            if (!(object instanceof OMElement)) continue;
            OMElement elem = (OMElement)object;
            processedMap.put(elem.getLocalName(), elem.getText());
        }
        Map<String, String> mandatoryDataMap = this.rawEvent.getMandatoryDataMap();
        this.insertMandatoryFields(processedMap, mandatoryDataMap);
        return UnmodifiableMap.decorate(processedMap);
    }

    private void insertMandatoryFields(Map<String, String> processedMap, Map<String, String> mandatoryDataMap) {
        if (mandatoryDataMap == null) {
            return;
        }
        for (Map.Entry<String, String> mandatoryEntry : mandatoryDataMap.entrySet()) {
            if (processedMap.containsKey(mandatoryEntry.getKey())) continue;
            processedMap.put(mandatoryEntry.getKey(), mandatoryEntry.getValue());
        }
    }
}

