/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bam.ui.client;

import java.rmi.RemoteException;
import java.util.Locale;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.bam.stub.listadmin.BAMListAdminServiceBAMException;
import org.wso2.carbon.bam.stub.listadmin.BAMListAdminServiceStub;
import org.wso2.carbon.bam.stub.listadmin.types.carbon.ActivityDTO;
import org.wso2.carbon.bam.stub.listadmin.types.carbon.ClientDTO;
import org.wso2.carbon.bam.stub.listadmin.types.carbon.MonitoredServerDTO;
import org.wso2.carbon.bam.stub.listadmin.types.carbon.NamespaceDTO;
import org.wso2.carbon.bam.stub.listadmin.types.carbon.OperationDO;
import org.wso2.carbon.bam.stub.listadmin.types.carbon.PropertyFilterDTO;
import org.wso2.carbon.bam.stub.listadmin.types.carbon.ServiceDO;
import org.wso2.carbon.bam.util.BAMException;

public class BAMListAdminServiceClient {
    private static final Log log = LogFactory.getLog(BAMListAdminServiceClient.class);
    BAMListAdminServiceStub bamListAdminServiceStub;

    public BAMListAdminServiceClient(String cookie, String backendServerURL, ConfigurationContext configCtx, Locale locale) throws AxisFault {
        String serviceURL = backendServerURL + "BAMListAdminService";
        this.bamListAdminServiceStub = new BAMListAdminServiceStub(configCtx, serviceURL);
        ServiceClient client = this.bamListAdminServiceStub._getServiceClient();
        Options option = client.getOptions();
        option.setManageSession(true);
        option.setProperty("Cookie", (Object)cookie);
    }

    public MonitoredServerDTO[] getServerList() throws BAMException {
        try {
            return this.bamListAdminServiceStub.getServerList();
        }
        catch (RemoteException e) {
            throw new BAMException("failed to get monitored server list", (Throwable)e);
        }
        catch (BAMListAdminServiceBAMException e) {
            throw new BAMException("failed to get monitored server list", (Throwable)e);
        }
    }

    public ServiceDO[] getServicesList(int serverId) throws BAMException {
        try {
            return this.bamListAdminServiceStub.getServiceList(serverId);
        }
        catch (RemoteException e) {
            throw new BAMException("failed to get services list for serverId : " + serverId, (Throwable)e);
        }
        catch (BAMListAdminServiceBAMException e) {
            throw new BAMException("failed to get services list for serverId : " + serverId, (Throwable)e);
        }
    }

    public OperationDO[] getOperationList(int serviceId) throws BAMException {
        try {
            return this.bamListAdminServiceStub.getOperationList(serviceId);
        }
        catch (RemoteException e) {
            throw new BAMException(" failed to get operations for serviceId : " + serviceId, (Throwable)e);
        }
        catch (BAMListAdminServiceBAMException e) {
            throw new BAMException(" failed to get operations for serviceId : " + serviceId, (Throwable)e);
        }
    }

    public ActivityDTO[] getActivityList() throws BAMException {
        try {
            return this.bamListAdminServiceStub.getActivityList();
        }
        catch (RemoteException e) {
            throw new BAMException("failed to get activities", (Throwable)e);
        }
        catch (BAMListAdminServiceBAMException e) {
            throw new BAMException("failed to get activities", (Throwable)e);
        }
    }

    public ClientDTO[] getClientList(int serverID) throws BAMException {
        try {
            return this.bamListAdminServiceStub.getClientList(serverID);
        }
        catch (RemoteException e) {
            throw new BAMException("failed to get client list for serverId : " + serverID, (Throwable)e);
        }
        catch (BAMListAdminServiceBAMException e) {
            throw new BAMException("failed to get client list for serverId : " + serverID, (Throwable)e);
        }
    }

    public PropertyFilterDTO[] getXpathConfigurations(int serverId) throws BAMException {
        try {
            return this.bamListAdminServiceStub.getXpathConfigurations(serverId);
        }
        catch (RemoteException e) {
            throw new BAMException("Error occurred getting xpath configurations for server id " + serverId, (Throwable)e);
        }
        catch (BAMListAdminServiceBAMException e) {
            throw new BAMException("Error occurred getting xpath configurations for server id " + serverId, (Throwable)e);
        }
    }

    public NamespaceDTO[] getNamespaces(int xpathId) throws BAMException {
        try {
            return this.bamListAdminServiceStub.getNamespaces(xpathId);
        }
        catch (RemoteException e) {
            throw new BAMException("Error occurred getting namespaces for xpath id " + xpathId, (Throwable)e);
        }
        catch (BAMListAdminServiceBAMException e) {
            throw new BAMException("Error occurred getting namespaces for xpath id " + xpathId, (Throwable)e);
        }
    }

    public void cleanup() {
        block2: {
            try {
                this.bamListAdminServiceStub._getServiceClient().cleanupTransport();
                this.bamListAdminServiceStub._getServiceClient().cleanup();
                this.bamListAdminServiceStub.cleanup();
            }
            catch (AxisFault axisFault) {
                if (!log.isErrorEnabled()) break block2;
                log.error((Object)("Stub cleanup failed: " + this.getClass().getName()), (Throwable)axisFault);
            }
        }
    }
}

