/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bam.ui.client;

import java.rmi.RemoteException;
import java.util.Locale;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.bam.stub.statquery.BAMStatQueryDSStub;
import org.wso2.carbon.bam.stub.statquery.Count;
import org.wso2.carbon.bam.stub.statquery.Data;
import org.wso2.carbon.bam.stub.statquery.Endpoint;
import org.wso2.carbon.bam.stub.statquery.Operation;
import org.wso2.carbon.bam.stub.statquery.ProxyService;
import org.wso2.carbon.bam.stub.statquery.Sequence;

public class BAMStatQueryDSClient {
    private static final Log log = LogFactory.getLog(BAMStatQueryDSClient.class);
    BAMStatQueryDSStub stub;

    public BAMStatQueryDSClient(String cookie, String backendServerURL, ConfigurationContext configCtx, Locale locale) throws AxisFault {
        String serviceURL = backendServerURL + "BAMStatQueryDS";
        this.stub = new BAMStatQueryDSStub(configCtx, serviceURL);
        ServiceClient client = this.stub._getServiceClient();
        Options option = client.getOptions();
        option.setManageSession(true);
        option.setProperty("Cookie", (Object)cookie);
    }

    public Count[] getLastMinuteRequestCount(int serviceID) throws RemoteException {
        return this.stub.getLastMinuteRequestCount(serviceID);
    }

    public String getAvgResponseTime(int serviceID) throws RemoteException {
        try {
            return this.stub.getAvgResponseTime(serviceID)[0].getTime();
        }
        catch (Exception e) {
            return "0";
        }
    }

    public String getMinResponseTime(int serviceID) throws RemoteException {
        try {
            return this.stub.getMinResponseTime(serviceID)[0].getTime();
        }
        catch (Exception e) {
            return "0";
        }
    }

    public String getMaxResponseTime(int serviceID) throws RemoteException {
        try {
            return this.stub.getMaxResponseTime(serviceID)[0].getTime();
        }
        catch (Exception e) {
            return "0";
        }
    }

    public String getValueRangePair(String value) {
        int iValue = (int)Double.parseDouble(value);
        int range = (iValue / 10 + 1) * 10;
        return "&value=" + value + "&range=" + range + "&";
    }

    public String getLatestAverageResponseTimeForServer(int serverID) throws RemoteException {
        String value = "0";
        try {
            value = this.stub.getLatestAverageResponseTimeForServer(serverID)[0].getTime();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.getValueRangePair(value);
    }

    public String getLatestMaximumResponseTimeForServer(int serverID) throws RemoteException {
        String value = "0";
        try {
            value = this.stub.getLatestMaximumResponseTimeForServer(serverID)[0].getTime();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.getValueRangePair(value);
    }

    public String getLatestMinimumResponseTimeForServer(int serverID) throws RemoteException {
        String value = "0";
        try {
            value = this.stub.getLatestMinimumResponseTimeForServer(serverID)[0].getTime();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.getValueRangePair(value);
    }

    public String getLatestRequestCountForServer(int serverID) throws RemoteException {
        try {
            return this.stub.getLatestRequestCountForServer(serverID)[0].getCount();
        }
        catch (Exception e) {
            return "0";
        }
    }

    public String getLatestResponseCountForServer(int serverID) throws RemoteException {
        try {
            return this.stub.getLatestResponseCountForServer(serverID)[0].getCount();
        }
        catch (Exception e) {
            return "0";
        }
    }

    public String getLatestFaultCountForServer(int serverID) throws RemoteException {
        try {
            return this.stub.getLatestFaultCountForServer(serverID)[0].getCount();
        }
        catch (Exception e) {
            return "0";
        }
    }

    public Data getLatestDataForServer(int serverID) throws RemoteException {
        try {
            if (this.stub.getLatestDataForServer(serverID) == null) {
                return null;
            }
            return this.stub.getLatestDataForServer(serverID)[0];
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public String getLatestAverageResponseTimeForService(int serviceID) throws RemoteException {
        String value = "0";
        try {
            value = this.stub.getLatestAverageResponseTimeForService(serviceID)[0].getTime();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.getValueRangePair(value);
    }

    public String getLatestMaximumResponseTimeForService(int serviceID) throws RemoteException {
        String value = "0";
        try {
            value = this.stub.getLatestMaximumResponseTimeForService(serviceID)[0].getTime();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.getValueRangePair(value);
    }

    public String getLatestMinimumResponseTimeForService(int serviceID) throws RemoteException {
        String value = "0";
        try {
            value = this.stub.getLatestMinimumResponseTimeForService(serviceID)[0].getTime();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.getValueRangePair(value);
    }

    public String getLatestRequestCountForService(int serviceID) throws RemoteException {
        try {
            return this.stub.getLatestRequestCountForService(serviceID)[0].getCount();
        }
        catch (Exception e) {
            return "0";
        }
    }

    public String getLatestResponseCountForService(int serviceID) throws RemoteException {
        try {
            return this.stub.getLatestResponseCountForService(serviceID)[0].getCount();
        }
        catch (Exception e) {
            return "0";
        }
    }

    public String getLatestFaultCountForService(int serviceID) throws RemoteException {
        try {
            return this.stub.getLatestFaultCountForService(serviceID)[0].getCount();
        }
        catch (Exception e) {
            return "0";
        }
    }

    public Data getLatestDataForService(int serviceID) throws RemoteException {
        try {
            if (this.stub.getLatestDataForService(serviceID) == null) {
                return null;
            }
            return this.stub.getLatestDataForService(serviceID)[0];
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public Operation[] getOperations(int serviceID) throws RemoteException {
        try {
            return this.stub.getOperations(serviceID);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public String getLatestAverageResponseTimeForOperation(int operationID) throws RemoteException {
        try {
            return this.stub.getLatestAverageResponseTimeForOperation(operationID)[0].getTime();
        }
        catch (Exception e) {
            return "0";
        }
    }

    public String getLatestMaximumResponseTimeForOperation(int operationID) throws RemoteException {
        try {
            return this.stub.getLatestMaximumResponseTimeForOperation(operationID)[0].getTime();
        }
        catch (Exception e) {
            return "0";
        }
    }

    public String getLatestMinimumResponseTimeForOperation(int operationID) throws RemoteException {
        try {
            return this.stub.getLatestMinimumResponseTimeForOperation(operationID)[0].getTime();
        }
        catch (Exception e) {
            return "0";
        }
    }

    public String getLatestRequestCountForOperation(int operationID) throws RemoteException {
        try {
            return this.stub.getLatestRequestCountForOperation(operationID)[0].getCount();
        }
        catch (Exception e) {
            return "0";
        }
    }

    public String getLatestResponseCountForOperation(int operationID) throws RemoteException {
        try {
            return this.stub.getLatestResponseCountForOperation(operationID)[0].getCount();
        }
        catch (Exception e) {
            return "0";
        }
    }

    public String getLatestFaultCountForOperation(int operationID) throws RemoteException {
        try {
            return this.stub.getLatestFaultCountForOperation(operationID)[0].getCount();
        }
        catch (Exception e) {
            return "0";
        }
    }

    public Data getLatestDataForOperation(int operationID) throws RemoteException {
        try {
            if (this.stub.getLatestDataForOperation(operationID) == null) {
                return null;
            }
            return this.stub.getLatestDataForOperation(operationID)[0];
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public Endpoint[] getEndpoints(int serverID) throws RemoteException {
        try {
            return this.stub.getEndpoints(serverID);
        }
        catch (Exception ignore) {
            ignore.printStackTrace();
            return null;
        }
    }

    public String getLatestInAverageProcessingTimeForEndpoint(int serverID, String endpointName) throws RemoteException {
        try {
            return this.stub.getLatestInAverageProcessingTimeForEndpoint(serverID, this.createMediationKeyString("Endpoint", "In", "AvgProcessingTime", endpointName))[0].getAverageTime();
        }
        catch (Exception ignore) {
            return "0";
        }
    }

    public String getLatestInMaximumProcessingTimeForEndpoint(int serverID, String endpointName) throws RemoteException {
        try {
            return this.stub.getLatestInMaximumProcessingTimeForEndpoint(serverID, this.createMediationKeyString("Endpoint", "In", "MaxProcessingTime", endpointName))[0].getMaximumTime();
        }
        catch (Exception ignore) {
            return "0";
        }
    }

    public String getLatestInMinimumProcessingTimeForEndpoint(int serverID, String endpointName) throws RemoteException {
        try {
            return this.stub.getLatestInMinimumProcessingTimeForEndpoint(serverID, this.createMediationKeyString("Endpoint", "In", "MinProcessingTime", endpointName))[0].getMinimumTime();
        }
        catch (Exception ignore) {
            return "0";
        }
    }

    public String getLatestInCumulativeCountForEndpoint(int serverID, String endpointName) throws RemoteException {
        try {
            return this.stub.getLatestInCumulativeCountForEndpoint(serverID, this.createMediationKeyString("Endpoint", "In", "CumulativeCount", endpointName))[0].getCumulativeCount();
        }
        catch (Exception e) {
            return "0";
        }
    }

    public String getLatestInFaultCountForEndpoint(int serverID, String endpointName) throws RemoteException {
        try {
            return this.stub.getLatestInFaultCountForEndpoint(serverID, this.createMediationKeyString("Endpoint", "In", "FaultCount", endpointName))[0].getFaultCount();
        }
        catch (Exception e) {
            return "0";
        }
    }

    public Sequence[] getSequences(int serverID) throws RemoteException {
        try {
            return this.stub.getSequences(serverID);
        }
        catch (Exception ignore) {
            ignore.printStackTrace();
            return null;
        }
    }

    public String getLatestInAverageProcessingTimeForSequence(int serverID, String sequenceName) throws RemoteException {
        try {
            return this.stub.getLatestInAverageProcessingTimeForSequence(serverID, this.createMediationKeyString("Sequence", "In", "AvgProcessingTime", sequenceName))[0].getAverageTime();
        }
        catch (Exception e) {
            return "0";
        }
    }

    public String getLatestOutAverageProcessingTimeForSequence(int serverID, String sequenceName) throws RemoteException {
        try {
            return this.stub.getLatestInAverageProcessingTimeForSequence(serverID, this.createMediationKeyString("Sequence", "Out", "AvgProcessingTime", sequenceName))[0].getAverageTime();
        }
        catch (Exception e) {
            return "0";
        }
    }

    public String getLatestInMaximumProcessingTimeForSequence(int serverID, String sequenceName) throws RemoteException {
        try {
            return this.stub.getLatestInMaximumProcessingTimeForSequence(serverID, this.createMediationKeyString("Sequence", "In", "MaxProcessingTime", sequenceName))[0].getMaximumTime();
        }
        catch (Exception e) {
            return "0";
        }
    }

    public String getLatestOutMaximumProcessingTimeForSequence(int serverID, String sequenceName) throws RemoteException {
        try {
            return this.stub.getLatestInMaximumProcessingTimeForSequence(serverID, this.createMediationKeyString("Sequence", "Out", "MaxProcessingTime", sequenceName))[0].getMaximumTime();
        }
        catch (Exception e) {
            return "0";
        }
    }

    public String getLatestInMinimumProcessingTimeForSequence(int serverID, String sequenceName) throws RemoteException {
        try {
            return this.stub.getLatestInMinimumProcessingTimeForSequence(serverID, this.createMediationKeyString("Sequence", "In", "MinProcessingTime", sequenceName))[0].getMinimumTime();
        }
        catch (Exception e) {
            return "0";
        }
    }

    public String getLatestOutMinimumProcessingTimeForSequence(int serverID, String sequenceName) throws RemoteException {
        try {
            return this.stub.getLatestInMinimumProcessingTimeForSequence(serverID, this.createMediationKeyString("Sequence", "Out", "MinProcessingTime", sequenceName))[0].getMinimumTime();
        }
        catch (Exception e) {
            return "0";
        }
    }

    public String getLatestInCumulativeCountForSequence(int serverID, String sequenceName) throws RemoteException {
        try {
            return this.stub.getLatestInCumulativeCountForSequence(serverID, this.createMediationKeyString("Sequence", "In", "CumulativeCount", sequenceName))[0].getCumulativeCount();
        }
        catch (Exception e) {
            return "0";
        }
    }

    public String getLatestOutCumulativeCountForSequence(int serverID, String sequenceName) throws RemoteException {
        try {
            return this.stub.getLatestInCumulativeCountForSequence(serverID, this.createMediationKeyString("Sequence", "Out", "CumulativeCount", sequenceName))[0].getCumulativeCount();
        }
        catch (Exception e) {
            return "0";
        }
    }

    public String getLatestInFaultCountForSequence(int serverID, String sequenceName) throws RemoteException {
        try {
            return this.stub.getLatestInFaultCountForSequence(serverID, this.createMediationKeyString("Sequence", "In", "FaultCount", sequenceName))[0].getFaultCount();
        }
        catch (Exception e) {
            return "0";
        }
    }

    public String getLatestOutFaultCountForSequence(int serverID, String sequenceName) throws RemoteException {
        try {
            return this.stub.getLatestInFaultCountForSequence(serverID, this.createMediationKeyString("Sequence", "Out", "FaultCount", sequenceName))[0].getFaultCount();
        }
        catch (Exception e) {
            return "0";
        }
    }

    public ProxyService[] getProxyServices(int serverID) throws RemoteException {
        try {
            return this.stub.getProxyServices(serverID);
        }
        catch (Exception ignore) {
            ignore.printStackTrace();
            return null;
        }
    }

    public String getLatestInAverageProcessingTimeForProxy(int serverID, String proxyName) throws RemoteException {
        try {
            return this.stub.getLatestInAverageProcessingTimeForProxy(serverID, this.createMediationKeyString("Proxy", "In", "AvgProcessingTime", proxyName))[0].getAverageTime();
        }
        catch (Exception e) {
            return "0";
        }
    }

    public String getLatestOutAverageProcessingTimeForProxy(int serverID, String proxyName) throws RemoteException {
        try {
            return this.stub.getLatestInAverageProcessingTimeForProxy(serverID, this.createMediationKeyString("Proxy", "Out", "AvgProcessingTime", proxyName))[0].getAverageTime();
        }
        catch (Exception e) {
            return "0";
        }
    }

    public String getLatestInMaximumProcessingTimeForProxy(int serverID, String proxyName) throws RemoteException {
        try {
            return this.stub.getLatestInMaximumProcessingTimeForProxy(serverID, this.createMediationKeyString("Proxy", "In", "MaxProcessingTime", proxyName))[0].getMaximumTime();
        }
        catch (Exception e) {
            return "0";
        }
    }

    public String getLatestOutMaximumProcessingTimeForProxy(int serverID, String proxyName) throws RemoteException {
        try {
            return this.stub.getLatestInMaximumProcessingTimeForProxy(serverID, this.createMediationKeyString("Proxy", "Out", "MaxProcessingTime", proxyName))[0].getMaximumTime();
        }
        catch (Exception e) {
            return "0";
        }
    }

    public String getLatestInMinimumProcessingTimeForProxy(int serverID, String proxyName) throws RemoteException {
        try {
            return this.stub.getLatestInMinimumProcessingTimeForProxy(serverID, this.createMediationKeyString("Proxy", "In", "MinProcessingTime", proxyName))[0].getMinimumTime();
        }
        catch (Exception e) {
            return "0";
        }
    }

    public String getLatestOutMinimumProcessingTimeForProxy(int serverID, String proxyName) throws RemoteException {
        try {
            return this.stub.getLatestInMinimumProcessingTimeForProxy(serverID, this.createMediationKeyString("Proxy", "Out", "MinProcessingTime", proxyName))[0].getMinimumTime();
        }
        catch (Exception e) {
            return "0";
        }
    }

    public String getLatestInCumulativeCountForProxy(int serverID, String proxyName) throws RemoteException {
        try {
            return this.stub.getLatestInCumulativeCountForProxy(serverID, this.createMediationKeyString("Proxy", "In", "CumulativeCount", proxyName))[0].getCumulativeCount();
        }
        catch (Exception e) {
            return "0";
        }
    }

    public String getLatestOutCumulativeCountForProxy(int serverID, String proxyName) throws RemoteException {
        try {
            return this.stub.getLatestInCumulativeCountForProxy(serverID, this.createMediationKeyString("Proxy", "Out", "CumulativeCount", proxyName))[0].getCumulativeCount();
        }
        catch (Exception e) {
            return "0";
        }
    }

    public String getLatestInFaultCountForProxy(int serverID, String proxyName) throws RemoteException {
        try {
            return this.stub.getLatestInFaultCountForProxy(serverID, this.createMediationKeyString("Proxy", "In", "FaultCount", proxyName))[0].getFaultCount();
        }
        catch (Exception e) {
            return "0";
        }
    }

    public String getLatestOutFaultCountForProxy(int serverID, String proxyName) throws RemoteException {
        try {
            return this.stub.getLatestInFaultCountForProxy(serverID, this.createMediationKeyString("Proxy", "Out", "FaultCount", proxyName))[0].getFaultCount();
        }
        catch (Exception e) {
            return "0";
        }
    }

    private String createMediationKeyString(String mediationType, String direction, String dataType, String name) {
        return mediationType + direction + dataType + "-" + name;
    }

    public void cleanup() {
        block2: {
            try {
                this.stub._getServiceClient().cleanupTransport();
                this.stub._getServiceClient().cleanup();
                this.stub.cleanup();
            }
            catch (AxisFault axisFault) {
                if (!log.isErrorEnabled()) break block2;
                log.error((Object)("Stub cleanup failed: " + this.getClass().getName()), (Throwable)axisFault);
            }
        }
    }
}

