/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bam.ui.client;

import java.rmi.RemoteException;
import java.util.Calendar;
import java.util.Locale;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.bam.stub.listadmin.types.carbon.MonitoredServerDTO;
import org.wso2.carbon.bam.stub.listadmin.types.carbon.OperationDO;
import org.wso2.carbon.bam.stub.listadmin.types.carbon.ServiceDO;
import org.wso2.carbon.bam.stub.statquery.Endpoint;
import org.wso2.carbon.bam.stub.statquery.ProxyService;
import org.wso2.carbon.bam.stub.statquery.Sequence;
import org.wso2.carbon.bam.stub.summaryquery.BAMSummaryQueryDSStub;
import org.wso2.carbon.bam.stub.summaryquery.MedSummaryStat;
import org.wso2.carbon.bam.stub.summaryquery.SummaryStat;
import org.wso2.carbon.bam.util.BAMCalendar;

public class BAMSummaryQueryDSClient {
    private static final Log log = LogFactory.getLog(BAMSummaryQueryDSClient.class);
    private BAMSummaryQueryDSStub stub;

    public BAMSummaryQueryDSClient(String cookie, String backendServerURL, ConfigurationContext configCtx, Locale locale) throws AxisFault {
        String serviceURL = backendServerURL + "BAMSummaryQueryDS";
        this.stub = new BAMSummaryQueryDSStub(configCtx, serviceURL);
        ServiceClient client = this.stub._getServiceClient();
        Options option = client.getOptions();
        option.setManageSession(true);
        option.setProperty("Cookie", (Object)cookie);
    }

    public SummaryStat[] getServerStatHourlySummaries(MonitoredServerDTO server, Calendar startTime, Calendar endTime) throws RemoteException {
        return this.stub.getServerStatHourlySummaries(server.getServerId(), BAMCalendar.getInstance((Calendar)startTime).getBAMTimestamp(), BAMCalendar.getInstance((Calendar)endTime).getBAMTimestamp());
    }

    public SummaryStat[] getServerStatDailySummaries(MonitoredServerDTO server, Calendar startTime, Calendar endTime) throws RemoteException {
        return this.stub.getServerStatDailySummaries(server.getServerId(), BAMCalendar.getInstance((Calendar)startTime).getBAMTimestamp(), BAMCalendar.getInstance((Calendar)endTime).getBAMTimestamp());
    }

    public SummaryStat[] getServerStatMonthlySummaries(MonitoredServerDTO server, Calendar startTime, Calendar endTime) throws RemoteException {
        return this.stub.getServerStatMonthlySummaries(server.getServerId(), BAMCalendar.getInstance((Calendar)startTime).getBAMTimestamp(), BAMCalendar.getInstance((Calendar)endTime).getBAMTimestamp());
    }

    public SummaryStat[] getServerStatQuarterlySummaries(MonitoredServerDTO server, Calendar startTime, Calendar endTime) throws RemoteException {
        return this.stub.getServerStatQuarterlySummaries(server.getServerId(), BAMCalendar.getInstance((Calendar)startTime).getBAMTimestamp(), BAMCalendar.getInstance((Calendar)endTime).getBAMTimestamp());
    }

    public SummaryStat[] getServerStatYearlySummaries(MonitoredServerDTO server, Calendar startTime, Calendar endTime) throws RemoteException {
        return this.stub.getServerStatYearlySummaries(server.getServerId(), BAMCalendar.getInstance((Calendar)startTime).getBAMTimestamp(), BAMCalendar.getInstance((Calendar)endTime).getBAMTimestamp());
    }

    public SummaryStat[] getServiceStatHourlySummaries(ServiceDO service, Calendar startTime, Calendar endTime) throws RemoteException {
        return this.stub.getServiceStatHourlySummaries(service.getId(), BAMCalendar.getInstance((Calendar)startTime).getBAMTimestamp(), BAMCalendar.getInstance((Calendar)endTime).getBAMTimestamp());
    }

    public SummaryStat[] getServiceStatDailySummaries(ServiceDO service, Calendar startTime, Calendar endTime) throws RemoteException {
        return this.stub.getServiceStatDailySummaries(service.getId(), BAMCalendar.getInstance((Calendar)startTime).getBAMTimestamp(), BAMCalendar.getInstance((Calendar)endTime).getBAMTimestamp());
    }

    public SummaryStat[] getServiceStatMonthlySummaries(ServiceDO service, Calendar startTime, Calendar endTime) throws RemoteException {
        return this.stub.getServiceStatMonthlySummaries(service.getId(), BAMCalendar.getInstance((Calendar)startTime).getBAMTimestamp(), BAMCalendar.getInstance((Calendar)endTime).getBAMTimestamp());
    }

    public SummaryStat[] getServiceStatQuarterlySummaries(ServiceDO service, Calendar startTime, Calendar endTime) throws RemoteException {
        return this.stub.getServiceStatQuarterlySummaries(service.getId(), BAMCalendar.getInstance((Calendar)startTime).getBAMTimestamp(), BAMCalendar.getInstance((Calendar)endTime).getBAMTimestamp());
    }

    public SummaryStat[] getServiceStatYearlySummaries(ServiceDO service, Calendar startTime, Calendar endTime) throws RemoteException {
        return this.stub.getServiceStatYearlySummaries(service.getId(), BAMCalendar.getInstance((Calendar)startTime).getBAMTimestamp(), BAMCalendar.getInstance((Calendar)endTime).getBAMTimestamp());
    }

    public SummaryStat[] getServiceStatHourlySummaries(OperationDO op, Calendar startTime, Calendar endTime) throws RemoteException {
        return this.stub.getServiceStatHourlySummaries(op.getOperationID(), BAMCalendar.getInstance((Calendar)startTime).getBAMTimestamp(), BAMCalendar.getInstance((Calendar)endTime).getBAMTimestamp());
    }

    public SummaryStat[] getOperationStatHourlySummaries(OperationDO operation, Calendar startTime, Calendar endTime) throws RemoteException {
        return this.stub.getOperationStatHourlySummaries(operation.getOperationID(), BAMCalendar.getInstance((Calendar)startTime).getBAMTimestamp(), BAMCalendar.getInstance((Calendar)endTime).getBAMTimestamp());
    }

    public SummaryStat[] getOperationStatDailySummaries(OperationDO operation, Calendar startTime, Calendar endTime) throws RemoteException {
        return this.stub.getOperationStatDailySummaries(operation.getOperationID(), BAMCalendar.getInstance((Calendar)startTime).getBAMTimestamp(), BAMCalendar.getInstance((Calendar)endTime).getBAMTimestamp());
    }

    public SummaryStat[] getOperationStatMonthlySummaries(OperationDO operation, Calendar startTime, Calendar endTime) throws RemoteException {
        return this.stub.getOperationStatMonthlySummaries(operation.getOperationID(), BAMCalendar.getInstance((Calendar)startTime).getBAMTimestamp(), BAMCalendar.getInstance((Calendar)endTime).getBAMTimestamp());
    }

    public SummaryStat[] getOperationStatQuarterlySummaries(OperationDO operation, Calendar startTime, Calendar endTime) throws RemoteException {
        return this.stub.getOperationStatQuarterlySummaries(operation.getOperationID(), BAMCalendar.getInstance((Calendar)startTime).getBAMTimestamp(), BAMCalendar.getInstance((Calendar)endTime).getBAMTimestamp());
    }

    public SummaryStat[] getOperationStatYearlySummaries(OperationDO operation, Calendar startTime, Calendar endTime) throws RemoteException {
        return this.stub.getOperationStatYearlySummaries(operation.getOperationID(), BAMCalendar.getInstance((Calendar)startTime).getBAMTimestamp(), BAMCalendar.getInstance((Calendar)endTime).getBAMTimestamp());
    }

    public MedSummaryStat[] getEndpointStatHourlySummaries(int serverId, Endpoint endpoint, Calendar startTime, Calendar endTime) throws RemoteException {
        return this.stub.getEndpointStatHourlySummaries(serverId, endpoint.getEndpoint(), "In", BAMCalendar.getInstance((Calendar)startTime).getBAMTimestamp(), BAMCalendar.getInstance((Calendar)endTime).getBAMTimestamp());
    }

    public MedSummaryStat[] getEndpointStatDailySummaries(int serverId, Endpoint endpoint, Calendar startTime, Calendar endTime) throws RemoteException {
        return this.stub.getEndpointStatDailySummaries(serverId, endpoint.getEndpoint(), "In", BAMCalendar.getInstance((Calendar)startTime).getBAMTimestamp(), BAMCalendar.getInstance((Calendar)endTime).getBAMTimestamp());
    }

    public MedSummaryStat[] getEndpointStatMonthlySummaries(int serverId, Endpoint endpoint, Calendar startTime, Calendar endTime) throws RemoteException {
        return this.stub.getEndpointStatMonthlySummaries(serverId, endpoint.getEndpoint(), "In", BAMCalendar.getInstance((Calendar)startTime).getBAMTimestamp(), BAMCalendar.getInstance((Calendar)endTime).getBAMTimestamp());
    }

    public MedSummaryStat[] getEndpointStatQuarterlySummaries(int serverId, Endpoint endpoint, Calendar startTime, Calendar endTime) throws RemoteException {
        return this.stub.getEndpointStatQuarterlySummaries(serverId, endpoint.getEndpoint(), "In", BAMCalendar.getInstance((Calendar)startTime).getBAMTimestamp(), BAMCalendar.getInstance((Calendar)endTime).getBAMTimestamp());
    }

    public MedSummaryStat[] getEndpointStatYearlySummaries(int serverId, Endpoint endpoint, Calendar startTime, Calendar endTime) throws RemoteException {
        return this.stub.getEndpointStatQuarterlySummaries(serverId, endpoint.getEndpoint(), "In", BAMCalendar.getInstance((Calendar)startTime).getBAMTimestamp(), BAMCalendar.getInstance((Calendar)endTime).getBAMTimestamp());
    }

    public MedSummaryStat[] getSequenceStatHourlySummaries(int serverId, Sequence sequence, Calendar startTime, Calendar endTime) throws RemoteException {
        return this.stub.getSequenceStatHourlySummaries(serverId, sequence.getSequence(), "In", BAMCalendar.getInstance((Calendar)startTime).getBAMTimestamp(), BAMCalendar.getInstance((Calendar)endTime).getBAMTimestamp());
    }

    public MedSummaryStat[] getSequenceStatDailySummaries(int serverId, Sequence sequence, Calendar startTime, Calendar endTime) throws RemoteException {
        return this.stub.getSequenceStatDailySummaries(serverId, sequence.getSequence(), "In", BAMCalendar.getInstance((Calendar)startTime).getBAMTimestamp(), BAMCalendar.getInstance((Calendar)endTime).getBAMTimestamp());
    }

    public MedSummaryStat[] getSequenceStatMonthlySummaries(int serverId, Sequence sequence, Calendar startTime, Calendar endTime) throws RemoteException {
        return this.stub.getSequenceStatMonthlySummaries(serverId, sequence.getSequence(), "In", BAMCalendar.getInstance((Calendar)startTime).getBAMTimestamp(), BAMCalendar.getInstance((Calendar)endTime).getBAMTimestamp());
    }

    public MedSummaryStat[] getSequenceStatQuarterlySummaries(int serverId, Sequence sequence, Calendar startTime, Calendar endTime) throws RemoteException {
        return this.stub.getSequenceStatQuarterlySummaries(serverId, sequence.getSequence(), "In", BAMCalendar.getInstance((Calendar)startTime).getBAMTimestamp(), BAMCalendar.getInstance((Calendar)endTime).getBAMTimestamp());
    }

    public MedSummaryStat[] getSequenceStatYearlySummaries(int serverId, Sequence sequence, Calendar startTime, Calendar endTime) throws RemoteException {
        return this.stub.getSequenceStatQuarterlySummaries(serverId, sequence.getSequence(), "In", BAMCalendar.getInstance((Calendar)startTime).getBAMTimestamp(), BAMCalendar.getInstance((Calendar)endTime).getBAMTimestamp());
    }

    public MedSummaryStat[] getProxyStatHourlySummaries(int serverId, ProxyService proxy, Calendar startTime, Calendar endTime) throws RemoteException {
        return this.stub.getProxyStatHourlySummaries(serverId, proxy.getProxyService(), "In", BAMCalendar.getInstance((Calendar)startTime).getBAMTimestamp(), BAMCalendar.getInstance((Calendar)endTime).getBAMTimestamp());
    }

    public MedSummaryStat[] getProxyStatDailySummaries(int serverId, ProxyService proxy, Calendar startTime, Calendar endTime) throws RemoteException {
        return this.stub.getProxyStatDailySummaries(serverId, proxy.getProxyService(), "In", BAMCalendar.getInstance((Calendar)startTime).getBAMTimestamp(), BAMCalendar.getInstance((Calendar)endTime).getBAMTimestamp());
    }

    public MedSummaryStat[] getProxyStatMonthlySummaries(int serverId, ProxyService proxy, Calendar startTime, Calendar endTime) throws RemoteException {
        return this.stub.getProxyStatMonthlySummaries(serverId, proxy.getProxyService(), "In", BAMCalendar.getInstance((Calendar)startTime).getBAMTimestamp(), BAMCalendar.getInstance((Calendar)endTime).getBAMTimestamp());
    }

    public MedSummaryStat[] getProxyStatQuarterlySummaries(int serverId, ProxyService proxy, Calendar startTime, Calendar endTime) throws RemoteException {
        return this.stub.getProxyStatQuarterlySummaries(serverId, proxy.getProxyService(), "In", BAMCalendar.getInstance((Calendar)startTime).getBAMTimestamp(), BAMCalendar.getInstance((Calendar)endTime).getBAMTimestamp());
    }

    public MedSummaryStat[] getProxyStatYearlySummaries(int serverId, ProxyService proxy, Calendar startTime, Calendar endTime) throws RemoteException {
        return this.stub.getProxyStatQuarterlySummaries(serverId, proxy.getProxyService(), "In", BAMCalendar.getInstance((Calendar)startTime).getBAMTimestamp(), BAMCalendar.getInstance((Calendar)endTime).getBAMTimestamp());
    }

    public void cleanup() {
        block2: {
            try {
                this.stub._getServiceClient().cleanupTransport();
                this.stub._getServiceClient().cleanup();
                this.stub.cleanup();
            }
            catch (AxisFault axisFault) {
                if (!log.isErrorEnabled()) break block2;
                log.error((Object)("Stub cleanup failed: " + this.getClass().getName()), (Throwable)axisFault);
            }
        }
    }
}

