/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bam.ui.client;

import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.bam.stub.configadmin.BAMConfigAdminServiceStub;
import org.wso2.carbon.bam.stub.configadmin.types.carbon.MonitoredServerDTO;
import org.wso2.carbon.bam.stub.configadmin.types.carbon.ServerDO;

public class BAMConfigAdminServiceClient {
    private static final Log log = LogFactory.getLog(BAMConfigAdminServiceClient.class);
    private BAMConfigAdminServiceStub stub;

    public BAMConfigAdminServiceClient(String cookie, String backendServerURL, ConfigurationContext configCtx) throws AxisFault {
        String serviceURL = backendServerURL + "BAMConfigAdminService";
        this.stub = new BAMConfigAdminServiceStub(configCtx, serviceURL);
        ServiceClient client = this.stub._getServiceClient();
        Options option = client.getOptions();
        option.setManageSession(true);
        option.setProperty("Cookie", (Object)cookie);
    }

    public int addServer(ServerDO server) throws AxisFault {
        int statesOfAddedServer = -1;
        try {
            statesOfAddedServer = this.stub.addServer(server);
        }
        catch (Exception e) {
            this.handleException("Error while adding the new monitored server entry", e);
        }
        return statesOfAddedServer;
    }

    public void removeServer(MonitoredServerDTO dto) throws AxisFault {
        try {
            this.stub.removeServer(dto);
        }
        catch (Exception e) {
            this.handleException("Error while removing the new monitored server entry", e);
        }
    }

    public void updateServer(ServerDO server) throws AxisFault {
        try {
            this.stub.updateServer(server);
        }
        catch (Exception e) {
            this.handleException("Error while updating the monitored server entry", e);
        }
    }

    public ServerDO[] getServerList() throws AxisFault {
        try {
            return this.stub.getServerList();
        }
        catch (Exception e) {
            this.handleException("Error while requesting monitored servers list", e);
            return new ServerDO[0];
        }
    }

    public ServerDO getServer(int serverId) throws AxisFault {
        try {
            return this.stub.getServerDetails(serverId);
        }
        catch (Exception e) {
            this.handleException("Error while retrieving server details. ", e);
            return null;
        }
    }

    public void deactivateServer(int serverID) throws AxisFault {
        try {
            this.stub.deactivateServer(serverID);
        }
        catch (Exception e) {
            this.handleException("Error while deactivating server", e);
        }
    }

    public void activateServer(int serverID, String subscriptionID) throws AxisFault {
        try {
            this.stub.activateServer(serverID, subscriptionID);
        }
        catch (Exception e) {
            this.handleException("Error while deactivating server", e);
        }
    }

    public String getDataRetentionPeriod() throws AxisFault {
        try {
            return this.stub.getDataRetentionPeriod();
        }
        catch (Exception e) {
            this.handleException("Error while requesting the data retention period from server", e);
            return null;
        }
    }

    public String getDataArchivalPeriod() throws AxisFault {
        try {
            return this.stub.getDataArchivalPeriod();
        }
        catch (Exception e) {
            this.handleException("Error while requesting the data archival period from server", e);
            return null;
        }
    }

    public void updateDataRetentionPeriod(String timeRange) throws AxisFault {
        try {
            this.stub.setDataRetentionPeriod(timeRange);
        }
        catch (Exception e) {
            this.handleException("Error while updating the the data retention period", e);
        }
    }

    public void updateDataArchivalPeriod(String timeRange) throws AxisFault {
        try {
            this.stub.setDataArchivalPeriod(timeRange);
        }
        catch (Exception e) {
            this.handleException("Error while updating the the data archival period", e);
        }
    }

    public String subscribe(String topic, String brokerURL, String subscriberURL, String serverURL, String userName, String password) throws AxisFault {
        try {
            return this.stub.subscribe(topic, brokerURL, subscriberURL, serverURL, userName, password);
        }
        catch (Exception e) {
            this.handleException("Error occurred while subscribing to " + brokerURL, e);
            return null;
        }
    }

    public void unsubscribe(String brokerURL, String subscriptionId, String serverType, String serverURL) throws AxisFault {
        try {
            this.stub.unsubscribe(brokerURL, subscriptionId, serverType, serverURL);
        }
        catch (Exception e) {
            this.handleException("Error occurred while un-subscribing from " + brokerURL, e);
        }
    }

    private void handleException(String msg, Exception e) throws AxisFault {
        log.error((Object)msg, (Throwable)e);
        throw new AxisFault(msg, (Throwable)e);
    }

    public void cleanup() {
        block2: {
            try {
                this.stub._getServiceClient().cleanupTransport();
                this.stub._getServiceClient().cleanup();
                this.stub.cleanup();
            }
            catch (AxisFault axisFault) {
                if (!log.isErrorEnabled()) break block2;
                log.error((Object)("Stub cleanup failed: " + this.getClass().getName()), (Throwable)axisFault);
            }
        }
    }
}

