/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bam.ui;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.wso2.carbon.bam.util.BAMException;
import org.wso2.carbon.utils.CarbonUtils;

public class BAMConfiguration {
    private static OMElement bamElement = null;
    private static String eventBrokerName = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OMElement getBAMElement() throws BAMException {
        OMElement oMElement;
        XMLStreamReader parse;
        block10: {
            if (bamElement != null) {
                return bamElement;
            }
            FileReader reader = null;
            parse = null;
            String configFile = CarbonUtils.getCarbonConfigDirPath() + File.separator + "bam.xml";
            try {
                reader = new FileReader(configFile);
                parse = XMLInputFactory.newInstance().createXMLStreamReader(reader);
                StAXOMBuilder builder = new StAXOMBuilder(parse);
                bamElement = builder.getDocumentElement();
                bamElement.build();
                oMElement = bamElement;
                if (reader == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        reader.close();
                    }
                    if (parse != null) {
                        parse.close();
                    }
                    throw throwable;
                }
                catch (XMLStreamException e) {
                    throw new BAMException("error occurred creating stream for bam.xml", (Throwable)e);
                }
                catch (IOException e) {
                    throw new BAMException("error occurred getting bam.xml ", (Throwable)e);
                }
            }
            reader.close();
        }
        if (parse != null) {
            parse.close();
        }
        return oMElement;
    }

    public static String getPropertyFromBAMOMElement(OMElement bamElement, String propertyName) {
        OMElement element = bamElement.getFirstChildWithName(new QName(propertyName));
        return element.getText();
    }

    public static String getEventBrokerName() throws BAMException {
        try {
            if (eventBrokerName != null) {
                return eventBrokerName;
            }
            OMElement bamElement = BAMConfiguration.getBAMElement();
            eventBrokerName = BAMConfiguration.getPropertyFromBAMOMElement(bamElement, "eventBrokerServiceName");
            return eventBrokerName;
        }
        catch (Exception e) {
            return "EventBrokerService";
        }
    }
}

