/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bam.gauges.ui;

import java.net.SocketException;
import java.rmi.RemoteException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.bam.gauges.ui.BAMListAdminServiceClient;
import org.wso2.carbon.bam.gauges.ui.BAMStatQueryDSClient;
import org.wso2.carbon.bam.gauges.ui.GaugesUtils;
import org.wso2.carbon.bam.stub.listadmin.types.carbon.MonitoredServerDTO;
import org.wso2.carbon.bam.stub.listadmin.types.carbon.ServiceDO;
import org.wso2.carbon.bam.stub.statquery.Data;
import org.wso2.carbon.bam.stub.statquery.Operation;
import org.wso2.carbon.bam.util.BAMException;
import org.wso2.carbon.ui.CarbonUIUtil;

public class ServiceInfo {
    Log log = LogFactory.getLog(ServiceInfo.class);
    private BAMStatQueryDSClient bamDSClient;
    private BAMListAdminServiceClient bamListAdminClient;

    public ServiceInfo(ServletConfig config, HttpSession session, HttpServletRequest request) throws AxisFault, SocketException {
        String backendServerURL = CarbonUIUtil.getServerURL((ServletContext)config.getServletContext(), (HttpSession)session);
        ConfigurationContext configContext = (ConfigurationContext)config.getServletContext().getAttribute("ConfigurationContext");
        String cookie = (String)session.getAttribute("wso2carbon.admin.service.cookie");
        if (cookie != null) {
            this.bamDSClient = new BAMStatQueryDSClient(cookie, backendServerURL, configContext, request.getLocale());
            this.bamListAdminClient = new BAMListAdminServiceClient(cookie, backendServerURL, configContext, request.getLocale());
        }
    }

    public String getServerInfo(int serverID, boolean demo) throws BAMException, RemoteException {
        if (demo) {
            GaugesUtils gaugesUtils = new GaugesUtils();
            StringBuilder result = new StringBuilder();
            int[] maxOps = new int[]{8, 2, 4, 5, 1, 6};
            String formatString = "<level%d name=\"%s\" meta1=\"%s\" meta2=\"%s\" meta3=\"%s\" meta4=\"%s\" meta5=\"%s\" meta6=\"%s\"";
            Data data = gaugesUtils.generateRandomData(1000);
            result.append(String.format(formatString, 0, "http://127.0.0.1:RND", data.getReqCount(), data.getResCount(), data.getFaultCount(), data.getAvgTime(), data.getMinTime(), data.getMaxTime()));
            result.append(">\n");
            for (int i = 0; i < 6; ++i) {
                data = gaugesUtils.generateRandomData(250);
                result.append(String.format(formatString, 1, String.format("Service %d", i), data.getReqCount(), data.getResCount(), data.getFaultCount(), data.getAvgTime(), data.getMinTime(), data.getMaxTime()));
                result.append(">\n");
                for (int j = 0; j < maxOps[i]; ++j) {
                    data = gaugesUtils.generateRandomData(50);
                    result.append(String.format(formatString, 2, String.format("Operation %d", j), j % 2 == 0 ? "0" : data.getReqCount(), data.getResCount(), data.getFaultCount(), data.getAvgTime(), data.getMinTime(), data.getMaxTime()));
                    result.append(String.format(" count=\"%s\"/>\n", j % 2 == 0 ? "0" : data.getReqCount()));
                }
                result.append("</level1>\n");
            }
            result.append("</level0>\n");
            return result.toString();
        }
        StringBuilder result = new StringBuilder();
        String serverURL = "";
        if (this.bamListAdminClient != null) {
            MonitoredServerDTO[] serverList;
            try {
                serverList = this.bamListAdminClient.getServerList();
            }
            catch (BAMException e) {
                return "";
            }
            for (MonitoredServerDTO monitoredServerDTO : serverList) {
                if (monitoredServerDTO.getServerId() != serverID) continue;
                serverURL = monitoredServerDTO.getServerURL();
            }
        }
        if (this.bamDSClient != null) {
            Data serverData = null;
            try {
                serverData = this.bamDSClient.getLatestDataForServer(serverID);
            }
            catch (BAMException e) {
                throw new BAMException("Unable to get data for server with id" + serverID, (Throwable)e);
            }
            if (serverData != null) {
                result.append("<level0 name=\"").append(serverURL).append("\"");
                result.append(" meta1=\"").append(serverData.getReqCount()).append("\"");
                result.append(" meta2=\"").append(serverData.getResCount()).append("\"");
                result.append(" meta3=\"").append(serverData.getFaultCount()).append("\"");
                result.append(" meta4=\"").append(serverData.getAvgTime()).append("\"");
                result.append(" meta5=\"").append(serverData.getMinTime()).append("\"");
                result.append(" meta6=\"").append(serverData.getMaxTime()).append("\"");
                result.append(">\n");
            }
        }
        if (this.bamListAdminClient != null) {
            ServiceDO[] servicesList = new ServiceDO[]{};
            try {
                servicesList = this.bamListAdminClient.getServicesList(serverID);
            }
            catch (BAMException e) {
                return "";
            }
            if (servicesList != null) {
                for (MonitoredServerDTO monitoredServerDTO : servicesList) {
                    Operation[] operationsList;
                    result.append("<level1 name=\"").append(monitoredServerDTO.getName()).append("\"");
                    Data serviceData = null;
                    try {
                        serviceData = this.bamDSClient.getLatestDataForService(monitoredServerDTO.getId());
                    }
                    catch (BAMException e) {
                        throw new BAMException("Unable to get data for server with id" + serverID, (Throwable)e);
                    }
                    if (serviceData != null) {
                        result.append(" meta1=\"").append(serviceData.getReqCount()).append("\"");
                        result.append(" meta2=\"").append(serviceData.getResCount()).append("\"");
                        result.append(" meta3=\"").append(serviceData.getFaultCount()).append("\"");
                        result.append(" meta4=\"").append(serviceData.getAvgTime()).append("\"");
                        result.append(" meta5=\"").append(serviceData.getMinTime()).append("\"");
                        result.append(" meta6=\"").append(serviceData.getMaxTime()).append("\"");
                    }
                    result.append(">\n");
                    try {
                        operationsList = this.bamDSClient.getOperations(monitoredServerDTO.getId());
                    }
                    catch (BAMException e) {
                        throw new BAMException("Unable to get operation list for service" + monitoredServerDTO.getName(), (Throwable)e);
                    }
                    if (operationsList != null) {
                        for (Operation operation : operationsList) {
                            result.append(" <level2 name=\"").append(operation.getName()).append("\"");
                            Data operationData = null;
                            try {
                                operationData = this.bamDSClient.getLatestDataForOperation(Integer.parseInt(operation.getId()));
                            }
                            catch (BAMException e) {
                                throw new BAMException("Unable to get operation data for operation with ID: " + operation.getId(), (Throwable)e);
                            }
                            if (operationData != null) {
                                result.append(" count=\"").append(operationData.getReqCount()).append("\"");
                                result.append(" meta1=\"").append(operationData.getReqCount()).append("\"");
                                result.append(" meta2=\"").append(operationData.getResCount()).append("\"");
                                result.append(" meta3=\"").append(operationData.getFaultCount()).append("\"");
                                result.append(" meta4=\"").append(operationData.getAvgTime()).append("\"");
                                result.append(" meta5=\"").append(operationData.getMinTime()).append("\"");
                                result.append(" meta6=\"").append(operationData.getMaxTime()).append("\"");
                            }
                            result.append("/>\n");
                        }
                    }
                    result.append("</level1>\n");
                }
            }
        }
        result.append("</level0>\n");
        return result.toString();
    }
}

