/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bam.toolbox.deployer.internal;

import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.Socket;
import org.apache.axis2.deployment.DeploymentException;
import org.apache.axis2.deployment.repository.util.DeploymentFileData;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.bam.toolbox.deployer.core.BAMToolBoxDeployer;
import org.wso2.carbon.core.multitenancy.SuperTenantCarbonContext;
import org.wso2.carbon.registry.core.Collection;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;

public class ServerStartUpInspector
extends Thread {
    private static final Log log = LogFactory.getLog(BAMToolBoxDeployer.class);
    private static boolean serverStarted = false;
    private int port;

    public void setPort(int port) {
        this.port = port;
    }

    @Override
    public void run() {
        ServerStartUpInspector.waitForServerStartup(this.port, 180000L, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void waitForServerStartup(int port, long timeout, boolean verbose) {
        long startTime = System.currentTimeMillis();
        boolean isPortOpen = false;
        while (!isPortOpen && System.currentTimeMillis() - startTime < timeout) {
            Socket socket = null;
            try {
                InetAddress address = InetAddress.getByName("localhost");
                socket = new Socket(address, port);
                isPortOpen = socket.isConnected();
                if (!isPortOpen) continue;
                if (verbose) {
                    SuperTenantCarbonContext.getCurrentContext().setTenantId(-1234);
                    serverStarted = true;
                    ServerStartUpInspector.doPausedDeployments();
                }
                return;
            }
            catch (IOException e) {
                if (verbose) {
                    // empty if block
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ignored) {
                    // empty catch block
                }
            }
            finally {
                try {
                    if (socket == null || !socket.isConnected()) continue;
                    socket.close();
                }
                catch (IOException e) {
                    log.error((Object)"Can not close the socket with is used to check the server status ", (Throwable)e);
                }
            }
        }
        throw new RuntimeException("Port " + port + " is not open");
    }

    public static boolean isServerStarted() {
        return serverStarted;
    }

    private static void doPausedDeployments() throws DeploymentException {
        BAMToolBoxDeployer deployer = BAMToolBoxDeployer.getPausedDeployments();
        deployer.doInitialUnDeployments();
        for (DeploymentFileData fileData : deployer.getPausedDeploymentFileDatas()) {
            fileData.deploy();
        }
    }

    private static void saveInFileSystem(Registry registry, String registryPath, String fileSystemPath) {
        try {
            Resource resource = registry.get(registryPath);
            if (resource instanceof Collection) {
                File curPath = new File(fileSystemPath + "/" + ServerStartUpInspector.getFileName(registryPath));
                curPath.mkdirs();
                String[] allData = (String[])resource.getContent();
                if (null != allData) {
                    for (String aPath : allData) {
                        ServerStartUpInspector.saveInFileSystem(registry, aPath, curPath.getAbsolutePath());
                    }
                }
            } else {
                int c;
                InputStream stream = resource.getContentStream();
                String newFile = fileSystemPath + "/" + ServerStartUpInspector.getFileName(registryPath);
                DataOutputStream out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(newFile)));
                while ((c = stream.read()) != -1) {
                    out.writeByte(c);
                }
                stream.close();
                out.close();
            }
        }
        catch (RegistryException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static String getFileName(String path) {
        String[] all = path.split("/");
        return all[all.length - 1];
    }
}

