/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bam.toolbox.deployer.deploy;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.bam.toolbox.deployer.ServiceHolder;
import org.wso2.carbon.bam.toolbox.deployer.client.DashboardClient;
import org.wso2.carbon.bam.toolbox.deployer.client.DataPublisher;
import org.wso2.carbon.bam.toolbox.deployer.client.HiveScriptStoreClient;
import org.wso2.carbon.bam.toolbox.deployer.exception.BAMComponentNotFoundException;
import org.wso2.carbon.bam.toolbox.deployer.exception.BAMToolboxDeploymentException;
import org.wso2.carbon.bam.toolbox.deployer.util.DashBoardTabDTO;
import org.wso2.carbon.bam.toolbox.deployer.util.JasperTabDTO;
import org.wso2.carbon.bam.toolbox.deployer.util.ToolBoxDTO;
import org.wso2.carbon.registry.core.Collection;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.registry.core.utils.MediaTypesUtils;
import org.wso2.carbon.user.core.AuthorizationManager;

public class BAMArtifactDeployerManager {
    private static BAMArtifactDeployerManager instance;
    private static final Log log;
    private static final String gadgetsPath = "/repository/gadget-server/gadgets";
    private static final String jasperPath = "/repository/dashboards/jasper";

    private BAMArtifactDeployerManager() {
    }

    public static BAMArtifactDeployerManager getInstance() throws BAMToolboxDeploymentException {
        if (instance == null) {
            instance = new BAMArtifactDeployerManager();
        }
        return instance;
    }

    private void deployScripts(ToolBoxDTO toolBoxDTO) throws BAMToolboxDeploymentException {
        String scriptParent = toolBoxDTO.getScriptsParentDirectory();
        ArrayList<String> scriptNameWithId = new ArrayList<String>();
        for (String aScript : toolBoxDTO.getScriptNames()) {
            String path = scriptParent + File.separator + aScript;
            File scriptFile = new File(path);
            String scriptName = scriptFile.getName();
            scriptName = scriptName.split("\\.")[0];
            String content = this.getContent(scriptFile);
            scriptName = scriptName + "_" + BAMArtifactDeployerManager.getRandomArtifactId();
            scriptNameWithId.add(scriptName);
            try {
                HiveScriptStoreClient scriptStoreClient = HiveScriptStoreClient.getInstance();
                scriptStoreClient.saveHiveScript(scriptName, content, "1 * * * * ? *");
            }
            catch (BAMComponentNotFoundException e) {
                log.error((Object)(e.getMessage() + "Skipping deploying Hive scripts.."));
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        toolBoxDTO.setScriptNames(scriptNameWithId);
    }

    private static int getRandomArtifactId() {
        Random randomGenerator = new Random();
        return randomGenerator.nextInt(1000);
    }

    private void deployGadget(ToolBoxDTO toolBoxDTO, String username) {
        try {
            DashboardClient dashboardClient = DashboardClient.getInstance();
            for (DashBoardTabDTO tabDTO : toolBoxDTO.getDashboardTabs()) {
                int tabID = dashboardClient.addTab(username, tabDTO.getTabName());
                tabDTO.setTabId(tabID);
                for (String aGadget : tabDTO.getGadgets()) {
                    ServiceHolder.getGadgetRepoService().addGadgetEntryToRepo(aGadget.replaceAll(".xml", ""), "conf:/repository/gadget-server/gadgets/" + aGadget, "", null, null, null);
                    dashboardClient.addNewGadget(username, String.valueOf(tabID), "/registry/resource/_system/config/repository/gadget-server/gadgets/" + aGadget);
                }
            }
        }
        catch (BAMComponentNotFoundException e) {
            log.warn((Object)e.getMessage());
        }
        catch (Exception e) {
            log.warn((Object)"Deploying gadget is not successful.. Skipping deploying script..");
        }
    }

    private void undeployScript(String scriptName) {
        HiveScriptStoreClient scriptStoreClient = null;
        try {
            scriptStoreClient = HiveScriptStoreClient.getInstance();
            scriptStoreClient.deleteScript(scriptName);
        }
        catch (BAMComponentNotFoundException e) {
            log.warn((Object)(e.getMessage() + " Skipping un deploying scripts."));
        }
    }

    private void undeployTab(int tabId, String username) {
        DashboardClient dashboardClient = null;
        try {
            dashboardClient = DashboardClient.getInstance();
            dashboardClient.removeTab(username, tabId);
        }
        catch (BAMComponentNotFoundException e) {
            log.warn((Object)(e.getMessage() + " Skipping undeploying tab :" + tabId));
        }
    }

    private void undeployJasperTab(JasperTabDTO tabDTO, int tenantId) throws BAMToolboxDeploymentException {
        try {
            Registry registry = ServiceHolder.getRegistry(tenantId);
            String jrxmlPath = "/repository/dashboards/jasper/" + tabDTO.getJrxmlFileName();
            registry.delete(jrxmlPath);
        }
        catch (RegistryException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new BAMToolboxDeploymentException(e.getMessage(), e);
        }
    }

    public void deploy(ToolBoxDTO toolBoxDTO, int tenantId, String username, String password) throws BAMToolboxDeploymentException {
        if (this.canDeployDataStreamDefn() && null != toolBoxDTO.getStreamDefnParentDirectory()) {
            this.deployStreamDefn(toolBoxDTO, username, password);
        }
        if (this.canDeployScripts() && null != toolBoxDTO.getScriptsParentDirectory()) {
            this.deployScripts(toolBoxDTO);
        }
        if (this.canDeployGadgets()) {
            if (null != toolBoxDTO.getGagetsParentDirectory()) {
                this.transferGadgetsFilesToRegistry(new File(toolBoxDTO.getGagetsParentDirectory()), tenantId);
                this.deployGadget(toolBoxDTO, username);
                if (null != toolBoxDTO.getJaggeryAppParentDirectory()) {
                    this.deployJaggeryApps(toolBoxDTO);
                }
            }
            if (toolBoxDTO.getJasperParentDirectory() != null) {
                this.transferJRXMLFilesToRegistry(new File(toolBoxDTO.getJasperParentDirectory()), tenantId);
            }
        }
    }

    private boolean canDeployDataStreamDefn() {
        if (null == ServiceHolder.getDataBridgeReceiverService()) {
            log.warn((Object)"No DataReceiverService Found! Skipping deploying DataStream Definitions..");
            return false;
        }
        return true;
    }

    private void deployStreamDefn(ToolBoxDTO toolBoxDTO, String username, String password) throws BAMToolboxDeploymentException {
        DataPublisher client = DataPublisher.getInstance();
        for (String defn : toolBoxDTO.getEvenStreamDefs()) {
            String defnPath = toolBoxDTO.getStreamDefnParentDirectory() + File.separator + defn;
            String streamDefn = this.getStreamDefinition(defnPath);
            client.createEventDefn(streamDefn, username, password);
        }
    }

    private void deployJaggeryApps(ToolBoxDTO toolBoxDTO) {
        String jaggeryDeployementDir = toolBoxDTO.getHotDeploymentRootDir() + File.separator + "jaggeryapps/gadgetgen";
        File deployDir = new File(jaggeryDeployementDir);
        if (!deployDir.exists()) {
            deployDir.mkdirs();
        }
        ArrayList<String> files = this.getFilesInDir(toolBoxDTO.getJaggeryAppParentDirectory());
        for (String aJaggeryApp : files) {
            String srcFile = toolBoxDTO.getJaggeryAppParentDirectory() + File.separator + aJaggeryApp;
            FileInputStream in = null;
            try {
                int len;
                in = new FileInputStream(srcFile);
                FileOutputStream out = new FileOutputStream(jaggeryDeployementDir + File.separator + aJaggeryApp);
                byte[] buf = new byte[1024];
                while ((len = ((InputStream)in).read(buf)) > 0) {
                    ((OutputStream)out).write(buf, 0, len);
                }
                ((InputStream)in).close();
                ((OutputStream)out).close();
            }
            catch (FileNotFoundException e) {
                log.error((Object)e);
            }
            catch (IOException e) {
                log.error((Object)e);
            }
        }
    }

    private ArrayList<String> getFilesInDir(String dirPath) {
        File dir = new File(dirPath);
        ArrayList<String> files = new ArrayList<String>();
        String[] children = dir.list();
        if (null != children) {
            for (String aChildren : children) {
                if (new File(aChildren).isDirectory()) continue;
                files.add(aChildren);
            }
        }
        return files;
    }

    private boolean canDeployScripts() {
        try {
            Class<?> serviceClass = Class.forName("org.wso2.carbon.analytics.hive.web.HiveScriptStoreService");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private boolean canDeployGadgets() {
        try {
            Class<?> serviceClass = Class.forName("org.wso2.carbon.dashboard.DashboardDSService");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private void transferGadgetsFilesToRegistry(File rootDirectory, int tenantId) throws BAMToolboxDeploymentException {
        try {
            String rootPath = rootDirectory.getAbsolutePath();
            Registry registry = ServiceHolder.getRegistry(tenantId);
            try {
                registry.beginTransaction();
                if (!registry.resourceExists(gadgetsPath)) {
                    registry.put(gadgetsPath, (Resource)registry.newCollection());
                }
                BAMArtifactDeployerManager.transferDirectoryContentToRegistry(rootDirectory, registry, rootPath, gadgetsPath, tenantId);
                registry.commitTransaction();
            }
            catch (Exception e) {
                registry.rollbackTransaction();
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        catch (RegistryException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new BAMToolboxDeploymentException(e.getMessage(), e);
        }
    }

    private void transferJRXMLFilesToRegistry(File rootDirectory, int tenantId) throws BAMToolboxDeploymentException {
        try {
            String rootPath = rootDirectory.getAbsolutePath();
            Registry registry = ServiceHolder.getRegistry(tenantId);
            try {
                registry.beginTransaction();
                if (!registry.resourceExists(jasperPath)) {
                    registry.put(jasperPath, (Resource)registry.newCollection());
                }
                BAMArtifactDeployerManager.transferDirectoryContentToRegistry(rootDirectory, registry, rootPath, jasperPath, tenantId);
                registry.commitTransaction();
            }
            catch (Exception e) {
                registry.rollbackTransaction();
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        catch (RegistryException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new BAMToolboxDeploymentException(e.getMessage(), e);
        }
    }

    private static void transferDirectoryContentToRegistry(File rootDirectory, Registry registry, String rootPath, String registryPath, int tenantId) throws FileNotFoundException, BAMToolboxDeploymentException {
        try {
            File[] filesAndDirs = rootDirectory.listFiles();
            List<File> filesDirs = Arrays.asList(filesAndDirs);
            for (File file : filesDirs) {
                if (!file.isFile()) {
                    String directoryRegistryPath = registryPath + file.getAbsolutePath().substring(rootPath.length()).replaceAll("[/\\\\]+", "/");
                    Collection newCollection = registry.newCollection();
                    registry.put(directoryRegistryPath, (Resource)newCollection);
                    BAMArtifactDeployerManager.transferDirectoryContentToRegistry(file, registry, rootPath, registryPath, tenantId);
                    continue;
                }
                BAMArtifactDeployerManager.addToRegistry(rootPath, file, registryPath, tenantId);
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new BAMToolboxDeploymentException(e.getMessage(), e);
        }
    }

    private static void addToRegistry(String rootPath, File file, String registryPath, int tenantId) throws BAMToolboxDeploymentException {
        try {
            Registry registry = ServiceHolder.getRegistry(tenantId);
            String fileRegistryPath = registryPath + file.getAbsolutePath().substring(rootPath.length()).replaceAll("[/\\\\]+", "/");
            Resource fileResource = registry.newResource();
            String mediaType = MediaTypesUtils.getMediaType((String)file.getAbsolutePath());
            if (mediaType.equals("application/xml")) {
                fileResource.setMediaType("application/vnd.wso2-gadget+xml");
            } else {
                fileResource.setMediaType(mediaType);
            }
            fileResource.setContentStream((InputStream)new FileInputStream(file));
            registry.put(fileRegistryPath, fileResource);
            AuthorizationManager authorizationManager = ((UserRegistry)ServiceHolder.getRegistry(tenantId)).getUserRealm().getAuthorizationManager();
            authorizationManager.authorizeRole("wso2.anonymous.role", "/_system/config" + fileRegistryPath, "http://www.wso2.org/projects/registry/actions/get");
            Registry reg = ServiceHolder.getGovernanceSystemRegistry(tenantId);
            Resource resource = reg.newResource();
            resource.setProperty("timestamp", Long.toString(System.currentTimeMillis()));
            registry.put("/repository/components/org.wso2.carbon.user.mgt/updatedTime", resource);
        }
        catch (RegistryException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new BAMToolboxDeploymentException(e.getMessage(), e);
        }
        catch (FileNotFoundException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new BAMToolboxDeploymentException(e.getMessage(), e);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new BAMToolboxDeploymentException(e.getMessage(), e);
        }
    }

    public void undeploy(ToolBoxDTO toolBoxDTO, String username, int tenantId) throws BAMToolboxDeploymentException {
        if (this.canDeployScripts()) {
            for (String string : toolBoxDTO.getScriptNames()) {
                this.undeployScript(string);
            }
        }
        if (this.canDeployGadgets()) {
            for (DashBoardTabDTO dashBoardTabDTO : toolBoxDTO.getDashboardTabs()) {
                int tabId = dashBoardTabDTO.getTabId();
                this.undeployTab(tabId, username);
            }
            if (toolBoxDTO.getJasperTabs() != null) {
                for (JasperTabDTO jasperTabDTO : toolBoxDTO.getJasperTabs()) {
                    this.undeployJasperTab(jasperTabDTO, tenantId);
                }
            }
        }
    }

    private String getContent(File file) throws BAMToolboxDeploymentException {
        if (!file.isDirectory()) {
            try {
                String strLine;
                FileInputStream fstream = new FileInputStream(file);
                DataInputStream in = new DataInputStream(fstream);
                BufferedReader br = new BufferedReader(new InputStreamReader(in));
                String content = "";
                while ((strLine = br.readLine()) != null) {
                    content = content + strLine;
                }
                in.close();
                return content;
            }
            catch (FileNotFoundException e) {
                log.error((Object)("File not found " + file.getAbsolutePath()), (Throwable)e);
                throw new BAMToolboxDeploymentException("File not found " + file.getAbsolutePath(), e);
            }
            catch (IOException e) {
                log.error((Object)("Exception while reading the file: " + file.getAbsolutePath()), (Throwable)e);
                throw new BAMToolboxDeploymentException("Exception while reading the file: " + file.getAbsolutePath(), e);
            }
        }
        return "";
    }

    private String getStreamDefinition(String filePath) throws BAMToolboxDeploymentException {
        try {
            String strLine;
            FileInputStream fstream = null;
            fstream = new FileInputStream(filePath);
            DataInputStream in = new DataInputStream(fstream);
            BufferedReader br = new BufferedReader(new InputStreamReader(in));
            String streamDefn = "";
            while ((strLine = br.readLine()) != null) {
                streamDefn = streamDefn + strLine;
            }
            in.close();
            return streamDefn;
        }
        catch (FileNotFoundException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new BAMToolboxDeploymentException(e.getMessage(), e);
        }
        catch (IOException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new BAMToolboxDeploymentException(e.getMessage(), e);
        }
    }

    static {
        log = LogFactory.getLog(BAMArtifactDeployerManager.class);
    }
}

