/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bam.toolbox.deployer.core;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.deployment.AbstractDeployer;
import org.apache.axis2.deployment.DeploymentException;
import org.apache.axis2.deployment.repository.util.DeploymentFileData;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.wso2.carbon.bam.toolbox.deployer.BAMToolBoxDeployerConstants;
import org.wso2.carbon.bam.toolbox.deployer.ServiceHolder;
import org.wso2.carbon.bam.toolbox.deployer.config.ToolBoxConfigurationManager;
import org.wso2.carbon.bam.toolbox.deployer.core.BAMArtifactProcessor;
import org.wso2.carbon.bam.toolbox.deployer.deploy.BAMArtifactDeployerManager;
import org.wso2.carbon.bam.toolbox.deployer.exception.BAMToolboxDeploymentException;
import org.wso2.carbon.bam.toolbox.deployer.internal.ServerStartUpInspector;
import org.wso2.carbon.bam.toolbox.deployer.util.ToolBoxDTO;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.core.multitenancy.SuperTenantCarbonContext;
import org.wso2.carbon.core.util.CryptoException;
import org.wso2.carbon.core.util.CryptoUtil;
import org.wso2.carbon.ndatasource.common.DataSourceException;
import org.wso2.carbon.ndatasource.core.DataSourceMetaInfo;
import org.wso2.carbon.ndatasource.core.DataSourceService;
import org.wso2.carbon.ndatasource.rdbms.RDBMSConfiguration;
import org.wso2.carbon.ndatasource.rdbms.RDBMSDataSourceReader;
import org.wso2.carbon.user.api.Tenant;
import org.wso2.carbon.user.core.UserStoreException;
import org.wso2.carbon.user.core.tenant.TenantManager;
import org.wso2.carbon.utils.CarbonUtils;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class BAMToolBoxDeployer
extends AbstractDeployer {
    private ConfigurationContext configurationContext;
    private String extension;
    private String directory;
    private static final Log log = LogFactory.getLog(BAMToolBoxDeployer.class);
    private static BAMToolBoxDeployer pausedDeployments = new BAMToolBoxDeployer();
    private ArrayList<DeploymentFileData> pausedDeploymentFileDatas = new ArrayList();
    private int port;

    public void init(ConfigurationContext configurationContext) {
        this.configurationContext = configurationContext;
        this.createHotDeployementFolderIfNotExists();
        CarbonContext.getCurrentContext().getTenantId();
        if (!ServerStartUpInspector.isServerStarted()) {
            if (this.getTenantId() == -1234) {
                pausedDeployments = this;
                String portOffset = CarbonUtils.getServerConfiguration().getFirstProperty(BAMToolBoxDeployerConstants.PORT_OFF_SET);
                this.port = CarbonUtils.getTransportPort((ConfigurationContext)this.configurationContext, (String)"https") + Integer.parseInt(portOffset);
                ServerStartUpInspector inspector = new ServerStartUpInspector();
                inspector.setPort(this.port);
                inspector.start();
            }
        } else {
            this.doInitialUnDeployments();
        }
    }

    public void doInitialUnDeployments() {
        try {
            ArrayList<String> allTools = ToolBoxConfigurationManager.getInstance().getAllToolBoxNames(this.getTenantId());
            ArrayList<String> availArtifacts = this.getAllBAMArtifacts();
            for (String aTool : allTools) {
                if (availArtifacts.contains(aTool)) continue;
                this.removeAllArtifacts(aTool);
            }
        }
        catch (BAMToolboxDeploymentException e) {
            log.error((Object)"Error in initializing the tasks of BAM Tool Box deployement", (Throwable)((Object)e));
        }
    }

    public void setDirectory(String dir) {
        this.directory = dir;
    }

    public void setExtension(String extension) {
        this.extension = extension;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void deploy(DeploymentFileData deploymentFileData) throws DeploymentException {
        if (ServerStartUpInspector.isServerStarted()) {
            String path = deploymentFileData.getAbsolutePath();
            File toolBox = new File(path);
            String destDir = toolBox.getParent();
            ToolBoxConfigurationManager manager = ToolBoxConfigurationManager.getInstance();
            try {
                ArrayList<String> allTools = manager.getAllToolBoxNames(this.getTenantId());
                if (allTools.contains(toolBox.getName().replaceAll(".tbox", ""))) return;
                log.info((Object)("Deploying file:" + path));
                BAMArtifactProcessor processor = BAMArtifactProcessor.getInstance();
                String barDir = processor.extractBAMArtifact(path, destDir + "/temp");
                ToolBoxDTO aTool = processor.getToolBoxDTO(barDir);
                aTool.setHotDeploymentRootDir(this.configurationContext.getAxisConfiguration().getRepository().getPath());
                int tenantId = this.getTenantId();
                BAMArtifactDeployerManager.getInstance().deploy(aTool, tenantId, this.getTenantAdminName(tenantId), this.getTenantAdminPassword(tenantId));
                manager.addNewToolBoxConfiguration(aTool, this.getTenantId());
                this.createDataSource(aTool);
                String repoPath = this.configurationContext.getAxisConfiguration().getRepository().getPath();
                this.removeTempFiles(new File(repoPath + File.separator + this.directory + "/temp"));
                log.info((Object)("Deployed successfully file: " + path));
                return;
            }
            catch (BAMToolboxDeploymentException e) {
                log.error((Object)("Error while deploying bam  artifact :" + deploymentFileData.getAbsolutePath()), (Throwable)((Object)e));
                throw new BAMToolboxDeploymentException("Error while deploying bam  artifact :" + deploymentFileData.getAbsolutePath(), (Throwable)((Object)e));
            }
            catch (DataSourceException e) {
                log.error((Object)("Error while deploying bam  artifact :" + deploymentFileData.getAbsolutePath()), (Throwable)e);
                throw new BAMToolboxDeploymentException("Error while deploying bam  artifact :" + deploymentFileData.getAbsolutePath(), e);
            }
            catch (IOException e) {
                log.error((Object)("Error while deploying bam  artifact :" + deploymentFileData.getAbsolutePath()), (Throwable)e);
                throw new BAMToolboxDeploymentException("Error while deploying bam  artifact :" + deploymentFileData.getAbsolutePath(), e);
            }
            catch (ParserConfigurationException e) {
                log.error((Object)("Error while deploying bam  artifact :" + deploymentFileData.getAbsolutePath()), (Throwable)e);
                throw new BAMToolboxDeploymentException("Error while deploying bam  artifact :" + deploymentFileData.getAbsolutePath(), e);
            }
            catch (SAXException e) {
                log.error((Object)("Error while deploying bam  artifact :" + deploymentFileData.getAbsolutePath()), (Throwable)e);
                throw new BAMToolboxDeploymentException("Error while deploying bam  artifact :" + deploymentFileData.getAbsolutePath(), e);
            }
        } else {
            this.pausedDeploymentFileDatas.add(deploymentFileData);
        }
    }

    private int getTenantId() {
        AxisConfiguration axisConfiguration = this.configurationContext.getAxisConfiguration();
        return SuperTenantCarbonContext.getCurrentContext((AxisConfiguration)axisConfiguration).getTenantId();
    }

    private void createDataSource(ToolBoxDTO toolBox) throws DataSourceException, IOException, ParserConfigurationException, SAXException {
        String dataSource = toolBox.getDataSource();
        String dataSourceConfigurationFile = toolBox.getDataSourceConfiguration();
        if (!(dataSource == null && "".equals(dataSource) || dataSourceConfigurationFile == null || "".equals(dataSource))) {
            DataSourceService dataSourceService = ServiceHolder.getDataSourceService();
            String dsConfigXML = IOUtils.toString((InputStream)new FileInputStream(dataSourceConfigurationFile));
            RDBMSConfiguration config = RDBMSDataSourceReader.loadConfig((String)dsConfigXML);
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(new InputSource(new StringReader(dsConfigXML)));
            Element configElement = document.getDocumentElement();
            DataSourceMetaInfo.DataSourceDefinition dsDef = new DataSourceMetaInfo.DataSourceDefinition();
            dsDef.setDsXMLConfiguration((Object)configElement);
            dsDef.setType("RDBMS");
            DataSourceMetaInfo metaInfo = new DataSourceMetaInfo();
            metaInfo.setName(dataSource);
            metaInfo.setDefinition(dsDef);
            dataSourceService.addDataSource(metaInfo);
        }
    }

    public void undeploy(String fileName) throws DeploymentException {
        log.info((Object)("Undeploying file:" + fileName));
        File file = new File(fileName);
        try {
            this.removeAllArtifacts(file.getName().replaceAll(".tbox", ""));
            super.undeploy(fileName);
            log.info((Object)("Undeployed successfully file: " + file));
        }
        catch (BAMToolboxDeploymentException e) {
            log.error((Object)("Error while undeploying file " + fileName), (Throwable)((Object)e));
            throw new BAMToolboxDeploymentException("Error while undeploying file " + fileName, (Throwable)((Object)e));
        }
    }

    private ArrayList<String> getAllBAMArtifacts() {
        String repoPath = this.configurationContext.getAxisConfiguration().getRepository().getPath();
        File dir = new File(repoPath + File.separator + this.directory);
        log.info((Object)dir.getAbsolutePath());
        ArrayList<String> files = new ArrayList<String>();
        String[] children = dir.list();
        if (children != null) {
            for (int i = 0; i < children.length; ++i) {
                if (new File(children[i]).isDirectory() || !children[i].endsWith("tbox")) continue;
                files.add(children[i].replaceAll(".tbox", ""));
            }
        }
        return files;
    }

    private void removeAllArtifacts(String aToolName) throws BAMToolboxDeploymentException {
        int tenantId = this.getTenantId();
        ToolBoxConfigurationManager manager = ToolBoxConfigurationManager.getInstance();
        ToolBoxDTO toolBoxDTO = manager.getToolBox(aToolName, this.getTenantId());
        BAMArtifactDeployerManager.getInstance().undeploy(toolBoxDTO, this.getTenantAdminName(tenantId), tenantId);
        manager.deleteToolBoxConfiguration(aToolName, this.getTenantId());
    }

    public void cleanup() throws DeploymentException {
        super.cleanup();
        String repoPath = this.configurationContext.getAxisConfiguration().getRepository().getPath();
        this.removeTempFiles(new File(repoPath + File.separator + this.directory + "/temp"));
    }

    private boolean removeTempFiles(File tempDir) {
        if (tempDir == null) {
            return false;
        }
        if (!tempDir.exists()) {
            return true;
        }
        if (!tempDir.isDirectory()) {
            return false;
        }
        String[] list = tempDir.list();
        if (list != null) {
            for (int i = 0; i < list.length; ++i) {
                File entry = new File(tempDir, list[i]);
                if (!(entry.isDirectory() ? !this.removeTempFiles(entry) : !entry.delete())) continue;
                return false;
            }
        }
        return tempDir.delete();
    }

    private void createHotDeployementFolderIfNotExists() {
        String repoPath = this.configurationContext.getAxisConfiguration().getRepository().getPath();
        File hotDeploymentDir = new File(repoPath + File.separator + this.directory);
        if (!hotDeploymentDir.exists()) {
            hotDeploymentDir.mkdir();
        }
    }

    private String getTenantAdminName(int tenantId) throws BAMToolboxDeploymentException {
        if (tenantId == -1234) {
            try {
                return ServiceHolder.getUserRealm().getRealmConfiguration().getAdminUserName();
            }
            catch (UserStoreException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
                throw new BAMToolboxDeploymentException("Error while obtaining the admin username for tenant: " + tenantId, e);
            }
        }
        TenantManager manager = ServiceHolder.getRealmService().getTenantManager();
        try {
            Tenant tenant = manager.getTenant(tenantId);
            return tenant.getRealmConfig().getAdminUserName();
        }
        catch (org.wso2.carbon.user.api.UserStoreException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new BAMToolboxDeploymentException("Error while obtaining the admin username for tenant: " + tenantId, e);
        }
    }

    private String getTenantAdminPassword(int tenantId) throws BAMToolboxDeploymentException {
        if (tenantId == -1234) {
            try {
                return ServiceHolder.getUserRealm().getRealmConfiguration().getAdminPassword();
            }
            catch (UserStoreException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
                throw new BAMToolboxDeploymentException("Error while obtaining the admin username for tenant: " + tenantId, e);
            }
        }
        TenantManager manager = ServiceHolder.getRealmService().getTenantManager();
        try {
            return new String(CryptoUtil.getDefaultCryptoUtil().decrypt(manager.getTenant(tenantId).getRealmConfig().getAdminPassword().getBytes()));
        }
        catch (org.wso2.carbon.user.api.UserStoreException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new BAMToolboxDeploymentException("Error while obtaining the admin username for tenant: " + tenantId, e);
        }
        catch (CryptoException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return "";
        }
    }

    public ArrayList<DeploymentFileData> getPausedDeploymentFileDatas() {
        return this.pausedDeploymentFileDatas;
    }

    public static BAMToolBoxDeployer getPausedDeployments() {
        return pausedDeployments;
    }
}

