/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bam.toolbox.deployer.core;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.bam.toolbox.deployer.exception.BAMToolboxDeploymentException;
import org.wso2.carbon.bam.toolbox.deployer.util.DashBoardTabDTO;
import org.wso2.carbon.bam.toolbox.deployer.util.JasperTabDTO;
import org.wso2.carbon.bam.toolbox.deployer.util.ToolBoxDTO;

public class BAMArtifactProcessor {
    private static BAMArtifactProcessor instance;
    private static final Log log;

    private BAMArtifactProcessor() {
    }

    public static BAMArtifactProcessor getInstance() {
        if (null == instance) {
            instance = new BAMArtifactProcessor();
        }
        return instance;
    }

    public String extractBAMArtifact(String bamArtifact, String destFolder) throws BAMToolboxDeploymentException {
        return this.unzipFolder(bamArtifact, destFolder);
    }

    private String unzipFolder(String zipFile, String destFolder) throws BAMToolboxDeploymentException {
        try {
            ZipFile bamArtifact = new ZipFile(zipFile);
            Enumeration<? extends ZipEntry> zipEnum = bamArtifact.entries();
            while (zipEnum.hasMoreElements()) {
                int ch;
                ZipEntry item = zipEnum.nextElement();
                if (item.isDirectory()) {
                    File newdir = new File(destFolder + File.separator + item.getName());
                    newdir.mkdir();
                    continue;
                }
                String newfilePath = destFolder + File.separator + item.getName();
                File newFile = new File(newfilePath);
                if (!newFile.getParentFile().exists()) {
                    newFile.getParentFile().mkdirs();
                }
                InputStream is = bamArtifact.getInputStream(item);
                FileOutputStream fos = new FileOutputStream(newfilePath);
                while ((ch = is.read()) != -1) {
                    fos.write(ch);
                }
                is.close();
                fos.close();
            }
            bamArtifact.close();
            File file = new File(bamArtifact.getName());
            return destFolder + File.separator + file.getName().replace(".tbox", "");
        }
        catch (Exception e) {
            log.error((Object)("Exception while extracting the BAM artifact:" + zipFile), (Throwable)e);
            throw new BAMToolboxDeploymentException("Exception while extracting the BAM artifact:" + zipFile, e);
        }
    }

    public ToolBoxDTO getToolBoxDTO(String barDir) throws BAMToolboxDeploymentException {
        return this.createDTO(barDir);
    }

    private ToolBoxDTO createDTO(String barDir) throws BAMToolboxDeploymentException {
        File file = new File(barDir);
        String name = file.getName();
        ToolBoxDTO toolBoxDTO = new ToolBoxDTO(name);
        this.setScriptsNames(toolBoxDTO, barDir);
        this.setGadgetNames(toolBoxDTO, barDir);
        this.setJaggeryAppNames(toolBoxDTO, barDir);
        this.setStreamDefnNames(toolBoxDTO, barDir);
        this.setJasperResourceNames(toolBoxDTO, barDir);
        return toolBoxDTO;
    }

    private void setScriptsNames(ToolBoxDTO toolBoxDTO, String barDir) throws BAMToolboxDeploymentException {
        ArrayList<String> scriptNames = this.getFilesInDirectory(barDir + File.separator + "scripts");
        if (scriptNames.size() == 0) {
            toolBoxDTO.setScriptsParentDirectory(null);
            log.warn((Object)"No scripts available in the specified directory");
        } else {
            toolBoxDTO.setScriptsParentDirectory(barDir + File.separator + "scripts");
            toolBoxDTO.setScriptNames(scriptNames);
        }
    }

    private void setStreamDefnNames(ToolBoxDTO toolBoxDTO, String barDir) throws BAMToolboxDeploymentException {
        ArrayList<String> streamDefNames = this.getFilesInDirectory(barDir + File.separator + "streamDefn");
        if (streamDefNames.size() == 0) {
            toolBoxDTO.setStreamDefnParentDirectory(null);
            log.warn((Object)"No event streams found in the specified directory");
        } else {
            toolBoxDTO.setStreamDefnParentDirectory(barDir + File.separator + "streamDefn");
            toolBoxDTO.setEvenStreamDefs(streamDefNames);
        }
    }

    private void setJaggeryAppNames(ToolBoxDTO toolBoxDTO, String barDir) throws BAMToolboxDeploymentException {
        if (null != toolBoxDTO.getGagetsParentDirectory()) {
            File jaggeryDir = new File(barDir);
            if (jaggeryDir.exists()) {
                toolBoxDTO.setJaggeryAppParentDirectory(barDir + File.separator + "dashboard" + File.separator + "jaggery");
            } else {
                log.warn((Object)"No jaggery artifacts found..");
                toolBoxDTO.setJaggeryAppParentDirectory(null);
            }
        } else {
            log.warn((Object)"No gadgets dir found, and skipping jaggery artifacts");
            toolBoxDTO.setJaggeryAppParentDirectory(null);
        }
    }

    private void setGadgetNames(ToolBoxDTO toolBoxDTO, String barDir) throws BAMToolboxDeploymentException {
        if (new File(barDir + File.separator + "dashboard" + File.separator + "gadgets").exists()) {
            toolBoxDTO.setGagetsParentDirectory(barDir + File.separator + "dashboard" + File.separator + "gadgets");
            Properties properties = new Properties();
            try {
                properties.load(new FileInputStream(barDir + File.separator + "dashboard" + File.separator + "dashboard.properties"));
                this.setTabAndGadgetNames(toolBoxDTO, properties);
            }
            catch (FileNotFoundException e) {
                log.warn((Object)("No dashboard.properties found in dir:" + barDir + File.separator + "dashboard"));
                log.error((Object)"Skipping installing dashboard artifacts..");
                toolBoxDTO.setGagetsParentDirectory(null);
                toolBoxDTO.setDashboardTabs(new ArrayList<DashBoardTabDTO>());
            }
            catch (IOException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
                throw new BAMToolboxDeploymentException(e.getMessage(), e);
            }
        } else {
            toolBoxDTO.setGagetsParentDirectory(null);
            toolBoxDTO.setDashboardTabs(new ArrayList<DashBoardTabDTO>());
        }
    }

    private void setJasperResourceNames(ToolBoxDTO toolBoxDTO, String barDir) throws BAMToolboxDeploymentException {
        String jasperDirectory = barDir + File.separator + "dashboard" + File.separator + "jasper";
        if (new File(jasperDirectory).exists()) {
            toolBoxDTO.setJasperParentDirectory(barDir + File.separator + "dashboard" + File.separator + "jasper");
            Properties properties = new Properties();
            try {
                properties.load(new FileInputStream(barDir + File.separator + "dashboard" + File.separator + "jasper.properties"));
                this.setJasperTabAndJrxmlNames(toolBoxDTO, properties);
                toolBoxDTO.setDataSource(properties.getProperty("datasource"));
                toolBoxDTO.setDataSourceConfiguration(barDir + File.separator + "dashboard" + File.separator + properties.getProperty("datasource.configuration"));
            }
            catch (FileNotFoundException e) {
                log.error((Object)("No jasper.properties found in dir:" + barDir + File.separator + "dashboard"), (Throwable)e);
                throw new BAMToolboxDeploymentException("No jasper.properties found in dir:" + barDir + File.separator + "dashboard", e);
            }
            catch (IOException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
                throw new BAMToolboxDeploymentException(e.getMessage(), e);
            }
        } else {
            toolBoxDTO.setJasperParentDirectory(null);
            toolBoxDTO.setJasperTabs(new ArrayList<JasperTabDTO>());
        }
    }

    private void setJasperTabAndJrxmlNames(ToolBoxDTO toolBoxDTO, Properties props) throws BAMToolboxDeploymentException {
        String tabs = props.getProperty("jasper.tabs").trim();
        if (null != tabs && !tabs.equals("")) {
            String[] tabVarNames = tabs.split(",");
            if (tabVarNames == null || tabVarNames.length == 0) {
                throw new BAMToolboxDeploymentException("Invalid tbox artifact. No tabs found in jasper.properties");
            }
            boolean valid = false;
            int tabId = 1;
            for (String aTabVarName : tabVarNames) {
                if (aTabVarName.trim().equals("")) continue;
                valid = true;
                JasperTabDTO tabDTO = new JasperTabDTO();
                String tabName = props.getProperty("jasper.tabs." + aTabVarName.trim() + "." + "name");
                if (null == tabName || tabName.equals("")) {
                    tabName = aTabVarName;
                }
                tabDTO.setTabName(tabName);
                toolBoxDTO.addJasperTab(tabDTO);
                String jrxml = props.getProperty("jasper.tabs." + aTabVarName.trim() + "." + "jrxml");
                if (null != jrxml && !jrxml.trim().equals("")) {
                    tabDTO.setTabId(tabId);
                    tabDTO.setJrxmlFileName(jrxml.trim());
                } else {
                    log.warn((Object)("No gadgets are specified for tab: " + tabName));
                }
                ++tabId;
            }
            if (!valid) {
                toolBoxDTO.setJasperParentDirectory(null);
                log.error((Object)"Invalid tbox artifact. No tab names found in jasper.properties");
                throw new BAMToolboxDeploymentException("Invalid tbox artifact. No tab names found in jasper.properties");
            }
        } else {
            toolBoxDTO.setJasperParentDirectory(null);
            log.error((Object)"Invalid tbox artifact. No property dashboard.tabsfound in jasper.properties");
            throw new BAMToolboxDeploymentException("Invalid tbox artifact. No property dashboard.tabsfound in jasper.properties");
        }
    }

    private void setTabAndGadgetNames(ToolBoxDTO toolBoxDTO, Properties props) throws BAMToolboxDeploymentException {
        String tabs = props.getProperty("dashboard.tabs").trim();
        if (null != tabs && !tabs.equals("")) {
            String[] tabVarNames = tabs.split(",");
            if (tabVarNames == null || tabVarNames.length == 0) {
                throw new BAMToolboxDeploymentException("Invalid tbox artifact. No tabs found in dashboard.properties");
            }
            boolean valid = false;
            for (String aTabVarName : tabVarNames) {
                if (aTabVarName.trim().equals("")) continue;
                valid = true;
                DashBoardTabDTO tabDTO = new DashBoardTabDTO();
                String tabName = props.getProperty("dashboard.tabs." + aTabVarName.trim() + "." + "name");
                if (null == tabName || tabName.equals("")) {
                    tabName = aTabVarName;
                }
                tabDTO.setTabName(tabName);
                toolBoxDTO.addDashboradTab(tabDTO);
                String gadgets = props.getProperty("dashboard.tabs." + aTabVarName.trim() + "." + "gadgets");
                if (null != gadgets && !gadgets.trim().equals("")) {
                    String[] gadgetNames;
                    for (String aGadget : gadgetNames = gadgets.trim().split(",")) {
                        if (null != aGadget && !aGadget.trim().equals("")) {
                            tabDTO.addGadget(aGadget.trim());
                            continue;
                        }
                        log.warn((Object)("Empty gadget name found for tab: " + tabName));
                    }
                    continue;
                }
                log.warn((Object)("No gadgets are specified for tab: " + tabName));
            }
            if (!valid) {
                toolBoxDTO.setGagetsParentDirectory(null);
                log.error((Object)"Invalid tbox artifact. No tab names found in dashboard.properties");
                throw new BAMToolboxDeploymentException("Invalid tbox artifact. No tab names found in dashboard.properties");
            }
        } else {
            toolBoxDTO.setGagetsParentDirectory(null);
            log.error((Object)"Invalid tbox artifact. No property dashboard.tabsfound in dashboard.properties");
            throw new BAMToolboxDeploymentException("Invalid tbox artifact. No property dashboard.tabsfound in dashboard.properties");
        }
    }

    private void setGadgetNamesForTab(DashBoardTabDTO dashBoardTabDTO, String gagetXmlsNames) throws BAMToolboxDeploymentException {
        if (gagetXmlsNames != null && !gagetXmlsNames.trim().equals("")) {
            String[] gadgets = gagetXmlsNames.split(",");
            if (gadgets == null || gadgets.length == 0) {
                throw new BAMToolboxDeploymentException("Invalid tbox artifact. No gadget names found for tab :" + dashBoardTabDTO + " in dashboard.properties");
            }
            boolean valid = false;
            for (String aGadget : gadgets) {
                if (aGadget.trim().equals("")) continue;
                valid = true;
                dashBoardTabDTO.addGadget(aGadget.trim());
            }
            if (!valid) {
                throw new BAMToolboxDeploymentException("Invalid tbox artifact. No gadget names found for tab :" + dashBoardTabDTO + " in dashboard.properties");
            }
        } else {
            throw new BAMToolboxDeploymentException("No jrxml files specified for tab :" + dashBoardTabDTO.getTabName());
        }
    }

    private void setJRXMLForTab(JasperTabDTO jasperTabDTO, String jrxmlFileName) throws BAMToolboxDeploymentException {
        if (jrxmlFileName == null || jrxmlFileName.trim().equals("")) {
            throw new BAMToolboxDeploymentException("No jrxml file specified for tab :" + jasperTabDTO.getTabName());
        }
        String jrxmlFile = jrxmlFileName.trim();
        jasperTabDTO.setJrxmlFileName(jrxmlFile);
    }

    private ArrayList<String> getFilesInDirectory(String dirPath) throws BAMToolboxDeploymentException {
        String[] children;
        File dir = new File(dirPath);
        ArrayList<String> files = new ArrayList<String>();
        if (dir.exists() && null != (children = dir.list())) {
            for (String aChildren : children) {
                if (new File(aChildren).isDirectory()) continue;
                files.add(aChildren);
            }
        }
        return files;
    }

    static {
        log = LogFactory.getLog(BAMArtifactProcessor.class);
    }
}

