/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bam.toolbox.deployer.config;

import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.bam.toolbox.deployer.ServiceHolder;
import org.wso2.carbon.bam.toolbox.deployer.config.ToolBoxConfiguration;
import org.wso2.carbon.bam.toolbox.deployer.exception.BAMToolboxDeploymentException;
import org.wso2.carbon.bam.toolbox.deployer.util.DashBoardTabDTO;
import org.wso2.carbon.bam.toolbox.deployer.util.JasperTabDTO;
import org.wso2.carbon.bam.toolbox.deployer.util.ToolBoxDTO;
import org.wso2.carbon.registry.core.Collection;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.ResourceImpl;
import org.wso2.carbon.registry.core.exceptions.RegistryException;

public class ToolBoxConfigurationManager {
    private static ToolBoxConfigurationManager instance;
    private static final Log log;

    private ToolBoxConfigurationManager() {
    }

    public static ToolBoxConfigurationManager getInstance() {
        if (null == instance) {
            instance = new ToolBoxConfigurationManager();
        }
        return instance;
    }

    public void addNewToolBoxConfiguration(ToolBoxDTO toolboxDTO, int tenantId) throws BAMToolboxDeploymentException {
        ToolBoxConfiguration configuration = this.createToolBoxConf(toolboxDTO);
        try {
            Registry registry = ServiceHolder.getRegistry(tenantId);
            this.saveNewConfiguration(registry, configuration.toString(), toolboxDTO.getName());
        }
        catch (RegistryException e) {
            log.error((Object)("Error while retrieving the registry services for tenent id:" + tenantId));
            throw new BAMToolboxDeploymentException("Error while retrieving the registry services for tenent id:" + tenantId, e);
        }
    }

    public ToolBoxDTO getToolBox(String aToolName, int tenantId) throws BAMToolboxDeploymentException {
        ToolBoxConfiguration configuration = this.getToolBoxConfiguration(aToolName, tenantId);
        ToolBoxDTO aToolBox = new ToolBoxDTO(aToolName);
        aToolBox.setScriptNames(configuration.getScriptNames());
        aToolBox.setDashboardTabs(configuration.getDashboardTabs());
        aToolBox.setJasperTabs(configuration.getJasperTabs());
        aToolBox.setDataSource(configuration.getDataSource());
        aToolBox.setDataSourceConfiguration(configuration.getDataSourceConfiguration());
        return aToolBox;
    }

    public void deleteToolBoxConfiguration(String toolBoxName, int tenantId) throws BAMToolboxDeploymentException {
        String path = "/repository/conf/org.wso2.carbon.bam/toolbox/" + toolBoxName;
        try {
            Registry registry = ServiceHolder.getRegistry(tenantId);
            registry.delete(path);
        }
        catch (RegistryException e) {
            log.error((Object)("Error while loading the registry for tenant:" + tenantId + " for delete tool box configuration"), (Throwable)e);
            throw new BAMToolboxDeploymentException("Error while loading the registry for tenant:" + tenantId + " for delete tool box configuration", e);
        }
    }

    public ArrayList<String> getAllToolBoxNames(int tenantId) throws BAMToolboxDeploymentException {
        try {
            ArrayList<String> toolNames = new ArrayList<String>();
            Registry registry = ServiceHolder.getRegistry(tenantId);
            String path = "/repository/conf/org.wso2.carbon.bam/toolbox";
            if (registry.resourceExists(path) && registry.get(path) instanceof Collection) {
                Collection collection = (Collection)registry.get(path);
                for (String aToolPath : collection.getChildren()) {
                    Resource childResource = registry.get(aToolPath);
                    if (childResource instanceof Collection) continue;
                    String name = ((ResourceImpl)childResource).getName();
                    toolNames.add(name);
                }
            }
            return toolNames;
        }
        catch (RegistryException e) {
            log.error((Object)("Error while retrieving registry for tenant:" + tenantId + " to get " + "list of toolbox in configuration"), (Throwable)e);
            throw new BAMToolboxDeploymentException("Error while retrieving registry for tenant:" + tenantId + " to get " + "list of toolbox in configuration", e);
        }
    }

    private ToolBoxConfiguration createToolBoxConf(ToolBoxDTO toolboxDTO) throws BAMToolboxDeploymentException {
        ToolBoxConfiguration configuration = new ToolBoxConfiguration(toolboxDTO.getName());
        for (String string : toolboxDTO.getScriptNames()) {
            configuration.addScript(string);
        }
        for (DashBoardTabDTO dashBoardTabDTO : toolboxDTO.getDashboardTabs()) {
            ArrayList<String> gadgets = dashBoardTabDTO.getGadgets();
            for (String aGadget : gadgets) {
                configuration.addGadgetToTab(dashBoardTabDTO.getTabId(), aGadget);
            }
        }
        for (JasperTabDTO jasperTabDTO : toolboxDTO.getJasperTabs()) {
            String jrxmlFileName = jasperTabDTO.getJrxmlFileName();
            String tabName = jasperTabDTO.getTabName();
            configuration.addJRXMLToTab(jasperTabDTO.getTabId(), jrxmlFileName, tabName);
        }
        configuration.addDataSource(toolboxDTO.getDataSource());
        configuration.addDataSourceConfiguration(toolboxDTO.getDataSourceConfiguration());
        return configuration;
    }

    private ToolBoxConfiguration getToolBoxConfiguration(String toolBoxName, int tenantId) throws BAMToolboxDeploymentException {
        try {
            Registry registry = ServiceHolder.getRegistry(tenantId);
            String path = "/repository/conf/org.wso2.carbon.bam/toolbox" + File.separator + toolBoxName;
            if (registry.resourceExists(path)) {
                Resource resource = registry.get(path);
                InputStream content = resource.getContentStream();
                OMElement config = new StAXOMBuilder(content).getDocumentElement();
                return new ToolBoxConfiguration(toolBoxName, config);
            }
            return new ToolBoxConfiguration(toolBoxName, null);
        }
        catch (RegistryException e) {
            log.error((Object)("Error while retrieving registry for tenant:" + tenantId + " to get " + "configuration file for toolbox:" + toolBoxName), (Throwable)e);
            throw new BAMToolboxDeploymentException("Error while retrieving registry for tenant:" + tenantId + " to get " + "configuration file for toolbox:" + toolBoxName, e);
        }
        catch (XMLStreamException e) {
            log.error((Object)("Error while processing configuration xml for tenant:" + tenantId + " for " + " toolbox:" + toolBoxName), (Throwable)e);
            throw new BAMToolboxDeploymentException("Error while processing configuration xml for tenant:" + tenantId + " for " + " toolbox:" + toolBoxName, e);
        }
    }

    private void saveNewConfiguration(Registry registry, String configContent, String toolboxName) throws BAMToolboxDeploymentException {
        try {
            Resource resource = registry.newResource();
            resource.setContent((Object)configContent);
            String path = "/repository/conf/org.wso2.carbon.bam/toolbox/" + toolboxName;
            registry.put(path, resource);
        }
        catch (RegistryException e) {
            log.error((Object)("Error while saving the configuration file for the tool box:" + toolboxName + " in registry"), (Throwable)e);
            throw new BAMToolboxDeploymentException("Error while saving the configuration file for the tool box:" + toolboxName + " in registry", e);
        }
    }

    static {
        log = LogFactory.getLog(ToolBoxConfigurationManager.class);
    }
}

