/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bam.toolbox.deployer.config;

import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.bam.toolbox.deployer.exception.BAMToolboxDeploymentException;
import org.wso2.carbon.bam.toolbox.deployer.util.DashBoardTabDTO;
import org.wso2.carbon.bam.toolbox.deployer.util.JasperTabDTO;

public class ToolBoxConfiguration {
    private OMElement config;
    private String toolboxName;
    private static String SCRIPTS = "scripts";
    private static String SCRIPT = "script";
    private static String DASHBOARD = "dashboard";
    private static String GADGETS = "gadgets";
    private static String GADGET = "gadget";
    private static String TAB = "tab";
    private static String JRXML_TAB = "jrxmlTab";
    private static String JRXML = "jrxml";
    private static String TAB_ID = "id";
    private static String TAB_NAME = "name";
    private static String DATASOURCE = "datasource";
    private static String CONFIGURATION = "configuration";
    private static final Log log = LogFactory.getLog(ToolBoxConfiguration.class);

    public ToolBoxConfiguration(String name) {
        this.toolboxName = name;
        this.createRootElement();
    }

    public ToolBoxConfiguration(String name, OMElement config) {
        this.toolboxName = name;
        this.config = config;
    }

    public void addDataSource(String datasource) {
        this.config.addAttribute(DATASOURCE, datasource, null);
    }

    public void addDataSourceConfiguration(String dsConfiguration) {
        this.config.addAttribute(CONFIGURATION, dsConfiguration, null);
    }

    public void addScript(String scriptName) throws BAMToolboxDeploymentException {
        Iterator iterator = this.config.getChildrenWithName(new QName(SCRIPTS));
        if (iterator == null || !iterator.hasNext()) {
            throw new BAMToolboxDeploymentException("Cannot find " + SCRIPTS + "node in the " + "configuration file when adding script name: " + scriptName + " for tool box :" + this.toolboxName);
        }
        OMElement scripts = (OMElement)iterator.next();
        OMFactory fac = OMAbstractFactory.getOMFactory();
        OMElement script = fac.createOMElement(new QName(SCRIPT));
        script.setText(scriptName);
        scripts.addChild((OMNode)script);
    }

    private void createRootElement() {
        OMFactory fac = OMAbstractFactory.getOMFactory();
        String ROOT = "toolbox";
        this.config = fac.createOMElement(new QName(ROOT));
        String NAME = "name";
        this.config.addAttribute(NAME, this.toolboxName, null);
        OMElement scripts = fac.createOMElement(new QName(SCRIPTS));
        this.config.addChild((OMNode)scripts);
        OMElement dashboard = fac.createOMElement(new QName(DASHBOARD));
        this.config.addChild((OMNode)dashboard);
    }

    private void addGadget(String gadgetName, OMElement element) throws BAMToolboxDeploymentException {
        OMFactory fac = OMAbstractFactory.getOMFactory();
        OMElement gadgetElement = fac.createOMElement(new QName(GADGET));
        gadgetElement.setText(gadgetName);
        element.addChild((OMNode)gadgetElement);
    }

    public void addGadgetToTab(int tabId, String gadgetName) throws BAMToolboxDeploymentException {
        Iterator iterator = this.config.getChildrenWithName(new QName(DASHBOARD));
        OMElement tabElement = null;
        if (iterator != null && iterator.hasNext()) {
            OMElement dashboard = (OMElement)iterator.next();
            Iterator tabIterator = dashboard.getChildrenWithName(new QName(TAB));
            while (tabIterator.hasNext()) {
                int aTabId;
                OMElement aTab = (OMElement)tabIterator.next();
                String strTabId = aTab.getAttribute(new QName(TAB_ID)).getAttributeValue();
                if (strTabId == null || (aTabId = Integer.parseInt(strTabId)) != tabId) continue;
                tabElement = aTab;
                break;
            }
            if (null == tabElement) {
                OMFactory fac = OMAbstractFactory.getOMFactory();
                tabElement = fac.createOMElement(new QName(TAB));
                tabElement.addAttribute(TAB_ID, String.valueOf(tabId), null);
                dashboard.addChild((OMNode)tabElement);
            }
        } else {
            throw new BAMToolboxDeploymentException("Cannot find " + GADGETS + "node in the " + "configuration file when adding gadget name: " + gadgetName + " for tool box :" + this.toolboxName);
        }
        this.addGadget(gadgetName, tabElement);
    }

    public void addJRXMLToTab(int tabId, String jrxmlName, String tabName) throws BAMToolboxDeploymentException {
        OMFactory fac;
        Iterator iterator = this.config.getChildrenWithName(new QName(DASHBOARD));
        OMElement tabElement = null;
        if (iterator != null && iterator.hasNext()) {
            OMElement dashboard = (OMElement)iterator.next();
            Iterator tabIterator = dashboard.getChildrenWithName(new QName(JRXML_TAB));
            while (tabIterator.hasNext()) {
                int aTabId;
                OMElement aTab = (OMElement)tabIterator.next();
                String strTabId = aTab.getAttribute(new QName(TAB_ID)).getAttributeValue();
                if (strTabId == null || (aTabId = Integer.parseInt(strTabId)) != tabId) continue;
                tabElement = aTab;
                break;
            }
            if (null == tabElement) {
                fac = OMAbstractFactory.getOMFactory();
                tabElement = fac.createOMElement(new QName(JRXML_TAB));
                tabElement.addAttribute(TAB_ID, String.valueOf(tabId), null);
                tabElement.addAttribute(TAB_NAME, tabName, null);
                dashboard.addChild((OMNode)tabElement);
            }
        } else {
            throw new BAMToolboxDeploymentException("Cannot find " + JRXML + "node in the " + "configuration file when adding jrxml name: " + jrxmlName + " for tool box :" + this.toolboxName);
        }
        fac = OMAbstractFactory.getOMFactory();
        OMElement jrxmlElement = fac.createOMElement(new QName(JRXML));
        jrxmlElement.setText(jrxmlName);
        tabElement.addChild((OMNode)jrxmlElement);
    }

    public String toString() {
        return this.config.toString();
    }

    public ArrayList<String> getScriptNames() throws BAMToolboxDeploymentException {
        if (null != this.config) {
            ArrayList<String> scripts = new ArrayList<String>();
            Iterator iterator = this.config.getChildrenWithName(new QName(SCRIPTS));
            if (iterator != null && iterator.hasNext()) {
                Iterator scriptIterator = ((OMElement)iterator.next()).getChildrenWithName(new QName(SCRIPT));
                if (scriptIterator != null && scriptIterator.hasNext()) {
                    while (scriptIterator.hasNext()) {
                        OMElement script = (OMElement)scriptIterator.next();
                        String scriptName = script.getText();
                        scripts.add(scriptName);
                    }
                    return scripts;
                }
                return scripts;
            }
            log.warn((Object)("No scripts are found for tool box:" + this.toolboxName));
            return scripts;
        }
        log.error((Object)("Configuration has not been set for the tool box:" + this.toolboxName));
        throw new BAMToolboxDeploymentException("Configuration has not been set for the tool box:" + this.toolboxName);
    }

    public String getDataSource() {
        return this.config.getAttribute(new QName(DATASOURCE)).getAttributeValue();
    }

    public String getDataSourceConfiguration() {
        return this.config.getAttribute(new QName(CONFIGURATION)).getAttributeValue();
    }

    public ArrayList<DashBoardTabDTO> getDashboardTabs() throws BAMToolboxDeploymentException {
        if (null != this.config) {
            ArrayList<DashBoardTabDTO> tabs = new ArrayList<DashBoardTabDTO>();
            Iterator dashboardIterator = this.config.getChildrenWithName(new QName(DASHBOARD));
            if (null != dashboardIterator && dashboardIterator.hasNext()) {
                OMElement dashBoadElement = (OMElement)dashboardIterator.next();
                Iterator tabIterator = dashBoadElement.getChildrenWithName(new QName(TAB));
                if (null != tabIterator && tabIterator.hasNext()) {
                    while (tabIterator.hasNext()) {
                        OMElement tabElement = (OMElement)tabIterator.next();
                        String tabId = tabElement.getAttributeValue(new QName(TAB_ID));
                        DashBoardTabDTO tabDTO = new DashBoardTabDTO();
                        tabDTO.setTabId(Integer.parseInt(tabId));
                        Iterator gadgetIterator = tabElement.getChildrenWithName(new QName(GADGET));
                        while (gadgetIterator.hasNext()) {
                            OMElement gadget = (OMElement)gadgetIterator.next();
                            tabDTO.addGadget(gadget.getText());
                        }
                        tabs.add(tabDTO);
                    }
                }
                return tabs;
            }
            log.warn((Object)("No dashboard configuration is found for tool box:" + this.toolboxName));
            return tabs;
        }
        log.error((Object)("Configuration has not been set for the tool box:" + this.toolboxName));
        throw new BAMToolboxDeploymentException("Configuration has not been set for the tool box:" + this.toolboxName);
    }

    public ArrayList<JasperTabDTO> getJasperTabs() throws BAMToolboxDeploymentException {
        if (null != this.config) {
            ArrayList<JasperTabDTO> tabs = new ArrayList<JasperTabDTO>();
            Iterator dashboardIterator = this.config.getChildrenWithName(new QName(DASHBOARD));
            if (null != dashboardIterator && dashboardIterator.hasNext()) {
                OMElement dashBoadElement = (OMElement)dashboardIterator.next();
                Iterator tabIterator = dashBoadElement.getChildrenWithName(new QName(JRXML_TAB));
                if (null != tabIterator && tabIterator.hasNext()) {
                    while (tabIterator.hasNext()) {
                        OMElement tabElement = (OMElement)tabIterator.next();
                        String tabId = tabElement.getAttributeValue(new QName(TAB_ID));
                        String tabName = tabElement.getAttributeValue(new QName(TAB_NAME));
                        JasperTabDTO tabDTO = new JasperTabDTO();
                        tabDTO.setTabId(Integer.parseInt(tabId));
                        tabDTO.setTabName(tabName);
                        Iterator jrxmlIterator = tabElement.getChildrenWithName(new QName(JRXML));
                        while (jrxmlIterator.hasNext()) {
                            OMElement jrxml = (OMElement)jrxmlIterator.next();
                            tabDTO.setJrxmlFileName(jrxml.getText());
                        }
                        tabs.add(tabDTO);
                    }
                }
                return tabs;
            }
            log.warn((Object)("No dashboard configuration is found for tool box:" + this.toolboxName));
            return tabs;
        }
        log.error((Object)("Configuration has not been set for the tool box:" + this.toolboxName));
        throw new BAMToolboxDeploymentException("Configuration has not been set for the tool box:" + this.toolboxName);
    }
}

