/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bam.toolbox.deployer.client;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.analytics.hive.exception.HiveScriptStoreException;
import org.wso2.carbon.analytics.hive.web.HiveScriptStoreService;
import org.wso2.carbon.bam.toolbox.deployer.exception.BAMComponentNotFoundException;

public class HiveScriptStoreClient {
    private static Log log = LogFactory.getLog(HiveScriptStoreClient.class);
    private static HiveScriptStoreClient instance;
    private static HiveScriptStoreService service;

    private HiveScriptStoreClient() throws BAMComponentNotFoundException {
        try {
            service = new HiveScriptStoreService();
        }
        catch (Exception ex) {
            log.info((Object)"No Hive Script store service available..");
            throw new BAMComponentNotFoundException("No Hive Script store service available..");
        }
    }

    public static HiveScriptStoreClient getInstance() throws BAMComponentNotFoundException {
        if (null == instance) {
            instance = new HiveScriptStoreClient();
        }
        return instance;
    }

    public void saveHiveScript(String scriptName, String scriptContent, String cron) {
        try {
            service.saveHiveScript(scriptName, scriptContent, cron);
        }
        catch (HiveScriptStoreException e) {
            log.error((Object)"Error while saving the hive script", (Throwable)e);
        }
    }

    public void deleteScript(String scriptName) {
        try {
            service.deleteScript(scriptName);
        }
        catch (HiveScriptStoreException e) {
            log.error((Object)"Error while deleting the hive script", (Throwable)e);
        }
    }
}

