/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bam.toolbox.deployer.client;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.bam.toolbox.deployer.ServiceHolder;
import org.wso2.carbon.bam.toolbox.deployer.exception.BAMToolboxDeploymentException;
import org.wso2.carbon.databridge.commons.exception.DifferentStreamDefinitionAlreadyDefinedException;
import org.wso2.carbon.databridge.commons.exception.MalformedStreamDefinitionException;
import org.wso2.carbon.databridge.commons.exception.SessionTimeoutException;
import org.wso2.carbon.databridge.core.DataBridgeReceiverService;

public class DataPublisher {
    private static DataPublisher instance;
    private static DataBridgeReceiverService receiverService;
    private static Log log;

    private DataPublisher() {
        receiverService = ServiceHolder.getDataBridgeReceiverService();
        if (null == receiverService) {
            log.warn((Object)"Databridge reciever service is not available...");
        }
    }

    public static DataPublisher getInstance() {
        if (null == instance) {
            instance = new DataPublisher();
        }
        return instance;
    }

    public void createEventDefn(String defn, String username, String password) throws BAMToolboxDeploymentException {
        try {
            String session = receiverService.login(username, password);
            try {
                receiverService.defineStream(session, defn);
            }
            catch (DifferentStreamDefinitionAlreadyDefinedException e1) {
                log.warn((Object)e1.getMessage());
            }
            catch (MalformedStreamDefinitionException e1) {
                log.error((Object)e1);
                throw new BAMToolboxDeploymentException(e1.getMessage(), e1);
            }
            catch (SessionTimeoutException e1) {
                log.error((Object)e1);
            }
        }
        catch (Exception e) {
            log.warn((Object)"Logout in DataReceiver is not successful...");
        }
    }

    static {
        log = LogFactory.getLog(DataPublisher.class);
    }
}

