/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bam.toolbox.deployer.client;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.bam.toolbox.deployer.ServiceHolder;
import org.wso2.carbon.bam.toolbox.deployer.exception.BAMComponentNotFoundException;
import org.wso2.carbon.dashboard.DashboardDSService;

public class DashboardClient {
    private static Log log = LogFactory.getLog(DashboardClient.class);
    private DashboardDSService service = ServiceHolder.getDashboardService();
    private static DashboardClient instance;

    private DashboardClient() throws BAMComponentNotFoundException {
        if (this.service == null) {
            log.warn((Object)"No Dashboard service class found.");
            throw new BAMComponentNotFoundException("No Dashboard service class found");
        }
    }

    public static DashboardClient getInstance() throws BAMComponentNotFoundException {
        if (null == instance) {
            instance = new DashboardClient();
        }
        return instance;
    }

    public boolean addNewGadget(String userId, String tabId, String url) {
        try {
            return this.service.addGadgetToUser(userId, tabId, url, null, null);
        }
        catch (Exception e) {
            log.error((Object)"Exception while adding a new gadget", (Throwable)e);
            return false;
        }
    }

    public int addTab(String userId, String tabTitle) {
        try {
            int tabId = this.service.addNewTab(userId, tabTitle, null);
            return tabId;
        }
        catch (Exception e) {
            log.error((Object)"Exception while adding a new gadget", (Throwable)e);
            return -1;
        }
    }

    public void removeTab(String userId, int tabId) {
        try {
            this.service.removeTab(userId, String.valueOf(tabId), null);
        }
        catch (Exception e) {
            log.error((Object)("Exception while deleting tab: " + tabId), (Throwable)e);
        }
    }
}

