/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bam.toolbox.deployer.ui.upload;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.axis2.context.ConfigurationContext;
import org.wso2.carbon.CarbonException;
import org.wso2.carbon.bam.toolbox.deployer.stub.BAMToolboxDepolyerServiceBAMToolboxDeploymentExceptionException;
import org.wso2.carbon.bam.toolbox.deployer.stub.BAMToolboxDepolyerServiceStub;
import org.wso2.carbon.bam.toolbox.deployer.ui.client.BAMToolBoxDeployerClient;
import org.wso2.carbon.ui.CarbonUIUtil;
import org.wso2.carbon.ui.transports.fileupload.AbstractFileUploadExecutor;
import org.wso2.carbon.utils.FileItemData;

public class ToolBoxUploader
extends AbstractFileUploadExecutor {
    public boolean execute(HttpServletRequest request, HttpServletResponse response) throws CarbonException, IOException {
        String webContext = (String)request.getAttribute("WebContext");
        HttpSession session = request.getSession();
        String serverURL = CarbonUIUtil.getServerURL((ServletContext)session.getServletContext(), (HttpSession)session);
        ConfigurationContext configContext = (ConfigurationContext)session.getServletContext().getAttribute("ConfigurationContext");
        String cookie = (String)session.getAttribute("wso2carbon.admin.service.cookie");
        BAMToolBoxDeployerClient client = new BAMToolBoxDeployerClient(cookie, serverURL, configContext);
        Map fileItemsMap = this.getFileItemsMap();
        Map formFields = this.getFormFieldsMap();
        String selectedType = (String)((ArrayList)formFields.get("selectedToolType")).get(0);
        if (selectedType.equals("0")) {
            List toolbox = (List)fileItemsMap.get("toolbox");
            FileItemData uploadedTool = (FileItemData)toolbox.get(0);
            try {
                BAMToolboxDepolyerServiceStub.ToolBoxStatusDTO statusDTO = client.getToolBoxStatus("1", null);
                String msg = this.checkInRepo(uploadedTool.getFileItem().getName(), statusDTO);
                if (msg.equals("")) {
                    if (client.uploadToolBox(uploadedTool.getDataHandler(), uploadedTool.getFileItem().getName())) {
                        response.sendRedirect("../" + webContext + "/bam-toolbox/listbar.jsp?success=true");
                    } else {
                        response.sendRedirect("../" + webContext + "/bam-toolbox/uploadbar.jsp?success=false&message=" + "Error while deploying toolbox!");
                    }
                    return true;
                }
                response.sendRedirect("../" + webContext + "/bam-toolbox/uploadbar.jsp?success=false&message=" + msg);
                return false;
            }
            catch (BAMToolboxDepolyerServiceBAMToolboxDeploymentExceptionException e) {
                response.sendRedirect("../" + webContext + "/bam-toolbox/uploadbar.jsp?success=false&message=" + e.getFaultMessage().getBAMToolboxDeploymentException().getMessage());
                return false;
            }
        }
        if (selectedType.equals("-1")) {
            List toolBoxURL = (List)formFields.get("urltoolbox");
            String url = (String)toolBoxURL.get(0);
            int slashIndex = url.lastIndexOf(47);
            String toolName = url.substring(slashIndex + 1);
            BAMToolboxDepolyerServiceStub.ToolBoxStatusDTO statusDTO = null;
            try {
                statusDTO = client.getToolBoxStatus("1", null);
                String msg = this.checkInRepo(toolName, statusDTO);
                if (msg.equals("")) {
                    client.installToolBoxFromURL(url);
                    response.sendRedirect("../" + webContext + "/bam-toolbox/listbar.jsp?success=true");
                    new File("tmp/" + url.substring(slashIndex + 1)).delete();
                    return true;
                }
                response.sendRedirect("../" + webContext + "/bam-toolbox/uploadbar.jsp?success=false&message=" + msg);
                return false;
            }
            catch (BAMToolboxDepolyerServiceBAMToolboxDeploymentExceptionException e) {
                response.sendRedirect("../" + webContext + "/bam-toolbox/uploadbar.jsp?success=false&message=" + e.getFaultMessage().getBAMToolboxDeploymentException().getMessage());
                return false;
            }
        }
        try {
            client.deploySample(selectedType);
            response.sendRedirect("../" + webContext + "/bam-toolbox/listbar.jsp?success=true");
            return true;
        }
        catch (BAMToolboxDepolyerServiceBAMToolboxDeploymentExceptionException e) {
            response.sendRedirect("../" + webContext + "/bam-toolbox/uploadbar.jsp?success=false&message=" + e.getFaultMessage().getBAMToolboxDeploymentException().getMessage());
            return false;
        }
    }

    private String checkInRepo(String toolName, BAMToolboxDepolyerServiceStub.ToolBoxStatusDTO statusDTO) {
        toolName = toolName.replaceAll(".tbox", "");
        String msg = "";
        if (this.isInList(toolName, statusDTO.getDeployedTools())) {
            msg = "The uploaded toolbox is already Installed. \nPlease upload a different toolbox.";
            return msg;
        }
        if (this.isInList(toolName, statusDTO.getToBeDeployedTools())) {
            msg = "The uploaded toolbox is already Installing. \nPlease wait until it's installed.";
            return msg;
        }
        if (this.isInList(toolName, statusDTO.getToBeUndeployedTools())) {
            msg = "The uploaded toolbox is Un-installing. \nPlease wait until it's un-installed.";
            return msg;
        }
        return msg;
    }

    private boolean isInList(String name, String[] searchList) {
        if (null != searchList) {
            for (String aName : searchList) {
                if (!name.equalsIgnoreCase(aName)) continue;
                return true;
            }
            return false;
        }
        return false;
    }
}

